/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.ws;

import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.Buffer;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nWebSocketProtocol.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebSocketProtocol.kt\nokhttp3/internal/ws/WebSocketProtocol\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,141:1\n1#2:142\n*E\n"})
public final class WebSocketProtocol {
    @NotNull
    public static final WebSocketProtocol INSTANCE = new WebSocketProtocol();
    @NotNull
    public static final String ACCEPT_MAGIC = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
    public static final int B0_FLAG_FIN = 128;
    public static final int B0_FLAG_RSV1 = 64;
    public static final int B0_FLAG_RSV2 = 32;
    public static final int B0_FLAG_RSV3 = 16;
    public static final int B0_MASK_OPCODE = 15;
    public static final int OPCODE_FLAG_CONTROL = 8;
    public static final int B1_FLAG_MASK = 128;
    public static final int B1_MASK_LENGTH = 127;
    public static final int OPCODE_CONTINUATION = 0;
    public static final int OPCODE_TEXT = 1;
    public static final int OPCODE_BINARY = 2;
    public static final int OPCODE_CONTROL_CLOSE = 8;
    public static final int OPCODE_CONTROL_PING = 9;
    public static final int OPCODE_CONTROL_PONG = 10;
    public static final long PAYLOAD_BYTE_MAX = 125L;
    public static final long CLOSE_MESSAGE_MAX = 123L;
    public static final int PAYLOAD_SHORT = 126;
    public static final long PAYLOAD_SHORT_MAX = 65535L;
    public static final int PAYLOAD_LONG = 127;
    public static final int CLOSE_CLIENT_GOING_AWAY = 1001;
    public static final int CLOSE_NO_STATUS_CODE = 1005;

    private WebSocketProtocol() {
    }

    public final void toggleMask(@NotNull Buffer.UnsafeCursor cursor2, @NotNull byte[] key2) {
        Intrinsics.checkNotNullParameter((Object)cursor2, (String)"cursor");
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        int keyIndex = 0;
        int keyLength = key2.length;
        do {
            byte[] buffer = cursor2.data;
            int i2 = cursor2.start;
            int end = cursor2.end;
            if (buffer == null) continue;
            while (i2 < end) {
                byte bufferInt = buffer[i2];
                byte keyInt = key2[keyIndex %= keyLength];
                buffer[i2] = (byte)(bufferInt ^ keyInt);
                ++i2;
                ++keyIndex;
            }
        } while (cursor2.next() != -1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final String closeCodeExceptionMessage(int code) {
        String string;
        if (code < 1000 || code >= 5000) {
            string = "Code must be in range [1000,5000): " + code;
            return string;
        }
        if (!(1004 <= code ? code < 1007 : false)) {
            if (1015 > code) return null;
            if (code >= 3000) return null;
            boolean bl = true;
            if (!bl) return null;
        }
        string = "Code " + code + " is reserved and may not be used.";
        return string;
    }

    public final void validateCloseCode(int code) {
        String message2 = this.closeCodeExceptionMessage(code);
        if (!(message2 == null)) {
            boolean bl = false;
            String string = message2;
            Intrinsics.checkNotNull((Object)string);
            String string2 = string;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    @NotNull
    public final String acceptHeader(@NotNull String key2) {
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        return ByteString.Companion.encodeUtf8(key2 + ACCEPT_MAGIC).sha1().base64();
    }
}

