/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.tls;

import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.X509TrustManager;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.internal.platform.Platform;
import okhttp3.internal.tls.BasicCertificateChainCleaner;
import okhttp3.internal.tls.BasicTrustRootIndex;
import org.jetbrains.annotations.NotNull;

public abstract class CertificateChainCleaner {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public abstract List<Certificate> clean(@NotNull List<? extends Certificate> var1, @NotNull String var2) throws SSLPeerUnverifiedException;

    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CertificateChainCleaner get(@NotNull X509TrustManager trustManager) {
            Intrinsics.checkNotNullParameter((Object)trustManager, (String)"trustManager");
            return Platform.Companion.get().buildCertificateChainCleaner(trustManager);
        }

        @NotNull
        public final CertificateChainCleaner get(X509Certificate ... caCerts) {
            Intrinsics.checkNotNullParameter((Object)caCerts, (String)"caCerts");
            return new BasicCertificateChainCleaner(new BasicTrustRootIndex(Arrays.copyOf(caCerts, caCerts.length)));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

