/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.platform;

import android.annotation.SuppressLint;
import android.os.Build;
import android.security.NetworkSecurityPolicy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.Protocol;
import okhttp3.internal.SuppressSignatureCheck;
import okhttp3.internal.platform.Platform;
import okhttp3.internal.platform.android.Android10SocketAdapter;
import okhttp3.internal.platform.android.AndroidCertificateChainCleaner;
import okhttp3.internal.platform.android.AndroidSocketAdapter;
import okhttp3.internal.platform.android.BouncyCastleSocketAdapter;
import okhttp3.internal.platform.android.ConscryptSocketAdapter;
import okhttp3.internal.platform.android.DeferredSocketAdapter;
import okhttp3.internal.platform.android.SocketAdapter;
import okhttp3.internal.tls.CertificateChainCleaner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SuppressSignatureCheck
@SourceDebugExtension(value={"SMAP\nAndroid10Platform.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Android10Platform.kt\nokhttp3/internal/platform/Android10Platform\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,72:1\n766#2:73\n857#2,2:74\n1#3:76\n*S KotlinDebug\n*F\n+ 1 Android10Platform.kt\nokhttp3/internal/platform/Android10Platform\n*L\n43#1:73\n43#1:74,2\n*E\n"})
public final class Android10Platform
extends Platform {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<SocketAdapter> socketAdapters;
    private static final boolean isSupported = Platform.Companion.isAndroid() && Build.VERSION.SDK_INT >= 29;

    /*
     * WARNING - void declaration
     */
    public Android10Platform() {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Object object = new SocketAdapter[]{Android10SocketAdapter.Companion.buildIfSupported(), new DeferredSocketAdapter(AndroidSocketAdapter.Companion.getPlayProviderFactory()), new DeferredSocketAdapter(ConscryptSocketAdapter.Companion.getFactory()), new DeferredSocketAdapter(BouncyCastleSocketAdapter.Companion.getFactory())};
        object = CollectionsKt.listOfNotNull((Object[])object);
        Android10Platform android10Platform = this;
        boolean $i$f$filter = false;
        void var3_4 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            SocketAdapter it = (SocketAdapter)element$iv$iv;
            boolean bl = false;
            if (!it.isSupported()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        android10Platform.socketAdapters = (List)destination$iv$iv;
    }

    @Override
    @Nullable
    public X509TrustManager trustManager(@NotNull SSLSocketFactory sslSocketFactory) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)sslSocketFactory, (String)"sslSocketFactory");
            Iterable iterable = this.socketAdapters;
            for (Object t2 : iterable) {
                SocketAdapter it = (SocketAdapter)t2;
                boolean bl = false;
                if (!it.matchesSocketFactory(sslSocketFactory)) continue;
                v0 = t2;
                break block1;
            }
            v0 = null;
        }
        SocketAdapter socketAdapter = v0;
        return socketAdapter != null ? socketAdapter.trustManager(sslSocketFactory) : null;
    }

    public void configureTlsExtensions(@NotNull SSLSocket sslSocket, @Nullable String hostname, @NotNull List<? extends Protocol> protocols) {
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter((Object)sslSocket, (String)"sslSocket");
            Intrinsics.checkNotNullParameter(protocols, (String)"protocols");
            Iterable iterable = this.socketAdapters;
            for (Object t2 : iterable) {
                SocketAdapter it = (SocketAdapter)t2;
                boolean bl = false;
                if (!it.matchesSocket(sslSocket)) continue;
                v0 = t2;
                break block2;
            }
            v0 = null;
        }
        SocketAdapter socketAdapter = v0;
        if (socketAdapter != null) {
            socketAdapter.configureTlsExtensions(sslSocket, hostname, protocols);
        }
    }

    @Override
    @Nullable
    public String getSelectedProtocol(@NotNull SSLSocket sslSocket) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)sslSocket, (String)"sslSocket");
            Iterable iterable = this.socketAdapters;
            for (Object t2 : iterable) {
                SocketAdapter it = (SocketAdapter)t2;
                boolean bl = false;
                if (!it.matchesSocket(sslSocket)) continue;
                v0 = t2;
                break block1;
            }
            v0 = null;
        }
        SocketAdapter socketAdapter = v0;
        return socketAdapter != null ? socketAdapter.getSelectedProtocol(sslSocket) : null;
    }

    @Override
    @SuppressLint(value={"NewApi"})
    public boolean isCleartextTrafficPermitted(@NotNull String hostname) {
        Intrinsics.checkNotNullParameter((Object)hostname, (String)"hostname");
        return NetworkSecurityPolicy.getInstance().isCleartextTrafficPermitted(hostname);
    }

    @Override
    @NotNull
    public CertificateChainCleaner buildCertificateChainCleaner(@NotNull X509TrustManager trustManager) {
        Intrinsics.checkNotNullParameter((Object)trustManager, (String)"trustManager");
        AndroidCertificateChainCleaner androidCertificateChainCleaner = AndroidCertificateChainCleaner.Companion.buildIfSupported(trustManager);
        return androidCertificateChainCleaner != null ? (CertificateChainCleaner)androidCertificateChainCleaner : super.buildCertificateChainCleaner(trustManager);
    }

    public static final class Companion {
        private Companion() {
        }

        public final boolean isSupported() {
            return isSupported;
        }

        @Nullable
        public final Platform buildIfSupported() {
            return this.isSupported() ? (Platform)new Android10Platform() : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

