/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http2;

import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

public final class Settings {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int set;
    @NotNull
    private final int[] values = new int[10];
    public static final int DEFAULT_INITIAL_WINDOW_SIZE = 65535;
    public static final int HEADER_TABLE_SIZE = 1;
    public static final int ENABLE_PUSH = 2;
    public static final int MAX_CONCURRENT_STREAMS = 4;
    public static final int MAX_FRAME_SIZE = 5;
    public static final int MAX_HEADER_LIST_SIZE = 6;
    public static final int INITIAL_WINDOW_SIZE = 7;
    public static final int COUNT = 10;

    public final int getHeaderTableSize() {
        int bit = 2;
        return (bit & this.set) != 0 ? this.values[1] : -1;
    }

    public final int getInitialWindowSize() {
        int bit = 128;
        return (bit & this.set) != 0 ? this.values[7] : 65535;
    }

    public final void clear() {
        this.set = 0;
        ArraysKt.fill$default((int[])this.values, (int)0, (int)0, (int)0, (int)6, null);
    }

    @NotNull
    public final Settings set(int id, int value2) {
        if (id < 0 || id >= this.values.length) {
            return this;
        }
        int bit = 1 << id;
        this.set |= bit;
        this.values[id] = value2;
        return this;
    }

    public final boolean isSet(int id) {
        int bit = 1 << id;
        return (this.set & bit) != 0;
    }

    public final int get(int id) {
        return this.values[id];
    }

    public final int size() {
        return Integer.bitCount(this.set);
    }

    public final boolean getEnablePush(boolean defaultValue) {
        int bit = 4;
        return (bit & this.set) != 0 ? this.values[2] == 1 : defaultValue;
    }

    public final int getMaxConcurrentStreams() {
        int bit = 16;
        return (bit & this.set) != 0 ? this.values[4] : Integer.MAX_VALUE;
    }

    public final int getMaxFrameSize(int defaultValue) {
        int bit = 32;
        return (bit & this.set) != 0 ? this.values[5] : defaultValue;
    }

    public final int getMaxHeaderListSize(int defaultValue) {
        int bit = 64;
        return (bit & this.set) != 0 ? this.values[6] : defaultValue;
    }

    public final void merge(@NotNull Settings other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        for (int i2 = 0; i2 < 10; ++i2) {
            if (!other.isSet(i2)) continue;
            this.set(i2, other.get(i2));
        }
    }

    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

