/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http2;

import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.internal.Util;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;

public final class Http2 {
    @NotNull
    public static final Http2 INSTANCE;
    @JvmField
    @NotNull
    public static final ByteString CONNECTION_PREFACE;
    public static final int INITIAL_MAX_FRAME_SIZE = 16384;
    public static final int TYPE_DATA = 0;
    public static final int TYPE_HEADERS = 1;
    public static final int TYPE_PRIORITY = 2;
    public static final int TYPE_RST_STREAM = 3;
    public static final int TYPE_SETTINGS = 4;
    public static final int TYPE_PUSH_PROMISE = 5;
    public static final int TYPE_PING = 6;
    public static final int TYPE_GOAWAY = 7;
    public static final int TYPE_WINDOW_UPDATE = 8;
    public static final int TYPE_CONTINUATION = 9;
    public static final int FLAG_NONE = 0;
    public static final int FLAG_ACK = 1;
    public static final int FLAG_END_STREAM = 1;
    public static final int FLAG_END_HEADERS = 4;
    public static final int FLAG_END_PUSH_PROMISE = 4;
    public static final int FLAG_PADDED = 8;
    public static final int FLAG_PRIORITY = 32;
    public static final int FLAG_COMPRESSED = 32;
    @NotNull
    private static final String[] FRAME_NAMES;
    @NotNull
    private static final String[] FLAGS;
    @NotNull
    private static final String[] BINARY;

    private Http2() {
    }

    @NotNull
    public final String frameLog(boolean inbound, int streamId, int length, int type2, int flags) {
        String formattedType = this.formattedType$okhttp(type2);
        String formattedFlags = this.formatFlags(type2, flags);
        String direction = inbound ? "<<" : ">>";
        Object[] objectArray = new Object[]{direction, streamId, length, formattedType, formattedFlags};
        return Util.format("%s 0x%08x %5d %-13s %s", objectArray);
    }

    @NotNull
    public final String formattedType$okhttp(int type2) {
        String string;
        if (type2 < FRAME_NAMES.length) {
            string = FRAME_NAMES[type2];
        } else {
            Object[] objectArray = new Object[]{type2};
            string = Util.format("0x%02x", objectArray);
        }
        return string;
    }

    @NotNull
    public final String formatFlags(int type2, int flags) {
        String string;
        if (flags == 0) {
            return "";
        }
        switch (type2) {
            case 4: 
            case 6: {
                return flags == 1 ? "ACK" : BINARY[flags];
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: {
                return BINARY[flags];
            }
        }
        if (flags < FLAGS.length) {
            String string2 = FLAGS[flags];
            string = string2;
            Intrinsics.checkNotNull((Object)string2);
        } else {
            string = BINARY[flags];
        }
        String result2 = string;
        return type2 == 5 && (flags & 4) != 0 ? StringsKt.replace$default((String)result2, (String)"HEADERS", (String)"PUSH_PROMISE", (boolean)false, (int)4, null) : (type2 == 0 && (flags & 0x20) != 0 ? StringsKt.replace$default((String)result2, (String)"PRIORITY", (String)"COMPRESSED", (boolean)false, (int)4, null) : result2);
    }

    /*
     * WARNING - void declaration
     */
    static {
        int nArray;
        void var0_2;
        INSTANCE = new Http2();
        CONNECTION_PREFACE = ByteString.Companion.encodeUtf8("PRI * HTTP/2.0\r\n\r\nSM\r\n\r\n");
        String[] stringArray = new String[]{"DATA", "HEADERS", "PRIORITY", "RST_STREAM", "SETTINGS", "PUSH_PROMISE", "PING", "GOAWAY", "WINDOW_UPDATE", "CONTINUATION"};
        FRAME_NAMES = stringArray;
        FLAGS = new String[64];
        boolean n2 = false;
        Object[] j = new String[256];
        while (var0_2 < 256) {
            nArray = var0_2++;
            Object[] objectArray = new Object[1];
            Intrinsics.checkNotNullExpressionValue((Object)Integer.toBinaryString(nArray), (String)"toBinaryString(it)");
            j[nArray] = StringsKt.replace$default((String)Util.format("%8s", objectArray), (char)' ', (char)'0', (boolean)false, (int)4, null);
        }
        BINARY = j;
        Http2.FLAGS[0] = "";
        Http2.FLAGS[1] = "END_STREAM";
        j = new int[1];
        j[0] = (String)true;
        Object[] objectArray = j;
        Http2.FLAGS[8] = "PADDED";
        nArray = objectArray.length;
        for (int k = 0; k < nArray; ++k) {
            String prefixFlag = objectArray[k];
            Http2.FLAGS[prefixFlag | 8] = FLAGS[prefixFlag] + "|PADDED";
        }
        Http2.FLAGS[4] = "END_HEADERS";
        Http2.FLAGS[32] = "PRIORITY";
        Http2.FLAGS[36] = "END_HEADERS|PRIORITY";
        int[] nArray2 = new int[]{4, 32, 36};
        for (int frameFlag : nArray2) {
            for (String prefixFlag : objectArray) {
                Http2.FLAGS[prefixFlag | frameFlag] = FLAGS[prefixFlag] + '|' + FLAGS[frameFlag];
                Http2.FLAGS[prefixFlag | frameFlag | 8] = FLAGS[prefixFlag] + '|' + FLAGS[frameFlag] + "|PADDED";
            }
        }
        int n = FLAGS.length;
        for (int i2 = 0; i2 < n; ++i2) {
            if (FLAGS[i2] != null) continue;
            Http2.FLAGS[i2] = BINARY[i2];
        }
    }
}

