/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http;

import java.net.Proxy;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.HttpUrl;
import okhttp3.Request;
import org.jetbrains.annotations.NotNull;

public final class RequestLine {
    @NotNull
    public static final RequestLine INSTANCE = new RequestLine();

    private RequestLine() {
    }

    @NotNull
    public final String get(@NotNull Request request2, @NotNull Proxy.Type proxyType) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        Intrinsics.checkNotNullParameter((Object)((Object)proxyType), (String)"proxyType");
        StringBuilder $this$get_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$get_u24lambda_u240.append(request2.method());
        $this$get_u24lambda_u240.append(' ');
        if (INSTANCE.includeAuthorityInRequestLine(request2, proxyType)) {
            $this$get_u24lambda_u240.append(request2.url());
        } else {
            $this$get_u24lambda_u240.append(INSTANCE.requestPath(request2.url()));
        }
        $this$get_u24lambda_u240.append(" HTTP/1.1");
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    private final boolean includeAuthorityInRequestLine(Request request2, Proxy.Type proxyType) {
        return !request2.isHttps() && proxyType == Proxy.Type.HTTP;
    }

    @NotNull
    public final String requestPath(@NotNull HttpUrl url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        String path2 = url.encodedPath();
        String query2 = url.encodedQuery();
        return query2 != null ? path2 + '?' + query2 : path2;
    }
}

