/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.Call;
import okhttp3.Connection;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.internal.Util;
import okhttp3.internal.connection.Exchange;
import okhttp3.internal.connection.RealCall;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nRealInterceptorChain.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RealInterceptorChain.kt\nokhttp3/internal/http/RealInterceptorChain\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,123:1\n1#2:124\n*E\n"})
public final class RealInterceptorChain
implements Interceptor.Chain {
    @NotNull
    private final RealCall call;
    @NotNull
    private final List<Interceptor> interceptors;
    private final int index;
    @Nullable
    private final Exchange exchange;
    @NotNull
    private final Request request;
    private final int connectTimeoutMillis;
    private final int readTimeoutMillis;
    private final int writeTimeoutMillis;
    private int calls;

    public RealInterceptorChain(@NotNull RealCall call2, @NotNull List<? extends Interceptor> interceptors, int index, @Nullable Exchange exchange, @NotNull Request request2, int connectTimeoutMillis, int readTimeoutMillis, int writeTimeoutMillis) {
        Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
        Intrinsics.checkNotNullParameter(interceptors, (String)"interceptors");
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        this.call = call2;
        this.interceptors = interceptors;
        this.index = index;
        this.exchange = exchange;
        this.request = request2;
        this.connectTimeoutMillis = connectTimeoutMillis;
        this.readTimeoutMillis = readTimeoutMillis;
        this.writeTimeoutMillis = writeTimeoutMillis;
    }

    @NotNull
    public final RealCall getCall$okhttp() {
        return this.call;
    }

    @Nullable
    public final Exchange getExchange$okhttp() {
        return this.exchange;
    }

    @NotNull
    public final Request getRequest$okhttp() {
        return this.request;
    }

    public final int getConnectTimeoutMillis$okhttp() {
        return this.connectTimeoutMillis;
    }

    public final int getReadTimeoutMillis$okhttp() {
        return this.readTimeoutMillis;
    }

    public final int getWriteTimeoutMillis$okhttp() {
        return this.writeTimeoutMillis;
    }

    @NotNull
    public final RealInterceptorChain copy$okhttp(int index, @Nullable Exchange exchange, @NotNull Request request2, int connectTimeoutMillis, int readTimeoutMillis, int writeTimeoutMillis) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        return new RealInterceptorChain(this.call, this.interceptors, index, exchange, request2, connectTimeoutMillis, readTimeoutMillis, writeTimeoutMillis);
    }

    public static /* synthetic */ RealInterceptorChain copy$okhttp$default(RealInterceptorChain realInterceptorChain, int n, Exchange exchange, Request request2, int n2, int n3, int n4, int n5, Object object) {
        if ((n5 & 1) != 0) {
            n = realInterceptorChain.index;
        }
        if ((n5 & 2) != 0) {
            exchange = realInterceptorChain.exchange;
        }
        if ((n5 & 4) != 0) {
            request2 = realInterceptorChain.request;
        }
        if ((n5 & 8) != 0) {
            n2 = realInterceptorChain.connectTimeoutMillis;
        }
        if ((n5 & 0x10) != 0) {
            n3 = realInterceptorChain.readTimeoutMillis;
        }
        if ((n5 & 0x20) != 0) {
            n4 = realInterceptorChain.writeTimeoutMillis;
        }
        return realInterceptorChain.copy$okhttp(n, exchange, request2, n2, n3, n4);
    }

    @Override
    @Nullable
    public Connection connection() {
        Exchange exchange = this.exchange;
        return exchange != null ? exchange.getConnection$okhttp() : null;
    }

    @Override
    public int connectTimeoutMillis() {
        return this.connectTimeoutMillis;
    }

    @Override
    @NotNull
    public Interceptor.Chain withConnectTimeout(int timeout2, @NotNull TimeUnit unit) {
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        if (!(this.exchange == null)) {
            boolean bl = false;
            String string = "Timeouts can't be adjusted in a network interceptor";
            throw new IllegalStateException(string.toString());
        }
        return RealInterceptorChain.copy$okhttp$default(this, 0, null, null, Util.checkDuration("connectTimeout", timeout2, unit), 0, 0, 55, null);
    }

    @Override
    public int readTimeoutMillis() {
        return this.readTimeoutMillis;
    }

    @Override
    @NotNull
    public Interceptor.Chain withReadTimeout(int timeout2, @NotNull TimeUnit unit) {
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        if (!(this.exchange == null)) {
            boolean bl = false;
            String string = "Timeouts can't be adjusted in a network interceptor";
            throw new IllegalStateException(string.toString());
        }
        return RealInterceptorChain.copy$okhttp$default(this, 0, null, null, 0, Util.checkDuration("readTimeout", timeout2, unit), 0, 47, null);
    }

    @Override
    public int writeTimeoutMillis() {
        return this.writeTimeoutMillis;
    }

    @Override
    @NotNull
    public Interceptor.Chain withWriteTimeout(int timeout2, @NotNull TimeUnit unit) {
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        if (!(this.exchange == null)) {
            boolean bl = false;
            String string = "Timeouts can't be adjusted in a network interceptor";
            throw new IllegalStateException(string.toString());
        }
        return RealInterceptorChain.copy$okhttp$default(this, 0, null, null, 0, 0, Util.checkDuration("writeTimeout", timeout2, unit), 31, null);
    }

    @Override
    @NotNull
    public Call call() {
        return this.call;
    }

    @Override
    @NotNull
    public Request request() {
        return this.request;
    }

    @Override
    @NotNull
    public Response proceed(@NotNull Request request2) throws IOException {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        if (!(this.index < this.interceptors.size())) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        int n = this.calls;
        this.calls = n + 1;
        if (this.exchange != null) {
            if (!this.exchange.getFinder$okhttp().sameHostAndPort(request2.url())) {
                boolean $i$a$-check-RealInterceptorChain$proceed$52 = false;
                String $i$a$-check-RealInterceptorChain$proceed$52 = "network interceptor " + this.interceptors.get(this.index - 1) + " must retain the same host and port";
                throw new IllegalStateException($i$a$-check-RealInterceptorChain$proceed$52.toString());
            }
            if (!(this.calls == 1)) {
                boolean $i$a$-check-RealInterceptorChain$proceed$62 = false;
                String $i$a$-check-RealInterceptorChain$proceed$62 = "network interceptor " + this.interceptors.get(this.index - 1) + " must call proceed() exactly once";
                throw new IllegalStateException($i$a$-check-RealInterceptorChain$proceed$62.toString());
            }
        }
        RealInterceptorChain next2 = RealInterceptorChain.copy$okhttp$default(this, this.index + 1, null, request2, 0, 0, 0, 58, null);
        Interceptor interceptor2 = this.interceptors.get(this.index);
        Response response2 = interceptor2.intercept(next2);
        if (response2 == null) {
            throw new NullPointerException("interceptor " + interceptor2 + " returned null");
        }
        Response response3 = response2;
        if (this.exchange != null && !(this.index + 1 >= this.interceptors.size() || next2.calls == 1)) {
            boolean $i$a$-check-RealInterceptorChain$proceed$72 = false;
            String $i$a$-check-RealInterceptorChain$proceed$72 = "network interceptor " + interceptor2 + " must call proceed() exactly once";
            throw new IllegalStateException($i$a$-check-RealInterceptorChain$proceed$72.toString());
        }
        if (!(response3.body() != null)) {
            boolean bl = false;
            String string = "interceptor " + interceptor2 + " returned a response with no body";
            throw new IllegalStateException(string.toString());
        }
        return response3;
    }
}

