/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.connection;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ProtocolException;
import java.net.UnknownServiceException;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocket;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.ConnectionSpec;
import org.jetbrains.annotations.NotNull;

public final class ConnectionSpecSelector {
    @NotNull
    private final List<ConnectionSpec> connectionSpecs;
    private int nextModeIndex;
    private boolean isFallbackPossible;
    private boolean isFallback;

    public ConnectionSpecSelector(@NotNull List<ConnectionSpec> connectionSpecs) {
        Intrinsics.checkNotNullParameter(connectionSpecs, (String)"connectionSpecs");
        this.connectionSpecs = connectionSpecs;
    }

    @NotNull
    public final ConnectionSpec configureSecureSocket(@NotNull SSLSocket sslSocket) throws IOException {
        Intrinsics.checkNotNullParameter((Object)sslSocket, (String)"sslSocket");
        ConnectionSpec tlsConfiguration = null;
        int n = this.connectionSpecs.size();
        for (int i2 = this.nextModeIndex; i2 < n; ++i2) {
            ConnectionSpec connectionSpec = this.connectionSpecs.get(i2);
            if (!connectionSpec.isCompatible(sslSocket)) continue;
            tlsConfiguration = connectionSpec;
            this.nextModeIndex = i2 + 1;
            break;
        }
        if (tlsConfiguration == null) {
            StringBuilder stringBuilder = new StringBuilder().append("Unable to find acceptable protocols. isFallback=").append(this.isFallback).append(", modes=").append(this.connectionSpecs).append(", supported protocols=");
            Object[] objectArray = sslSocket.getEnabledProtocols();
            Intrinsics.checkNotNull((Object)objectArray);
            String string = Arrays.toString(objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(this)");
            throw new UnknownServiceException(stringBuilder.append(string).toString());
        }
        this.isFallbackPossible = this.isFallbackPossible(sslSocket);
        tlsConfiguration.apply$okhttp(sslSocket, this.isFallback);
        return tlsConfiguration;
    }

    public final boolean connectionFailed(@NotNull IOException e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.isFallback = true;
        return !this.isFallbackPossible ? false : (e instanceof ProtocolException ? false : (e instanceof InterruptedIOException ? false : (e instanceof SSLHandshakeException && e.getCause() instanceof CertificateException ? false : (e instanceof SSLPeerUnverifiedException ? false : e instanceof SSLException))));
    }

    private final boolean isFallbackPossible(SSLSocket socket) {
        int n = this.connectionSpecs.size();
        for (int i2 = this.nextModeIndex; i2 < n; ++i2) {
            if (!this.connectionSpecs.get(i2).isCompatible(socket)) continue;
            return true;
        }
        return false;
    }
}

