/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.cache;

import java.io.IOException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import okio.Buffer;
import okio.ForwardingSink;
import okio.Sink;
import org.jetbrains.annotations.NotNull;

public class FaultHidingSink
extends ForwardingSink {
    @NotNull
    private final Function1<IOException, Unit> onException;
    private boolean hasErrors;

    public FaultHidingSink(@NotNull Sink delegate, @NotNull Function1<? super IOException, Unit> onException) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter(onException, (String)"onException");
        super(delegate);
        this.onException = onException;
    }

    @NotNull
    public final Function1<IOException, Unit> getOnException() {
        return this.onException;
    }

    public void write(@NotNull Buffer source, long byteCount) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (this.hasErrors) {
            source.skip(byteCount);
            return;
        }
        try {
            super.write(source, byteCount);
        }
        catch (IOException e) {
            this.hasErrors = true;
            this.onException.invoke((Object)e);
        }
    }

    public void flush() {
        if (this.hasErrors) {
            return;
        }
        try {
            super.flush();
        }
        catch (IOException e) {
            this.hasErrors = true;
            this.onException.invoke((Object)e);
        }
    }

    public void close() {
        if (this.hasErrors) {
            return;
        }
        try {
            super.close();
        }
        catch (IOException e) {
            this.hasErrors = true;
            this.onException.invoke((Object)e);
        }
    }
}

