/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.ReplaceWith;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okhttp3.internal.Util;
import okio.Buffer;
import okio.BufferedSink;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class MultipartBody
extends RequestBody {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ByteString boundaryByteString;
    @NotNull
    private final MediaType type;
    @NotNull
    private final List<Part> parts;
    @NotNull
    private final MediaType contentType;
    private long contentLength;
    @JvmField
    @NotNull
    public static final MediaType MIXED = MediaType.Companion.get("multipart/mixed");
    @JvmField
    @NotNull
    public static final MediaType ALTERNATIVE = MediaType.Companion.get("multipart/alternative");
    @JvmField
    @NotNull
    public static final MediaType DIGEST = MediaType.Companion.get("multipart/digest");
    @JvmField
    @NotNull
    public static final MediaType PARALLEL = MediaType.Companion.get("multipart/parallel");
    @JvmField
    @NotNull
    public static final MediaType FORM = MediaType.Companion.get("multipart/form-data");
    @NotNull
    private static final byte[] COLONSPACE;
    @NotNull
    private static final byte[] CRLF;
    @NotNull
    private static final byte[] DASHDASH;

    public MultipartBody(@NotNull ByteString boundaryByteString, @NotNull MediaType type2, @NotNull List<Part> parts) {
        Intrinsics.checkNotNullParameter((Object)boundaryByteString, (String)"boundaryByteString");
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        Intrinsics.checkNotNullParameter(parts, (String)"parts");
        this.boundaryByteString = boundaryByteString;
        this.type = type2;
        this.parts = parts;
        this.contentType = MediaType.Companion.get(this.type + "; boundary=" + this.boundary());
        this.contentLength = -1L;
    }

    @JvmName(name="type")
    @NotNull
    public final MediaType type() {
        return this.type;
    }

    @JvmName(name="parts")
    @NotNull
    public final List<Part> parts() {
        return this.parts;
    }

    @JvmName(name="boundary")
    @NotNull
    public final String boundary() {
        return this.boundaryByteString.utf8();
    }

    @JvmName(name="size")
    public final int size() {
        return this.parts.size();
    }

    @NotNull
    public final Part part(int index) {
        return this.parts.get(index);
    }

    @Override
    @NotNull
    public MediaType contentType() {
        return this.contentType;
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="type", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_type")
    @NotNull
    public final MediaType -deprecated_type() {
        return this.type;
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="boundary", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_boundary")
    @NotNull
    public final String -deprecated_boundary() {
        return this.boundary();
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="size", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_size")
    public final int -deprecated_size() {
        return this.size();
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="parts", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_parts")
    @NotNull
    public final List<Part> -deprecated_parts() {
        return this.parts;
    }

    @Override
    public long contentLength() throws IOException {
        long result2 = this.contentLength;
        if (result2 == -1L) {
            this.contentLength = result2 = this.writeOrCountBytes(null, true);
        }
        return result2;
    }

    @Override
    public void writeTo(@NotNull BufferedSink sink) throws IOException {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        this.writeOrCountBytes(sink, false);
    }

    private final long writeOrCountBytes(BufferedSink sink, boolean countBytes) throws IOException {
        BufferedSink sink2 = sink;
        long byteCount = 0L;
        Buffer byteCountBuffer = null;
        if (countBytes) {
            byteCountBuffer = new Buffer();
            sink2 = (BufferedSink)byteCountBuffer;
        }
        int n = this.parts.size();
        for (int p = 0; p < n; ++p) {
            long contentLength;
            MediaType contentType;
            Part part = this.parts.get(p);
            Headers headers2 = part.headers();
            RequestBody body = part.body();
            BufferedSink bufferedSink = sink2;
            Intrinsics.checkNotNull((Object)bufferedSink);
            bufferedSink.write(DASHDASH);
            sink2.write(this.boundaryByteString);
            sink2.write(CRLF);
            if (headers2 != null) {
                int n2 = headers2.size();
                for (int h = 0; h < n2; ++h) {
                    sink2.writeUtf8(headers2.name(h)).write(COLONSPACE).writeUtf8(headers2.value(h)).write(CRLF);
                }
            }
            if ((contentType = body.contentType()) != null) {
                sink2.writeUtf8("Content-Type: ").writeUtf8(contentType.toString()).write(CRLF);
            }
            if ((contentLength = body.contentLength()) != -1L) {
                sink2.writeUtf8("Content-Length: ").writeDecimalLong(contentLength).write(CRLF);
            } else if (countBytes) {
                Buffer buffer = byteCountBuffer;
                Intrinsics.checkNotNull((Object)buffer);
                buffer.clear();
                return -1L;
            }
            sink2.write(CRLF);
            if (countBytes) {
                byteCount += contentLength;
            } else {
                body.writeTo(sink2);
            }
            sink2.write(CRLF);
        }
        BufferedSink bufferedSink = sink2;
        Intrinsics.checkNotNull((Object)bufferedSink);
        bufferedSink.write(DASHDASH);
        sink2.write(this.boundaryByteString);
        sink2.write(DASHDASH);
        sink2.write(CRLF);
        if (countBytes) {
            Buffer buffer = byteCountBuffer;
            Intrinsics.checkNotNull((Object)buffer);
            byteCount += buffer.size();
            byteCountBuffer.clear();
        }
        return byteCount;
    }

    static {
        byte[] byArray = new byte[]{58, 32};
        COLONSPACE = byArray;
        byArray = new byte[]{13, 10};
        CRLF = byArray;
        byArray = new byte[]{45, 45};
        DASHDASH = byArray;
    }

    @SourceDebugExtension(value={"SMAP\nMultipartBody.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultipartBody.kt\nokhttp3/MultipartBody$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,345:1\n1#2:346\n*E\n"})
    public static final class Builder {
        @NotNull
        private final ByteString boundary;
        @NotNull
        private MediaType type;
        @NotNull
        private final List<Part> parts;

        @JvmOverloads
        public Builder(@NotNull String boundary) {
            Intrinsics.checkNotNullParameter((Object)boundary, (String)"boundary");
            this.boundary = ByteString.Companion.encodeUtf8(boundary);
            this.type = MIXED;
            this.parts = new ArrayList();
        }

        public /* synthetic */ Builder(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                String string2 = UUID.randomUUID().toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"randomUUID().toString()");
                string = string2;
            }
            this(string);
        }

        @NotNull
        public final Builder setType(@NotNull MediaType type2) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
            Builder $this$setType_u24lambda_u241 = builder = this;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)type2.type(), (Object)"multipart")) {
                boolean bl2 = false;
                String string = "multipart != " + type2;
                throw new IllegalArgumentException(string.toString());
            }
            $this$setType_u24lambda_u241.type = type2;
            return builder;
        }

        @NotNull
        public final Builder addPart(@NotNull RequestBody body) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)body, (String)"body");
            Builder $this$addPart_u24lambda_u242 = builder = this;
            boolean bl = false;
            $this$addPart_u24lambda_u242.addPart(Part.Companion.create(body));
            return builder;
        }

        @NotNull
        public final Builder addPart(@Nullable Headers headers2, @NotNull RequestBody body) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)body, (String)"body");
            Builder $this$addPart_u24lambda_u243 = builder = this;
            boolean bl = false;
            $this$addPart_u24lambda_u243.addPart(Part.Companion.create(headers2, body));
            return builder;
        }

        @NotNull
        public final Builder addFormDataPart(@NotNull String name2, @NotNull String value2) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            Builder $this$addFormDataPart_u24lambda_u244 = builder = this;
            boolean bl = false;
            $this$addFormDataPart_u24lambda_u244.addPart(Part.Companion.createFormData(name2, value2));
            return builder;
        }

        @NotNull
        public final Builder addFormDataPart(@NotNull String name2, @Nullable String filename, @NotNull RequestBody body) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter((Object)body, (String)"body");
            Builder $this$addFormDataPart_u24lambda_u245 = builder = this;
            boolean bl = false;
            $this$addFormDataPart_u24lambda_u245.addPart(Part.Companion.createFormData(name2, filename, body));
            return builder;
        }

        @NotNull
        public final Builder addPart(@NotNull Part part) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)part, (String)"part");
            Builder $this$addPart_u24lambda_u246 = builder = this;
            boolean bl = false;
            ((Collection)$this$addPart_u24lambda_u246.parts).add(part);
            return builder;
        }

        @NotNull
        public final MultipartBody build() {
            if (!(!((Collection)this.parts).isEmpty())) {
                boolean bl = false;
                String string = "Multipart body must have at least one part.";
                throw new IllegalStateException(string.toString());
            }
            return new MultipartBody(this.boundary, this.type, Util.toImmutableList(this.parts));
        }

        @JvmOverloads
        public Builder() {
            this(null, 1, null);
        }
    }

    public static final class Companion {
        private Companion() {
        }

        public final void appendQuotedString$okhttp(@NotNull StringBuilder $this$appendQuotedString, @NotNull String key2) {
            Intrinsics.checkNotNullParameter((Object)$this$appendQuotedString, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
            $this$appendQuotedString.append('\"');
            int n = key2.length();
            for (int i2 = 0; i2 < n; ++i2) {
                char ch = key2.charAt(i2);
                if (ch == '\n') {
                    $this$appendQuotedString.append("%0A");
                    continue;
                }
                if (ch == '\r') {
                    $this$appendQuotedString.append("%0D");
                    continue;
                }
                if (ch == '\"') {
                    $this$appendQuotedString.append("%22");
                    continue;
                }
                $this$appendQuotedString.append(ch);
            }
            $this$appendQuotedString.append('\"');
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static final class Part {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private final Headers headers;
        @NotNull
        private final RequestBody body;

        private Part(Headers headers2, RequestBody body) {
            this.headers = headers2;
            this.body = body;
        }

        @JvmName(name="headers")
        @Nullable
        public final Headers headers() {
            return this.headers;
        }

        @JvmName(name="body")
        @NotNull
        public final RequestBody body() {
            return this.body;
        }

        @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="headers", imports={}), level=DeprecationLevel.ERROR)
        @JvmName(name="-deprecated_headers")
        @Nullable
        public final Headers -deprecated_headers() {
            return this.headers;
        }

        @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="body", imports={}), level=DeprecationLevel.ERROR)
        @JvmName(name="-deprecated_body")
        @NotNull
        public final RequestBody -deprecated_body() {
            return this.body;
        }

        @JvmStatic
        @NotNull
        public static final Part create(@NotNull RequestBody body) {
            return Companion.create(body);
        }

        @JvmStatic
        @NotNull
        public static final Part create(@Nullable Headers headers2, @NotNull RequestBody body) {
            return Companion.create(headers2, body);
        }

        @JvmStatic
        @NotNull
        public static final Part createFormData(@NotNull String name2, @NotNull String value2) {
            return Companion.createFormData(name2, value2);
        }

        @JvmStatic
        @NotNull
        public static final Part createFormData(@NotNull String name2, @Nullable String filename, @NotNull RequestBody body) {
            return Companion.createFormData(name2, filename, body);
        }

        public /* synthetic */ Part(Headers headers2, RequestBody body, DefaultConstructorMarker $constructor_marker) {
            this(headers2, body);
        }

        @SourceDebugExtension(value={"SMAP\nMultipartBody.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultipartBody.kt\nokhttp3/MultipartBody$Part$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,345:1\n1#2:346\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @JvmStatic
            @NotNull
            public final Part create(@NotNull RequestBody body) {
                Intrinsics.checkNotNullParameter((Object)body, (String)"body");
                return this.create(null, body);
            }

            @JvmStatic
            @NotNull
            public final Part create(@Nullable Headers headers2, @NotNull RequestBody body) {
                Intrinsics.checkNotNullParameter((Object)body, (String)"body");
                Headers headers3 = headers2;
                if (!((headers3 != null ? headers3.get("Content-Type") : null) == null)) {
                    boolean $i$a$-require-MultipartBody$Part$Companion$create$32 = false;
                    String $i$a$-require-MultipartBody$Part$Companion$create$32 = "Unexpected header: Content-Type";
                    throw new IllegalArgumentException($i$a$-require-MultipartBody$Part$Companion$create$32.toString());
                }
                Headers headers4 = headers2;
                if (!((headers4 != null ? headers4.get("Content-Length") : null) == null)) {
                    boolean bl = false;
                    String string = "Unexpected header: Content-Length";
                    throw new IllegalArgumentException(string.toString());
                }
                return new Part(headers2, body, null);
            }

            @JvmStatic
            @NotNull
            public final Part createFormData(@NotNull String name2, @NotNull String value2) {
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
                return this.createFormData(name2, null, RequestBody.Companion.create$default(RequestBody.Companion, value2, null, 1, null));
            }

            @JvmStatic
            @NotNull
            public final Part createFormData(@NotNull String name2, @Nullable String filename, @NotNull RequestBody body) {
                StringBuilder stringBuilder;
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                Intrinsics.checkNotNullParameter((Object)body, (String)"body");
                StringBuilder $this$createFormData_u24lambda_u242 = stringBuilder = new StringBuilder();
                boolean bl = false;
                $this$createFormData_u24lambda_u242.append("form-data; name=");
                MultipartBody.Companion.appendQuotedString$okhttp($this$createFormData_u24lambda_u242, name2);
                if (filename != null) {
                    $this$createFormData_u24lambda_u242.append("; filename=");
                    MultipartBody.Companion.appendQuotedString$okhttp($this$createFormData_u24lambda_u242, filename);
                }
                String string = stringBuilder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
                String disposition = string;
                Headers headers2 = new Headers.Builder().addUnsafeNonAscii("Content-Disposition", disposition).build();
                return this.create(headers2, body);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

