/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.io.Closeable;
import java.io.File;
import java.io.Flushable;
import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import okhttp3.CipherSuite;
import okhttp3.Handshake;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.TlsVersion;
import okhttp3.internal.Util;
import okhttp3.internal.cache.CacheRequest;
import okhttp3.internal.cache.CacheStrategy;
import okhttp3.internal.cache.DiskLruCache;
import okhttp3.internal.concurrent.TaskRunner;
import okhttp3.internal.http.HttpMethod;
import okhttp3.internal.http.StatusLine;
import okhttp3.internal.io.FileSystem;
import okhttp3.internal.platform.Platform;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.ByteString;
import okio.ForwardingSink;
import okio.ForwardingSource;
import okio.Okio;
import okio.Sink;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class Cache
implements Closeable,
Flushable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DiskLruCache cache;
    private int writeSuccessCount;
    private int writeAbortCount;
    private int networkCount;
    private int hitCount;
    private int requestCount;
    private static final int VERSION = 201105;
    private static final int ENTRY_METADATA = 0;
    private static final int ENTRY_BODY = 1;
    private static final int ENTRY_COUNT = 2;

    public Cache(@NotNull File directory, long maxSize, @NotNull FileSystem fileSystem) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        this.cache = new DiskLruCache(fileSystem, directory, 201105, 2, maxSize, TaskRunner.INSTANCE);
    }

    @NotNull
    public final DiskLruCache getCache$okhttp() {
        return this.cache;
    }

    public final int getWriteSuccessCount$okhttp() {
        return this.writeSuccessCount;
    }

    public final void setWriteSuccessCount$okhttp(int n) {
        this.writeSuccessCount = n;
    }

    public final int getWriteAbortCount$okhttp() {
        return this.writeAbortCount;
    }

    public final void setWriteAbortCount$okhttp(int n) {
        this.writeAbortCount = n;
    }

    public final boolean isClosed() {
        return this.cache.isClosed();
    }

    public Cache(@NotNull File directory, long maxSize) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        this(directory, maxSize, FileSystem.SYSTEM);
    }

    @Nullable
    public final Response get$okhttp(@NotNull Request request2) {
        Entry _2;
        DiskLruCache.Snapshot snapshot2;
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        String key2 = Companion.key(request2.url());
        try {
            DiskLruCache.Snapshot snapshot3 = this.cache.get(key2);
            if (snapshot3 == null) {
                return null;
            }
            snapshot2 = snapshot3;
        }
        catch (IOException _2) {
            return null;
        }
        DiskLruCache.Snapshot snapshot4 = snapshot2;
        try {
            _2 = new Entry(snapshot4.getSource(0));
        }
        catch (IOException _3) {
            Util.closeQuietly(snapshot4);
            return null;
        }
        Entry entry = _2;
        Response response2 = entry.response(snapshot4);
        if (!entry.matches(request2, response2)) {
            ResponseBody responseBody = response2.body();
            if (responseBody != null) {
                Util.closeQuietly(responseBody);
            }
            return null;
        }
        return response2;
    }

    @Nullable
    public final CacheRequest put$okhttp(@NotNull Response response2) {
        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
        String requestMethod = response2.request().method();
        if (HttpMethod.INSTANCE.invalidatesCache(response2.request().method())) {
            try {
                this.remove$okhttp(response2.request());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
        }
        if (!Intrinsics.areEqual((Object)requestMethod, (Object)"GET")) {
            return null;
        }
        if (Companion.hasVaryAll(response2)) {
            return null;
        }
        Entry entry = new Entry(response2);
        DiskLruCache.Editor editor = null;
        try {
            DiskLruCache.Editor editor2 = DiskLruCache.edit$default(this.cache, Companion.key(response2.request().url()), 0L, 2, null);
            if (editor2 == null) {
                return null;
            }
            editor = editor2;
            entry.writeTo(editor);
            return new RealCacheRequest(editor);
        }
        catch (IOException _) {
            this.abortQuietly(editor);
            return null;
        }
    }

    public final void remove$okhttp(@NotNull Request request2) throws IOException {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        this.cache.remove(Companion.key(request2.url()));
    }

    public final void update$okhttp(@NotNull Response cached2, @NotNull Response network) {
        Intrinsics.checkNotNullParameter((Object)cached2, (String)"cached");
        Intrinsics.checkNotNullParameter((Object)network, (String)"network");
        Entry entry = new Entry(network);
        ResponseBody responseBody = cached2.body();
        Intrinsics.checkNotNull((Object)responseBody, (String)"null cannot be cast to non-null type okhttp3.Cache.CacheResponseBody");
        DiskLruCache.Snapshot snapshot2 = ((CacheResponseBody)responseBody).getSnapshot();
        DiskLruCache.Editor editor = null;
        try {
            DiskLruCache.Editor editor2 = snapshot2.edit();
            if (editor2 == null) {
                return;
            }
            editor = editor2;
            entry.writeTo(editor);
            editor.commit();
        }
        catch (IOException _) {
            this.abortQuietly(editor);
        }
    }

    private final void abortQuietly(DiskLruCache.Editor editor) {
        try {
            DiskLruCache.Editor editor2 = editor;
            if (editor2 != null) {
                editor2.abort();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public final void initialize() throws IOException {
        this.cache.initialize();
    }

    public final void delete() throws IOException {
        this.cache.delete();
    }

    public final void evictAll() throws IOException {
        this.cache.evictAll();
    }

    @NotNull
    public final Iterator<String> urls() throws IOException {
        return new Iterator<String>(this){
            @NotNull
            private final Iterator<DiskLruCache.Snapshot> delegate;
            @Nullable
            private String nextUrl;
            private boolean canRemove;
            {
                this.delegate = $receiver.getCache$okhttp().snapshots();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean hasNext() {
                if (this.nextUrl != null) {
                    return true;
                }
                this.canRemove = false;
                while (this.delegate.hasNext()) {
                    try {
                        Closeable closeable = this.delegate.next();
                        Throwable throwable = null;
                        try {
                            DiskLruCache.Snapshot snapshot2 = (DiskLruCache.Snapshot)closeable;
                            boolean bl = false;
                            BufferedSource metadata = Okio.buffer((Source)snapshot2.getSource(0));
                            this.nextUrl = metadata.readUtf8LineStrict();
                            boolean bl2 = true;
                            return bl2;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                        }
                    }
                    catch (IOException iOException) {
                    }
                }
                return false;
            }

            @NotNull
            public String next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                String string = this.nextUrl;
                Intrinsics.checkNotNull((Object)string);
                String result2 = string;
                this.nextUrl = null;
                this.canRemove = true;
                return result2;
            }

            public void remove() {
                if (!this.canRemove) {
                    boolean bl = false;
                    String string = "remove() before next()";
                    throw new IllegalStateException(string.toString());
                }
                this.delegate.remove();
            }
        };
    }

    public final synchronized int writeAbortCount() {
        return this.writeAbortCount;
    }

    public final synchronized int writeSuccessCount() {
        return this.writeSuccessCount;
    }

    public final long size() throws IOException {
        return this.cache.size();
    }

    public final long maxSize() {
        return this.cache.getMaxSize();
    }

    @Override
    public void flush() throws IOException {
        this.cache.flush();
    }

    @Override
    public void close() throws IOException {
        this.cache.close();
    }

    @JvmName(name="directory")
    @NotNull
    public final File directory() {
        return this.cache.getDirectory();
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="directory", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_directory")
    @NotNull
    public final File -deprecated_directory() {
        return this.cache.getDirectory();
    }

    public final synchronized void trackResponse$okhttp(@NotNull CacheStrategy cacheStrategy) {
        Intrinsics.checkNotNullParameter((Object)cacheStrategy, (String)"cacheStrategy");
        int n = this.requestCount;
        this.requestCount = n + 1;
        if (cacheStrategy.getNetworkRequest() != null) {
            n = this.networkCount;
            this.networkCount = n + 1;
        } else if (cacheStrategy.getCacheResponse() != null) {
            n = this.hitCount;
            this.hitCount = n + 1;
        }
    }

    public final synchronized void trackConditionalCacheHit$okhttp() {
        int n = this.hitCount;
        this.hitCount = n + 1;
    }

    public final synchronized int networkCount() {
        return this.networkCount;
    }

    public final synchronized int hitCount() {
        return this.hitCount;
    }

    public final synchronized int requestCount() {
        return this.requestCount;
    }

    @JvmStatic
    @NotNull
    public static final String key(@NotNull HttpUrl url) {
        return Companion.key(url);
    }

    private static final class CacheResponseBody
    extends ResponseBody {
        @NotNull
        private final DiskLruCache.Snapshot snapshot;
        @Nullable
        private final String contentType;
        @Nullable
        private final String contentLength;
        @NotNull
        private final BufferedSource bodySource;

        public CacheResponseBody(@NotNull DiskLruCache.Snapshot snapshot2, @Nullable String contentType, @Nullable String contentLength) {
            Intrinsics.checkNotNullParameter((Object)snapshot2, (String)"snapshot");
            this.snapshot = snapshot2;
            this.contentType = contentType;
            this.contentLength = contentLength;
            Source source = this.snapshot.getSource(1);
            this.bodySource = Okio.buffer((Source)((Source)new ForwardingSource(source){

                public void close() throws IOException {
                    this.getSnapshot().close();
                    super.close();
                }
            }));
        }

        @NotNull
        public final DiskLruCache.Snapshot getSnapshot() {
            return this.snapshot;
        }

        @Override
        @Nullable
        public MediaType contentType() {
            String string = this.contentType;
            return string != null ? MediaType.Companion.parse(string) : null;
        }

        @Override
        public long contentLength() {
            String string = this.contentLength;
            return string != null ? Util.toLongOrDefault(string, -1L) : -1L;
        }

        @Override
        @NotNull
        public BufferedSource source() {
            return this.bodySource;
        }
    }

    @SourceDebugExtension(value={"SMAP\nCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Cache.kt\nokhttp3/Cache$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,788:1\n2624#2,3:789\n*S KotlinDebug\n*F\n+ 1 Cache.kt\nokhttp3/Cache$Companion\n*L\n729#1:789,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final String key(@NotNull HttpUrl url) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            return ByteString.Companion.encodeUtf8(url.toString()).md5().hex();
        }

        public final int readInt$okhttp(@NotNull BufferedSource source) throws IOException {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            try {
                long result2 = source.readDecimalLong();
                String line = source.readUtf8LineStrict();
                if (result2 < 0L || result2 > Integer.MAX_VALUE || ((CharSequence)line).length() > 0) {
                    throw new IOException("expected an int but was \"" + result2 + line + '\"');
                }
                return (int)result2;
            }
            catch (NumberFormatException e) {
                throw new IOException(e.getMessage());
            }
        }

        public final boolean varyMatches(@NotNull Response cachedResponse, @NotNull Headers cachedRequest, @NotNull Request newRequest) {
            boolean bl;
            block3: {
                Intrinsics.checkNotNullParameter((Object)cachedResponse, (String)"cachedResponse");
                Intrinsics.checkNotNullParameter((Object)cachedRequest, (String)"cachedRequest");
                Intrinsics.checkNotNullParameter((Object)newRequest, (String)"newRequest");
                Iterable $this$none$iv = this.varyFields(cachedResponse.headers());
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        if (!(!Intrinsics.areEqual(cachedRequest.values(it), newRequest.headers(it)))) continue;
                        bl = false;
                        break block3;
                    }
                    bl = true;
                }
            }
            return bl;
        }

        public final boolean hasVaryAll(@NotNull Response $this$hasVaryAll) {
            Intrinsics.checkNotNullParameter((Object)$this$hasVaryAll, (String)"<this>");
            return this.varyFields($this$hasVaryAll.headers()).contains("*");
        }

        private final Set<String> varyFields(Headers $this$varyFields) {
            Set result2 = null;
            int n = $this$varyFields.size();
            for (int i2 = 0; i2 < n; ++i2) {
                if (!StringsKt.equals((String)"Vary", (String)$this$varyFields.name(i2), (boolean)true)) continue;
                String value2 = $this$varyFields.value(i2);
                if (result2 == null) {
                    result2 = new TreeSet(StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE));
                }
                char[] cArray = new char[]{','};
                for (String varyField : StringsKt.split$default((CharSequence)value2, (char[])cArray, (boolean)false, (int)0, (int)6, null)) {
                    result2.add(((Object)StringsKt.trim((CharSequence)varyField)).toString());
                }
            }
            Set set2 = result2;
            if (set2 == null) {
                set2 = SetsKt.emptySet();
            }
            return set2;
        }

        @NotNull
        public final Headers varyHeaders(@NotNull Response $this$varyHeaders) {
            Intrinsics.checkNotNullParameter((Object)$this$varyHeaders, (String)"<this>");
            Response response2 = $this$varyHeaders.networkResponse();
            Intrinsics.checkNotNull((Object)response2);
            Headers requestHeaders = response2.request().headers();
            Headers responseHeaders = $this$varyHeaders.headers();
            return this.varyHeaders(requestHeaders, responseHeaders);
        }

        private final Headers varyHeaders(Headers requestHeaders, Headers responseHeaders) {
            Set<String> varyFields = this.varyFields(responseHeaders);
            if (varyFields.isEmpty()) {
                return Util.EMPTY_HEADERS;
            }
            Headers.Builder result2 = new Headers.Builder();
            int n = requestHeaders.size();
            for (int i2 = 0; i2 < n; ++i2) {
                String fieldName = requestHeaders.name(i2);
                if (!varyFields.contains(fieldName)) continue;
                result2.add(fieldName, requestHeaders.value(i2));
            }
            return result2.build();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    private static final class Entry {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final HttpUrl url;
        @NotNull
        private final Headers varyHeaders;
        @NotNull
        private final String requestMethod;
        @NotNull
        private final Protocol protocol;
        private final int code;
        @NotNull
        private final String message;
        @NotNull
        private final Headers responseHeaders;
        @Nullable
        private final Handshake handshake;
        private final long sentRequestMillis;
        private final long receivedResponseMillis;
        @NotNull
        private static final String SENT_MILLIS = Platform.Companion.get().getPrefix() + "-Sent-Millis";
        @NotNull
        private static final String RECEIVED_MILLIS = Platform.Companion.get().getPrefix() + "-Received-Millis";

        private final boolean isHttps() {
            return Intrinsics.areEqual((Object)this.url.scheme(), (Object)"https");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        public Entry(@NotNull Source rawSource) throws IOException {
            Intrinsics.checkNotNullParameter((Object)rawSource, (String)"rawSource");
            Closeable closeable = (Closeable)rawSource;
            Throwable throwable = null;
            try {
                Source it = (Source)closeable;
                boolean bl = false;
                BufferedSource source = Okio.buffer((Source)rawSource);
                String urlLine = source.readUtf8LineStrict();
                HttpUrl httpUrl = HttpUrl.Companion.parse(urlLine);
                if (httpUrl == null) {
                    void it2;
                    IOException iOException;
                    IOException iOException2 = iOException = new IOException("Cache corruption for " + urlLine);
                    Entry entry = this;
                    boolean bl2 = false;
                    Platform.Companion.get().log("cache corruption", 5, (Throwable)it2);
                    Entry entry2 = entry;
                    throw (Throwable)iOException;
                }
                this.url = httpUrl;
                this.requestMethod = source.readUtf8LineStrict();
                Headers.Builder varyHeadersBuilder = new Headers.Builder();
                int varyRequestHeaderLineCount = Companion.readInt$okhttp(source);
                for (int i2 = 0; i2 < varyRequestHeaderLineCount; ++i2) {
                    varyHeadersBuilder.addLenient$okhttp(source.readUtf8LineStrict());
                }
                this.varyHeaders = varyHeadersBuilder.build();
                StatusLine statusLine = StatusLine.Companion.parse(source.readUtf8LineStrict());
                this.protocol = statusLine.protocol;
                this.code = statusLine.code;
                this.message = statusLine.message;
                Headers.Builder responseHeadersBuilder = new Headers.Builder();
                int responseHeaderLineCount = Companion.readInt$okhttp(source);
                for (int i3 = 0; i3 < responseHeaderLineCount; ++i3) {
                    responseHeadersBuilder.addLenient$okhttp(source.readUtf8LineStrict());
                }
                String sendRequestMillisString = responseHeadersBuilder.get(SENT_MILLIS);
                String receivedResponseMillisString = responseHeadersBuilder.get(RECEIVED_MILLIS);
                responseHeadersBuilder.removeAll(SENT_MILLIS);
                responseHeadersBuilder.removeAll(RECEIVED_MILLIS);
                String string = sendRequestMillisString;
                this.sentRequestMillis = string != null ? Long.parseLong(string) : 0L;
                String string2 = receivedResponseMillisString;
                this.receivedResponseMillis = string2 != null ? Long.parseLong(string2) : 0L;
                this.responseHeaders = responseHeadersBuilder.build();
                if (this.isHttps()) {
                    String blank = source.readUtf8LineStrict();
                    if (((CharSequence)blank).length() > 0) {
                        throw new IOException("expected \"\" but was \"" + blank + '\"');
                    }
                    String cipherSuiteString = source.readUtf8LineStrict();
                    CipherSuite cipherSuite = CipherSuite.Companion.forJavaName(cipherSuiteString);
                    List<Certificate> peerCertificates2 = this.readCertificateList(source);
                    List<Certificate> localCertificates = this.readCertificateList(source);
                    TlsVersion tlsVersion = !source.exhausted() ? TlsVersion.Companion.forJavaName(source.readUtf8LineStrict()) : TlsVersion.SSL_3_0;
                    this.handshake = Handshake.Companion.get(tlsVersion, cipherSuite, peerCertificates2, localCertificates);
                } else {
                    this.handshake = null;
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }

        public Entry(@NotNull Response response2) {
            Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
            this.url = response2.request().url();
            this.varyHeaders = Companion.varyHeaders(response2);
            this.requestMethod = response2.request().method();
            this.protocol = response2.protocol();
            this.code = response2.code();
            this.message = response2.message();
            this.responseHeaders = response2.headers();
            this.handshake = response2.handshake();
            this.sentRequestMillis = response2.sentRequestAtMillis();
            this.receivedResponseMillis = response2.receivedResponseAtMillis();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void writeTo(@NotNull DiskLruCache.Editor editor) throws IOException {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Closeable closeable = (Closeable)Okio.buffer((Sink)editor.newSink(0));
            Throwable throwable = null;
            try {
                int i2;
                BufferedSink sink = (BufferedSink)closeable;
                boolean bl = false;
                sink.writeUtf8(this.url.toString()).writeByte(10);
                sink.writeUtf8(this.requestMethod).writeByte(10);
                sink.writeDecimalLong((long)this.varyHeaders.size()).writeByte(10);
                int n = this.varyHeaders.size();
                for (i2 = 0; i2 < n; ++i2) {
                    sink.writeUtf8(this.varyHeaders.name(i2)).writeUtf8(": ").writeUtf8(this.varyHeaders.value(i2)).writeByte(10);
                }
                sink.writeUtf8(new StatusLine(this.protocol, this.code, this.message).toString()).writeByte(10);
                sink.writeDecimalLong((long)(this.responseHeaders.size() + 2)).writeByte(10);
                n = this.responseHeaders.size();
                for (i2 = 0; i2 < n; ++i2) {
                    sink.writeUtf8(this.responseHeaders.name(i2)).writeUtf8(": ").writeUtf8(this.responseHeaders.value(i2)).writeByte(10);
                }
                sink.writeUtf8(SENT_MILLIS).writeUtf8(": ").writeDecimalLong(this.sentRequestMillis).writeByte(10);
                sink.writeUtf8(RECEIVED_MILLIS).writeUtf8(": ").writeDecimalLong(this.receivedResponseMillis).writeByte(10);
                if (this.isHttps()) {
                    sink.writeByte(10);
                    Handshake handshake2 = this.handshake;
                    Intrinsics.checkNotNull((Object)handshake2);
                    sink.writeUtf8(handshake2.cipherSuite().javaName()).writeByte(10);
                    this.writeCertList(sink, this.handshake.peerCertificates());
                    this.writeCertList(sink, this.handshake.localCertificates());
                    sink.writeUtf8(this.handshake.tlsVersion().javaName()).writeByte(10);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }

        private final List<Certificate> readCertificateList(BufferedSource source) throws IOException {
            int length = Companion.readInt$okhttp(source);
            if (length == -1) {
                return CollectionsKt.emptyList();
            }
            try {
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                ArrayList<Certificate> result2 = new ArrayList<Certificate>(length);
                for (int i2 = 0; i2 < length; ++i2) {
                    ByteString certificateBytes;
                    String line = source.readUtf8LineStrict();
                    Buffer bytes2 = new Buffer();
                    if (ByteString.Companion.decodeBase64(line) == null) {
                        throw new IOException("Corrupt certificate in cache entry");
                    }
                    bytes2.write(certificateBytes);
                    result2.add(certificateFactory.generateCertificate(bytes2.inputStream()));
                }
                return result2;
            }
            catch (CertificateException e) {
                throw new IOException(e.getMessage());
            }
        }

        private final void writeCertList(BufferedSink sink, List<? extends Certificate> certificates) throws IOException {
            try {
                sink.writeDecimalLong((long)certificates.size()).writeByte(10);
                for (Certificate certificate2 : certificates) {
                    byte[] bytes2 = certificate2.getEncoded();
                    Intrinsics.checkNotNullExpressionValue((Object)bytes2, (String)"bytes");
                    String line = ByteString.Companion.of$default((ByteString.Companion)ByteString.Companion, (byte[])bytes2, (int)0, (int)0, (int)3, null).base64();
                    sink.writeUtf8(line).writeByte(10);
                }
            }
            catch (CertificateEncodingException e) {
                throw new IOException(e.getMessage());
            }
        }

        public final boolean matches(@NotNull Request request2, @NotNull Response response2) {
            Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
            Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
            return Intrinsics.areEqual((Object)this.url, (Object)request2.url()) && Intrinsics.areEqual((Object)this.requestMethod, (Object)request2.method()) && Companion.varyMatches(response2, this.varyHeaders, request2);
        }

        @NotNull
        public final Response response(@NotNull DiskLruCache.Snapshot snapshot2) {
            Intrinsics.checkNotNullParameter((Object)snapshot2, (String)"snapshot");
            String contentType = this.responseHeaders.get("Content-Type");
            String contentLength = this.responseHeaders.get("Content-Length");
            Request cacheRequest2 = new Request.Builder().url(this.url).method(this.requestMethod, null).headers(this.varyHeaders).build();
            return new Response.Builder().request(cacheRequest2).protocol(this.protocol).code(this.code).message(this.message).headers(this.responseHeaders).body(new CacheResponseBody(snapshot2, contentType, contentLength)).handshake(this.handshake).sentRequestAtMillis(this.sentRequestMillis).receivedResponseAtMillis(this.receivedResponseMillis).build();
        }

        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    private final class RealCacheRequest
    implements CacheRequest {
        @NotNull
        private final DiskLruCache.Editor editor;
        @NotNull
        private final Sink cacheOut;
        @NotNull
        private final Sink body;
        private boolean done;

        public RealCacheRequest(DiskLruCache.Editor editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            this.editor = editor;
            this.cacheOut = this.editor.newSink(1);
            Sink sink = this.cacheOut;
            this.body = (Sink)new ForwardingSink(sink){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void close() throws IOException {
                    Cache cache2 = Cache.this;
                    RealCacheRequest realCacheRequest = this;
                    Cache cache3 = Cache.this;
                    Cache cache4 = cache2;
                    synchronized (cache4) {
                        boolean bl = false;
                        if (realCacheRequest.getDone()) {
                            return;
                        }
                        realCacheRequest.setDone(true);
                        int n = cache3.getWriteSuccessCount$okhttp();
                        cache3.setWriteSuccessCount$okhttp(n + 1);
                        int n2 = n;
                    }
                    super.close();
                    editor.commit();
                }
            };
        }

        public final boolean getDone() {
            return this.done;
        }

        public final void setDone(boolean bl) {
            this.done = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void abort() {
            Cache cache2 = Cache.this;
            Cache cache3 = Cache.this;
            Cache cache4 = cache2;
            synchronized (cache4) {
                boolean bl = false;
                if (this.done) {
                    return;
                }
                this.done = true;
                int n = cache3.getWriteAbortCount$okhttp();
                cache3.setWriteAbortCount$okhttp(n + 1);
                int n2 = n;
            }
            Util.closeQuietly((Closeable)this.cacheOut);
            try {
                this.editor.abort();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        @NotNull
        public Sink body() {
            return this.body;
        }
    }
}

