/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.io;

import java.io.OutputStream;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.io.Buffer;
import kotlinx.io.RawSink;
import kotlinx.io.Segment;
import kotlinx.io._UtilKt;
import kotlinx.io.unsafe.UnsafeBufferOperations;
import org.jetbrains.annotations.NotNull;

@SourceDebugExtension(value={"SMAP\nJvmCore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmCore.kt\nkotlinx/io/OutputStreamSink\n+ 2 UnsafeBufferOperations.kt\nkotlinx/io/unsafe/UnsafeBufferOperations\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 -Util.kt\nkotlinx/io/_UtilKt\n*L\n1#1,112:1\n99#2:113\n100#2,2:115\n102#2,6:118\n1#3:114\n107#4:117\n*S KotlinDebug\n*F\n+ 1 JvmCore.kt\nkotlinx/io/OutputStreamSink\n*L\n48#1:113\n48#1:115,2\n48#1:118,6\n48#1:114\n49#1:117\n*E\n"})
class OutputStreamSink
implements RawSink {
    @NotNull
    private final OutputStream out;

    public OutputStreamSink(@NotNull OutputStream out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        this.out = out;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void write(@NotNull Buffer source, long byteCount) {
        int toCopy;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        _UtilKt.checkOffsetAndCount(source.getSize(), 0L, byteCount);
        long remaining = 0L;
        for (remaining = byteCount; remaining > 0L; remaining -= (long)toCopy) {
            void a$iv;
            void pos;
            void limit;
            Segment head$iv;
            UnsafeBufferOperations this_$iv = UnsafeBufferOperations.INSTANCE;
            boolean $i$f$readFromHead = false;
            if (!(!source.exhausted())) {
                boolean $i$a$-require-UnsafeBufferOperations$readFromHead$1$iv22 = false;
                String $i$a$-require-UnsafeBufferOperations$readFromHead$1$iv22 = "Buffer is empty";
                throw new IllegalArgumentException($i$a$-require-UnsafeBufferOperations$readFromHead$1$iv22.toString());
            }
            Intrinsics.checkNotNull((Object)source.getHead());
            int n = head$iv.getLimit();
            int n2 = head$iv.getPos();
            byte[] data2 = head$iv.dataAsByteArray(true);
            boolean bl = false;
            long l = remaining;
            void b$iv = limit - pos;
            boolean $i$f$minOf = false;
            toCopy = (int)Math.min((long)a$iv, (long)b$iv);
            this.out.write(data2, (int)pos, toCopy);
            int bytesRead$iv = toCopy;
            if (bytesRead$iv == 0) continue;
            if (bytesRead$iv < 0) {
                throw new IllegalStateException("Returned negative read bytes count");
            }
            if (bytesRead$iv > head$iv.getSize()) {
                throw new IllegalStateException("Returned too many bytes");
            }
            source.skip(bytesRead$iv);
        }
    }

    @Override
    public void flush() {
        this.out.flush();
    }

    @Override
    public void close() {
        this.out.close();
    }

    @NotNull
    public String toString() {
        return "RawSink(" + this.out + ')';
    }
}

