/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.collections.immutable.implementations.persistentOrderedMap;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.jvm.internal.markers.KMutableIterator;
import kotlinx.collections.immutable.implementations.persistentOrderedMap.LinkedValue;
import kotlinx.collections.immutable.implementations.persistentOrderedMap.PersistentOrderedMapBuilder;
import kotlinx.collections.immutable.internal.EndOfChain;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PersistentOrderedMapBuilderLinksIterator<K, V>
implements Iterator<LinkedValue<V>>,
KMutableIterator {
    @Nullable
    private Object nextKey;
    @NotNull
    private final PersistentOrderedMapBuilder<K, V> builder;
    @Nullable
    private Object lastIteratedKey;
    private boolean nextWasInvoked;
    private int expectedModCount;
    private int index;

    public PersistentOrderedMapBuilderLinksIterator(@Nullable Object nextKey, @NotNull PersistentOrderedMapBuilder<K, V> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        this.nextKey = nextKey;
        this.builder = builder;
        this.lastIteratedKey = EndOfChain.INSTANCE;
        this.expectedModCount = this.builder.getHashMapBuilder$kotlinx_collections_immutable().getModCount$kotlinx_collections_immutable();
    }

    @NotNull
    public final PersistentOrderedMapBuilder<K, V> getBuilder$kotlinx_collections_immutable() {
        return this.builder;
    }

    @Nullable
    public final Object getLastIteratedKey$kotlinx_collections_immutable() {
        return this.lastIteratedKey;
    }

    @Override
    public boolean hasNext() {
        return this.index < this.builder.size();
    }

    @Override
    @NotNull
    public LinkedValue<V> next() {
        this.checkForComodification();
        this.checkHasNext();
        this.lastIteratedKey = this.nextKey;
        this.nextWasInvoked = true;
        int n = this.index;
        this.index = n + 1;
        Map map2 = this.builder.getHashMapBuilder$kotlinx_collections_immutable();
        Object v = map2.get(this.nextKey);
        if (v == null) {
            boolean bl = false;
            throw new ConcurrentModificationException("Hash code of a key (" + this.nextKey + ") has changed after it was added to the persistent map.");
        }
        LinkedValue result2 = (LinkedValue)v;
        this.nextKey = result2.getNext();
        return result2;
    }

    @Override
    public void remove() {
        this.checkNextWasInvoked();
        Map map2 = this.builder;
        Object object = this.lastIteratedKey;
        TypeIntrinsics.asMutableMap((Object)map2).remove(object);
        this.lastIteratedKey = null;
        this.nextWasInvoked = false;
        this.expectedModCount = this.builder.getHashMapBuilder$kotlinx_collections_immutable().getModCount$kotlinx_collections_immutable();
        int n = this.index;
        this.index = n + -1;
    }

    private final void checkHasNext() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
    }

    private final void checkNextWasInvoked() {
        if (!this.nextWasInvoked) {
            throw new IllegalStateException();
        }
    }

    private final void checkForComodification() {
        if (this.builder.getHashMapBuilder$kotlinx_collections_immutable().getModCount$kotlinx_collections_immutable() != this.expectedModCount) {
            throw new ConcurrentModificationException();
        }
    }
}

