/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.collections.immutable.implementations.persistentOrderedMap;

import java.util.Map;
import java.util.Set;
import kotlin.PublishedApi;
import kotlin.collections.AbstractMap;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.collections.immutable.ImmutableCollection;
import kotlinx.collections.immutable.ImmutableSet;
import kotlinx.collections.immutable.PersistentMap;
import kotlinx.collections.immutable.implementations.immutableMap.PersistentHashMap;
import kotlinx.collections.immutable.implementations.immutableMap.PersistentHashMapBuilder;
import kotlinx.collections.immutable.implementations.persistentOrderedMap.LinkedValue;
import kotlinx.collections.immutable.implementations.persistentOrderedMap.PersistentOrderedMap;
import kotlinx.collections.immutable.implementations.persistentOrderedMap.PersistentOrderedMapBuilder;
import kotlinx.collections.immutable.implementations.persistentOrderedMap.PersistentOrderedMapEntries;
import kotlinx.collections.immutable.implementations.persistentOrderedMap.PersistentOrderedMapKeys;
import kotlinx.collections.immutable.implementations.persistentOrderedMap.PersistentOrderedMapValues;
import kotlinx.collections.immutable.internal.EndOfChain;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nPersistentOrderedMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PersistentOrderedMap.kt\nkotlinx/collections/immutable/implementations/persistentOrderedMap/PersistentOrderedMap\n+ 2 extensions.kt\nkotlinx/collections/immutable/ExtensionsKt\n*L\n1#1,173:1\n53#2:174\n*S KotlinDebug\n*F\n+ 1 PersistentOrderedMap.kt\nkotlinx/collections/immutable/implementations/persistentOrderedMap/PersistentOrderedMap\n*L\n121#1:174\n*E\n"})
public final class PersistentOrderedMap<K, V>
extends AbstractMap<K, V>
implements PersistentMap<K, V> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Object firstKey;
    @Nullable
    private final Object lastKey;
    @NotNull
    private final PersistentHashMap<K, LinkedValue<V>> hashMap;
    @NotNull
    private static final PersistentOrderedMap EMPTY = new PersistentOrderedMap(EndOfChain.INSTANCE, EndOfChain.INSTANCE, PersistentHashMap.Companion.emptyOf$kotlinx_collections_immutable());

    public PersistentOrderedMap(@Nullable Object firstKey, @Nullable Object lastKey, @NotNull PersistentHashMap<K, LinkedValue<V>> hashMap) {
        Intrinsics.checkNotNullParameter(hashMap, (String)"hashMap");
        this.firstKey = firstKey;
        this.lastKey = lastKey;
        this.hashMap = hashMap;
    }

    @Nullable
    public final Object getFirstKey$kotlinx_collections_immutable() {
        return this.firstKey;
    }

    @Nullable
    public final Object getLastKey$kotlinx_collections_immutable() {
        return this.lastKey;
    }

    @NotNull
    public final PersistentHashMap<K, LinkedValue<V>> getHashMap$kotlinx_collections_immutable() {
        return this.hashMap;
    }

    public int getSize() {
        return this.hashMap.size();
    }

    @NotNull
    public ImmutableSet<K> getKeys() {
        return new PersistentOrderedMapKeys(this);
    }

    @NotNull
    public ImmutableCollection<V> getValues() {
        return new PersistentOrderedMapValues(this);
    }

    private final ImmutableSet<Map.Entry<K, V>> createEntries() {
        return new PersistentOrderedMapEntries(this);
    }

    @PublishedApi
    @NotNull
    public final Set<Map.Entry<K, V>> getEntries() {
        return this.createEntries();
    }

    @Override
    public boolean containsKey(Object key2) {
        return this.hashMap.containsKey(key2);
    }

    @Override
    @Nullable
    public V get(Object key2) {
        LinkedValue<V> linkedValue = this.hashMap.get(key2);
        return (V)(linkedValue != null ? linkedValue.getValue() : null);
    }

    @Override
    @NotNull
    public PersistentOrderedMap<K, V> put(K key2, V value2) {
        if (this.isEmpty()) {
            PersistentMap newMap = this.hashMap.put((Object)key2, (Object)new LinkedValue<V>(value2));
            return new PersistentOrderedMap<K, V>(key2, key2, newMap);
        }
        LinkedValue<V> links = this.hashMap.get(key2);
        if (links != null) {
            if (links.getValue() == value2) {
                return this;
            }
            PersistentMap newMap = this.hashMap.put((Object)key2, (Object)links.withValue(value2));
            return new PersistentOrderedMap<K, V>(this.firstKey, this.lastKey, newMap);
        }
        Object lastKey = this.lastKey;
        LinkedValue<V> linkedValue = this.hashMap.get(lastKey);
        Intrinsics.checkNotNull(linkedValue);
        LinkedValue<V> lastLinks = linkedValue;
        PersistentMap newMap = ((PersistentHashMap)this.hashMap.put(lastKey, (Object)lastLinks.withNext(key2))).put((Object)key2, new LinkedValue<V>(value2, lastKey));
        return new PersistentOrderedMap<K, V>(this.firstKey, key2, newMap);
    }

    @Override
    @NotNull
    public PersistentOrderedMap<K, V> remove(K key2) {
        LinkedValue<V> linkedValue = this.hashMap.get(key2);
        if (linkedValue == null) {
            return this;
        }
        LinkedValue<V> links = linkedValue;
        PersistentMap newMap = this.hashMap.remove((Object)key2);
        if (links.getHasPrevious()) {
            Object v = ((Map)newMap).get(links.getPrevious());
            Intrinsics.checkNotNull(v);
            LinkedValue previousLinks = (LinkedValue)v;
            newMap = ((PersistentHashMap)newMap).put(links.getPrevious(), previousLinks.withNext(links.getNext()));
        }
        if (links.getHasNext()) {
            Object v = ((Map)newMap).get(links.getNext());
            Intrinsics.checkNotNull(v);
            LinkedValue nextLinks = (LinkedValue)v;
            newMap = ((PersistentHashMap)newMap).put(links.getNext(), nextLinks.withPrevious(links.getPrevious()));
        }
        Object newFirstKey = !links.getHasPrevious() ? links.getNext() : this.firstKey;
        Object newLastKey = !links.getHasNext() ? links.getPrevious() : this.lastKey;
        return new PersistentOrderedMap<K, V>(newFirstKey, newLastKey, newMap);
    }

    @Override
    @NotNull
    public PersistentMap.Builder<K, V> builder() {
        return new PersistentOrderedMapBuilder(this);
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Map)) {
            return false;
        }
        if (this.size() != ((Map)other).size()) {
            return false;
        }
        Map map2 = (Map)other;
        return map2 instanceof PersistentOrderedMap ? this.hashMap.getNode$kotlinx_collections_immutable().equalsWith$kotlinx_collections_immutable(((PersistentOrderedMap)other).hashMap.getNode$kotlinx_collections_immutable(), equals.1.INSTANCE) : (map2 instanceof PersistentOrderedMapBuilder ? this.hashMap.getNode$kotlinx_collections_immutable().equalsWith$kotlinx_collections_immutable(((PersistentOrderedMapBuilder)other).getHashMapBuilder$kotlinx_collections_immutable().getNode$kotlinx_collections_immutable(), equals.2.INSTANCE) : (map2 instanceof PersistentHashMap ? this.hashMap.getNode$kotlinx_collections_immutable().equalsWith$kotlinx_collections_immutable(((PersistentHashMap)other).getNode$kotlinx_collections_immutable(), equals.3.INSTANCE) : (map2 instanceof PersistentHashMapBuilder ? this.hashMap.getNode$kotlinx_collections_immutable().equalsWith$kotlinx_collections_immutable(((PersistentHashMapBuilder)other).getNode$kotlinx_collections_immutable(), equals.4.INSTANCE) : super.equals(other))));
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final <K, V> PersistentOrderedMap<K, V> emptyOf$kotlinx_collections_immutable() {
            PersistentOrderedMap persistentOrderedMap = EMPTY;
            Intrinsics.checkNotNull((Object)persistentOrderedMap, (String)"null cannot be cast to non-null type kotlinx.collections.immutable.implementations.persistentOrderedMap.PersistentOrderedMap<K of kotlinx.collections.immutable.implementations.persistentOrderedMap.PersistentOrderedMap.Companion.emptyOf, V of kotlinx.collections.immutable.implementations.persistentOrderedMap.PersistentOrderedMap.Companion.emptyOf>");
            return persistentOrderedMap;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

