/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.collections.immutable.implementations.immutableSet;

import java.util.Collection;
import java.util.Iterator;
import kotlin.collections.AbstractMutableSet;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.collections.immutable.PersistentSet;
import kotlinx.collections.immutable.implementations.immutableSet.PersistentHashSet;
import kotlinx.collections.immutable.implementations.immutableSet.PersistentHashSetMutableIterator;
import kotlinx.collections.immutable.implementations.immutableSet.TrieNode;
import kotlinx.collections.immutable.internal.DeltaCounter;
import kotlinx.collections.immutable.internal.MutabilityOwnership;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PersistentHashSetBuilder<E>
extends AbstractMutableSet<E>
implements PersistentSet.Builder<E> {
    @Nullable
    private PersistentHashSet<E> builtSet;
    @NotNull
    private MutabilityOwnership ownership;
    @NotNull
    private TrieNode<E> node;
    private int modCount;
    private int size;

    public PersistentHashSetBuilder(@NotNull PersistentHashSet<E> set2) {
        Intrinsics.checkNotNullParameter(set2, (String)"set");
        this.builtSet = set2;
        this.ownership = new MutabilityOwnership();
        this.node = set2.getNode$kotlinx_collections_immutable();
        this.size = set2.size();
    }

    @NotNull
    public final MutabilityOwnership getOwnership$kotlinx_collections_immutable() {
        return this.ownership;
    }

    @NotNull
    public final TrieNode<E> getNode$kotlinx_collections_immutable() {
        return this.node;
    }

    private final void setNode(TrieNode<E> value2) {
        if (value2 != this.node) {
            this.builtSet = null;
            this.node = value2;
        }
    }

    public final int getModCount$kotlinx_collections_immutable() {
        return this.modCount;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int value2) {
        this.size = value2;
        int n = this.modCount;
        this.modCount = n + 1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public PersistentHashSet<E> build() {
        PersistentHashSet<E> persistentHashSet = this.builtSet;
        if (persistentHashSet == null) {
            void var3_3;
            PersistentHashSetBuilder $this$build_u24lambda_u240 = this;
            boolean bl = false;
            PersistentHashSet<E> newlyBuiltSet = new PersistentHashSet<E>($this$build_u24lambda_u240.node, $this$build_u24lambda_u240.size());
            $this$build_u24lambda_u240.ownership = new MutabilityOwnership();
            $this$build_u24lambda_u240.builtSet = newlyBuiltSet;
            persistentHashSet = var3_3;
        }
        return persistentHashSet;
    }

    @Override
    public boolean contains(Object element) {
        Object object = element;
        return this.node.contains(object != null ? object.hashCode() : 0, element, 0);
    }

    @Override
    public boolean add(E element) {
        int size = this.size();
        E e = element;
        this.setNode(this.node.mutableAdd(e != null ? e.hashCode() : 0, element, 0, this));
        return size != this.size();
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends E> elements) {
        PersistentHashSet set2;
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        if (elements.isEmpty()) {
            return false;
        }
        PersistentSet persistentSet = elements instanceof PersistentHashSet ? (PersistentHashSet)elements : null;
        if (persistentSet == null) {
            PersistentHashSetBuilder persistentHashSetBuilder = elements instanceof PersistentHashSetBuilder ? (PersistentHashSetBuilder)elements : null;
            persistentSet = persistentHashSetBuilder != null ? persistentHashSetBuilder.build() : null;
        }
        if ((set2 = persistentSet) != null) {
            DeltaCounter deltaCounter = new DeltaCounter(0, 1, null);
            int size = this.size();
            TrieNode<E> result2 = this.node.mutableAddAll(set2.getNode$kotlinx_collections_immutable(), 0, deltaCounter, this);
            int newSize = size + elements.size() - deltaCounter.getCount();
            if (size != newSize) {
                this.setNode(result2);
                this.setSize(newSize);
            }
            return size != this.size();
        }
        return super.addAll(elements);
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> elements) {
        PersistentHashSet set2;
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        PersistentSet persistentSet = elements instanceof PersistentHashSet ? (PersistentHashSet)elements : null;
        if (persistentSet == null) {
            PersistentHashSetBuilder persistentHashSetBuilder = elements instanceof PersistentHashSetBuilder ? (PersistentHashSetBuilder)elements : null;
            persistentSet = persistentHashSetBuilder != null ? persistentHashSetBuilder.build() : null;
        }
        if ((set2 = persistentSet) != null) {
            DeltaCounter deltaCounter = new DeltaCounter(0, 1, null);
            int size = this.size();
            Object result2 = this.node.mutableRetainAll(set2.getNode$kotlinx_collections_immutable(), 0, deltaCounter, this);
            int newSize = deltaCounter.getCount();
            if (newSize == 0) {
                this.clear();
            } else if (newSize != size) {
                Intrinsics.checkNotNull((Object)result2, (String)"null cannot be cast to non-null type kotlinx.collections.immutable.implementations.immutableSet.TrieNode<E of kotlinx.collections.immutable.implementations.immutableSet.PersistentHashSetBuilder>");
                this.setNode((TrieNode)result2);
                this.setSize(newSize);
            }
            return size != this.size();
        }
        return super.retainAll(elements);
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> elements) {
        PersistentHashSet set2;
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        if (elements.isEmpty()) {
            return false;
        }
        PersistentSet persistentSet = elements instanceof PersistentHashSet ? (PersistentHashSet)elements : null;
        if (persistentSet == null) {
            PersistentHashSetBuilder persistentHashSetBuilder = elements instanceof PersistentHashSetBuilder ? (PersistentHashSetBuilder)elements : null;
            persistentSet = persistentHashSetBuilder != null ? persistentHashSetBuilder.build() : null;
        }
        if ((set2 = persistentSet) != null) {
            DeltaCounter counter = new DeltaCounter(0, 1, null);
            int size = this.size();
            Object result2 = this.node.mutableRemoveAll(set2.getNode$kotlinx_collections_immutable(), 0, counter, this);
            int newSize = size - counter.getCount();
            if (newSize == 0) {
                this.clear();
            } else if (newSize != size) {
                Intrinsics.checkNotNull((Object)result2, (String)"null cannot be cast to non-null type kotlinx.collections.immutable.implementations.immutableSet.TrieNode<E of kotlinx.collections.immutable.implementations.immutableSet.PersistentHashSetBuilder>");
                this.setNode((TrieNode)result2);
                this.setSize(newSize);
            }
            return size != this.size();
        }
        return super.removeAll(elements);
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        if (elements instanceof PersistentHashSet) {
            return this.node.containsAll(((PersistentHashSet)elements).getNode$kotlinx_collections_immutable(), 0);
        }
        if (elements instanceof PersistentHashSetBuilder) {
            return this.node.containsAll(((PersistentHashSetBuilder)elements).node, 0);
        }
        return super.containsAll(elements);
    }

    @Override
    public boolean remove(Object element) {
        int size = this.size();
        Object object = element;
        this.setNode(this.node.mutableRemove(object != null ? object.hashCode() : 0, element, 0, this));
        return size != this.size();
    }

    @Override
    public void clear() {
        TrieNode trieNode = TrieNode.Companion.getEMPTY$kotlinx_collections_immutable();
        Intrinsics.checkNotNull((Object)trieNode, (String)"null cannot be cast to non-null type kotlinx.collections.immutable.implementations.immutableSet.TrieNode<E of kotlinx.collections.immutable.implementations.immutableSet.PersistentHashSetBuilder>");
        this.setNode(trieNode);
        this.setSize(0);
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        return new PersistentHashSetMutableIterator(this);
    }
}

