/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.collections.immutable.implementations.immutableMap;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.jvm.internal.markers.KMutableIterator;
import kotlinx.collections.immutable.implementations.immutableMap.PersistentHashMapBaseIterator;
import kotlinx.collections.immutable.implementations.immutableMap.PersistentHashMapBuilder;
import kotlinx.collections.immutable.implementations.immutableMap.TrieNode;
import kotlinx.collections.immutable.implementations.immutableMap.TrieNodeBaseIterator;
import kotlinx.collections.immutable.implementations.immutableMap.TrieNodeKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PersistentHashMapBuilderBaseIterator<K, V, T>
extends PersistentHashMapBaseIterator<K, V, T>
implements Iterator<T>,
KMutableIterator {
    @NotNull
    private final PersistentHashMapBuilder<K, V> builder;
    @Nullable
    private K lastIteratedKey;
    private boolean nextWasInvoked;
    private int expectedModCount;

    public PersistentHashMapBuilderBaseIterator(@NotNull PersistentHashMapBuilder<K, V> builder, @NotNull TrieNodeBaseIterator<K, V, T>[] path2) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        Intrinsics.checkNotNullParameter(path2, (String)"path");
        super(builder.getNode$kotlinx_collections_immutable(), path2);
        this.builder = builder;
        this.expectedModCount = this.builder.getModCount$kotlinx_collections_immutable();
    }

    @Override
    public T next() {
        this.checkForComodification();
        this.lastIteratedKey = this.currentKey();
        this.nextWasInvoked = true;
        return super.next();
    }

    @Override
    public void remove() {
        this.checkNextWasInvoked();
        if (this.hasNext()) {
            Object currentKey = this.currentKey();
            Map map2 = this.builder;
            K k = this.lastIteratedKey;
            TypeIntrinsics.asMutableMap((Object)map2).remove(k);
            Object k2 = currentKey;
            K k3 = this.lastIteratedKey;
            this.resetPath(k2 != null ? k2.hashCode() : 0, this.builder.getNode$kotlinx_collections_immutable(), currentKey, 0, k3 != null ? k3.hashCode() : 0, true);
        } else {
            Map map3 = this.builder;
            K k = this.lastIteratedKey;
            TypeIntrinsics.asMutableMap((Object)map3).remove(k);
        }
        this.lastIteratedKey = null;
        this.nextWasInvoked = false;
        this.expectedModCount = this.builder.getModCount$kotlinx_collections_immutable();
    }

    public final void setValue(K key2, V newValue) {
        if (!this.builder.containsKey(key2)) {
            return;
        }
        if (this.hasNext()) {
            Object currentKey = this.currentKey();
            ((Map)this.builder).put(key2, newValue);
            Object k = currentKey;
            PersistentHashMapBuilderBaseIterator.resetPath$default(this, k != null ? k.hashCode() : 0, this.builder.getNode$kotlinx_collections_immutable(), currentKey, 0, 0, false, 48, null);
        } else {
            ((Map)this.builder).put(key2, newValue);
        }
        this.expectedModCount = this.builder.getModCount$kotlinx_collections_immutable();
    }

    private final void resetPath(int keyHash, TrieNode<?, ?> node2, K key2, int pathIndex, int removedKeyHash, boolean afterRemove) {
        int shift = pathIndex * 5;
        if (shift > 30) {
            this.getPath()[pathIndex].reset(node2.getBuffer$kotlinx_collections_immutable(), node2.getBuffer$kotlinx_collections_immutable().length, 0);
            while (!Intrinsics.areEqual(this.getPath()[pathIndex].currentKey(), key2)) {
                this.getPath()[pathIndex].moveToNextKey();
            }
            this.setPathLastIndex(pathIndex);
            return;
        }
        int keyPositionMask = 1 << TrieNodeKt.indexSegment(keyHash, shift);
        if (node2.hasEntryAt$kotlinx_collections_immutable(keyPositionMask)) {
            int removedKeyPositionMask;
            int keyIndex = node2.entryKeyIndex$kotlinx_collections_immutable(keyPositionMask);
            int n = removedKeyPositionMask = afterRemove ? 1 << TrieNodeKt.indexSegment(removedKeyHash, shift) : 0;
            if (keyPositionMask == removedKeyPositionMask && pathIndex < this.getPathLastIndex()) {
                Object[] objectArray = new Object[]{node2.getBuffer$kotlinx_collections_immutable()[keyIndex], node2.getBuffer$kotlinx_collections_immutable()[keyIndex + 1]};
                this.getPath()[this.getPathLastIndex()].reset(objectArray, 2);
                return;
            }
            this.getPath()[pathIndex].reset(node2.getBuffer$kotlinx_collections_immutable(), 2 * node2.entryCount$kotlinx_collections_immutable(), keyIndex);
            this.setPathLastIndex(pathIndex);
            return;
        }
        int nodeIndex = node2.nodeIndex$kotlinx_collections_immutable(keyPositionMask);
        TrieNode<?, ?> targetNode = node2.nodeAtIndex$kotlinx_collections_immutable(nodeIndex);
        this.getPath()[pathIndex].reset(node2.getBuffer$kotlinx_collections_immutable(), 2 * node2.entryCount$kotlinx_collections_immutable(), nodeIndex);
        this.resetPath(keyHash, targetNode, key2, pathIndex + 1, removedKeyHash, afterRemove);
    }

    static /* synthetic */ void resetPath$default(PersistentHashMapBuilderBaseIterator persistentHashMapBuilderBaseIterator, int n, TrieNode trieNode, Object object, int n2, int n3, boolean bl, int n4, Object object2) {
        if (object2 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: resetPath");
        }
        if ((n4 & 0x10) != 0) {
            n3 = 0;
        }
        if ((n4 & 0x20) != 0) {
            bl = false;
        }
        persistentHashMapBuilderBaseIterator.resetPath(n, trieNode, object, n2, n3, bl);
    }

    private final void checkNextWasInvoked() {
        if (!this.nextWasInvoked) {
            throw new IllegalStateException();
        }
    }

    private final void checkForComodification() {
        if (this.builder.getModCount$kotlinx_collections_immutable() != this.expectedModCount) {
            throw new ConcurrentModificationException();
        }
    }
}

