/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.collections.immutable.implementations.immutableMap;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import kotlin.collections.AbstractMutableMap;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.collections.immutable.PersistentMap;
import kotlinx.collections.immutable.implementations.immutableMap.PersistentHashMap;
import kotlinx.collections.immutable.implementations.immutableMap.PersistentHashMapBuilder;
import kotlinx.collections.immutable.implementations.immutableMap.PersistentHashMapBuilderEntries;
import kotlinx.collections.immutable.implementations.immutableMap.PersistentHashMapBuilderKeys;
import kotlinx.collections.immutable.implementations.immutableMap.PersistentHashMapBuilderValues;
import kotlinx.collections.immutable.implementations.immutableMap.TrieNode;
import kotlinx.collections.immutable.implementations.persistentOrderedMap.PersistentOrderedMap;
import kotlinx.collections.immutable.implementations.persistentOrderedMap.PersistentOrderedMapBuilder;
import kotlinx.collections.immutable.internal.DeltaCounter;
import kotlinx.collections.immutable.internal.MapImplementation;
import kotlinx.collections.immutable.internal.MutabilityOwnership;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PersistentHashMapBuilder<K, V>
extends AbstractMutableMap<K, V>
implements PersistentMap.Builder<K, V> {
    @Nullable
    private PersistentHashMap<K, V> builtMap;
    @NotNull
    private MutabilityOwnership ownership;
    @NotNull
    private TrieNode<K, V> node;
    @Nullable
    private V operationResult;
    private int modCount;
    private int size;

    public PersistentHashMapBuilder(@NotNull PersistentHashMap<K, V> map2) {
        Intrinsics.checkNotNullParameter(map2, (String)"map");
        this.builtMap = map2;
        this.ownership = new MutabilityOwnership();
        this.node = map2.getNode$kotlinx_collections_immutable();
        this.size = map2.size();
    }

    @Nullable
    public final PersistentHashMap<K, V> getBuiltMap$kotlinx_collections_immutable() {
        return this.builtMap;
    }

    @NotNull
    public final MutabilityOwnership getOwnership$kotlinx_collections_immutable() {
        return this.ownership;
    }

    @NotNull
    public final TrieNode<K, V> getNode$kotlinx_collections_immutable() {
        return this.node;
    }

    public final void setNode$kotlinx_collections_immutable(@NotNull TrieNode<K, V> value2) {
        Intrinsics.checkNotNullParameter(value2, (String)"value");
        if (value2 != this.node) {
            this.node = value2;
            this.builtMap = null;
        }
    }

    public final void setOperationResult$kotlinx_collections_immutable(@Nullable V v) {
        this.operationResult = v;
    }

    public final int getModCount$kotlinx_collections_immutable() {
        return this.modCount;
    }

    public final void setModCount$kotlinx_collections_immutable(int n) {
        this.modCount = n;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int value2) {
        this.size = value2;
        int n = this.modCount;
        this.modCount = n + 1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public PersistentHashMap<K, V> build() {
        PersistentHashMap<K, V> persistentHashMap = this.builtMap;
        if (persistentHashMap == null) {
            void var3_3;
            PersistentHashMapBuilder $this$build_u24lambda_u240 = this;
            boolean bl = false;
            PersistentHashMap<K, V> newlyBuiltMap = new PersistentHashMap<K, V>($this$build_u24lambda_u240.node, $this$build_u24lambda_u240.size());
            $this$build_u24lambda_u240.builtMap = newlyBuiltMap;
            $this$build_u24lambda_u240.ownership = new MutabilityOwnership();
            persistentHashMap = var3_3;
        }
        return persistentHashMap;
    }

    @NotNull
    public Set<Map.Entry<K, V>> getEntries() {
        return (Set)((Object)new PersistentHashMapBuilderEntries(this));
    }

    @NotNull
    public Set<K> getKeys() {
        return new PersistentHashMapBuilderKeys(this);
    }

    @NotNull
    public Collection<V> getValues() {
        return new PersistentHashMapBuilderValues(this);
    }

    @Override
    public boolean containsKey(Object key2) {
        Object object = key2;
        return this.node.containsKey(object != null ? object.hashCode() : 0, key2, 0);
    }

    @Override
    @Nullable
    public V get(Object key2) {
        Object object = key2;
        return this.node.get(object != null ? object.hashCode() : 0, key2, 0);
    }

    @Override
    @Nullable
    public V put(K key2, V value2) {
        this.operationResult = null;
        K k = key2;
        this.setNode$kotlinx_collections_immutable(this.node.mutablePut(k != null ? k.hashCode() : 0, key2, value2, 0, this));
        return this.operationResult;
    }

    @Override
    public void putAll(@NotNull Map<? extends K, ? extends V> from) {
        PersistentHashMap map2;
        Intrinsics.checkNotNullParameter(from, (String)"from");
        if (from.isEmpty()) {
            return;
        }
        PersistentMap persistentMap = from instanceof PersistentHashMap ? (PersistentHashMap)from : null;
        if (persistentMap == null) {
            PersistentHashMapBuilder persistentHashMapBuilder = from instanceof PersistentHashMapBuilder ? (PersistentHashMapBuilder)from : null;
            persistentMap = persistentHashMapBuilder != null ? persistentHashMapBuilder.build() : null;
        }
        if ((map2 = persistentMap) != null) {
            DeltaCounter intersectionCounter = new DeltaCounter(0, 1, null);
            int oldSize = this.size();
            TrieNode trieNode = map2.getNode$kotlinx_collections_immutable();
            Intrinsics.checkNotNull(trieNode, (String)"null cannot be cast to non-null type kotlinx.collections.immutable.implementations.immutableMap.TrieNode<K of kotlinx.collections.immutable.implementations.immutableMap.PersistentHashMapBuilder, V of kotlinx.collections.immutable.implementations.immutableMap.PersistentHashMapBuilder>");
            this.setNode$kotlinx_collections_immutable(this.node.mutablePutAll(trieNode, 0, intersectionCounter, this));
            int newSize = oldSize + map2.size() - intersectionCounter.getCount();
            if (oldSize != newSize) {
                this.setSize(newSize);
            }
        } else {
            super.putAll(from);
        }
    }

    @Override
    @Nullable
    public V remove(Object key2) {
        this.operationResult = null;
        Object object = key2;
        TrieNode trieNode = this.node.mutableRemove(object != null ? object.hashCode() : 0, key2, 0, this);
        if (trieNode == null) {
            TrieNode trieNode2 = TrieNode.Companion.getEMPTY$kotlinx_collections_immutable();
            trieNode = trieNode2;
            Intrinsics.checkNotNull((Object)trieNode2, (String)"null cannot be cast to non-null type kotlinx.collections.immutable.implementations.immutableMap.TrieNode<K of kotlinx.collections.immutable.implementations.immutableMap.PersistentHashMapBuilder, V of kotlinx.collections.immutable.implementations.immutableMap.PersistentHashMapBuilder>");
        }
        this.setNode$kotlinx_collections_immutable(trieNode);
        return this.operationResult;
    }

    @Override
    public final boolean remove(Object key2, Object value2) {
        int oldSize = this.size();
        Object object = key2;
        TrieNode trieNode = this.node.mutableRemove(object != null ? object.hashCode() : 0, key2, value2, 0, this);
        if (trieNode == null) {
            TrieNode trieNode2 = TrieNode.Companion.getEMPTY$kotlinx_collections_immutable();
            trieNode = trieNode2;
            Intrinsics.checkNotNull((Object)trieNode2, (String)"null cannot be cast to non-null type kotlinx.collections.immutable.implementations.immutableMap.TrieNode<K of kotlinx.collections.immutable.implementations.immutableMap.PersistentHashMapBuilder, V of kotlinx.collections.immutable.implementations.immutableMap.PersistentHashMapBuilder>");
        }
        this.setNode$kotlinx_collections_immutable(trieNode);
        return oldSize != this.size();
    }

    @Override
    public void clear() {
        TrieNode trieNode = TrieNode.Companion.getEMPTY$kotlinx_collections_immutable();
        Intrinsics.checkNotNull((Object)trieNode, (String)"null cannot be cast to non-null type kotlinx.collections.immutable.implementations.immutableMap.TrieNode<K of kotlinx.collections.immutable.implementations.immutableMap.PersistentHashMapBuilder, V of kotlinx.collections.immutable.implementations.immutableMap.PersistentHashMapBuilder>");
        this.setNode$kotlinx_collections_immutable(trieNode);
        this.setSize(0);
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Map)) {
            return false;
        }
        if (this.size() != ((Map)other).size()) {
            return false;
        }
        Map map2 = (Map)other;
        return map2 instanceof PersistentHashMap ? this.node.equalsWith$kotlinx_collections_immutable(((PersistentHashMap)other).getNode$kotlinx_collections_immutable(), equals.1.INSTANCE) : (map2 instanceof PersistentHashMapBuilder ? this.node.equalsWith$kotlinx_collections_immutable(((PersistentHashMapBuilder)other).node, equals.2.INSTANCE) : (map2 instanceof PersistentOrderedMap ? this.node.equalsWith$kotlinx_collections_immutable(((PersistentOrderedMap)other).getHashMap$kotlinx_collections_immutable().getNode$kotlinx_collections_immutable(), equals.3.INSTANCE) : (map2 instanceof PersistentOrderedMapBuilder ? this.node.equalsWith$kotlinx_collections_immutable(((PersistentOrderedMapBuilder)other).getHashMapBuilder$kotlinx_collections_immutable().node, equals.4.INSTANCE) : MapImplementation.INSTANCE.equals$kotlinx_collections_immutable(this, (Map)other))));
    }

    @Override
    public int hashCode() {
        return MapImplementation.INSTANCE.hashCode$kotlinx_collections_immutable(this);
    }
}

