/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.collections.immutable.implementations.immutableList;

import java.util.NoSuchElementException;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.collections.immutable.implementations.immutableList.AbstractListIterator;
import kotlinx.collections.immutable.implementations.immutableList.UtilsKt;
import org.jetbrains.annotations.NotNull;

public final class TrieIterator<E>
extends AbstractListIterator<E> {
    private int height;
    @NotNull
    private Object[] path;
    private boolean isInRightEdge;

    public TrieIterator(@NotNull Object[] root, int index, int size, int height) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        super(index, size);
        this.height = height;
        this.path = new Object[this.height];
        this.isInRightEdge = index == size;
        this.path[0] = root;
        this.fillPath(index - (this.isInRightEdge ? 1 : 0), 1);
    }

    public final void reset$kotlinx_collections_immutable(@NotNull Object[] root, int index, int size, int height) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        this.setIndex(index);
        this.setSize(size);
        this.height = height;
        if (this.path.length < height) {
            this.path = new Object[height];
        }
        this.path[0] = root;
        this.isInRightEdge = index == size;
        this.fillPath(index - (this.isInRightEdge ? 1 : 0), 1);
    }

    private final void fillPath(int index, int startLevel) {
        int shift = (this.height - startLevel) * 5;
        for (int i2 = startLevel; i2 < this.height; ++i2) {
            Object object = this.path[i2 - 1];
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Array<kotlin.Any?>");
            this.path[i2] = ((Object[])object)[UtilsKt.indexSegment(index, shift)];
            shift -= 5;
        }
    }

    private final void fillPathIfNeeded(int indexPredicate) {
        int shift = 0;
        while (UtilsKt.indexSegment(this.getIndex(), shift) == indexPredicate) {
            shift += 5;
        }
        if (shift > 0) {
            int level = this.height - 1 - shift / 5;
            this.fillPath(this.getIndex(), level + 1);
        }
    }

    private final E elementAtCurrentIndex() {
        int leafBufferIndex = this.getIndex() & 0x1F;
        Object object = this.path[this.height - 1];
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Array<E of kotlinx.collections.immutable.implementations.immutableList.TrieIterator>");
        return (E)((Object[])object)[leafBufferIndex];
    }

    @Override
    public E next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        E result2 = this.elementAtCurrentIndex();
        this.setIndex(this.getIndex() + 1);
        if (this.getIndex() == this.getSize()) {
            this.isInRightEdge = true;
            return result2;
        }
        this.fillPathIfNeeded(0);
        return result2;
    }

    @Override
    public E previous() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        this.setIndex(this.getIndex() - 1);
        if (this.isInRightEdge) {
            this.isInRightEdge = false;
            return this.elementAtCurrentIndex();
        }
        this.fillPathIfNeeded(31);
        return this.elementAtCurrentIndex();
    }
}

