/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.collections.immutable;

import java.util.List;
import kotlin.collections.AbstractList;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlinx.collections.immutable.ImmutableCollection;
import kotlinx.collections.immutable.internal.ListImplementation;
import org.jetbrains.annotations.NotNull;

public interface ImmutableList<E>
extends List<E>,
KMappedMarker,
ImmutableCollection<E> {

    public static final class DefaultImpls {
        @NotNull
        public static <E> ImmutableList<E> subList(@NotNull ImmutableList<? extends E> $this, int fromIndex, int toIndex) {
            return new SubList<E>($this, fromIndex, toIndex);
        }
    }

    private static final class SubList<E>
    extends AbstractList<E>
    implements ImmutableList<E> {
        @NotNull
        private final ImmutableList<E> source;
        private final int fromIndex;
        private final int toIndex;
        private int _size;

        public SubList(@NotNull ImmutableList<? extends E> source, int fromIndex, int toIndex) {
            Intrinsics.checkNotNullParameter(source, (String)"source");
            this.source = source;
            this.fromIndex = fromIndex;
            this.toIndex = toIndex;
            ListImplementation.checkRangeIndexes$kotlinx_collections_immutable(this.fromIndex, this.toIndex, this.source.size());
            this._size = this.toIndex - this.fromIndex;
        }

        @Override
        public E get(int index) {
            ListImplementation.checkElementIndex$kotlinx_collections_immutable(index, this._size);
            return this.source.get(this.fromIndex + index);
        }

        public int getSize() {
            return this._size;
        }

        @Override
        @NotNull
        public ImmutableList<E> subList(int fromIndex, int toIndex) {
            ListImplementation.checkRangeIndexes$kotlinx_collections_immutable(fromIndex, toIndex, this._size);
            return new SubList<E>(this.source, this.fromIndex + fromIndex, this.fromIndex + toIndex);
        }
    }
}

