/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.security.AccessController;
import java.security.PrivilegedAction;

public final class SystemPropertyUtil {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(SystemPropertyUtil.class);

    public static boolean contains(String key2) {
        return SystemPropertyUtil.get(key2) != null;
    }

    public static String get(String key2) {
        return SystemPropertyUtil.get(key2, null);
    }

    public static String get(final String key2, String def2) {
        ObjectUtil.checkNonEmpty(key2, "key");
        String value2 = null;
        try {
            value2 = System.getSecurityManager() == null ? System.getProperty(key2) : AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty(key2);
                }
            });
        }
        catch (SecurityException e) {
            logger.warn("Unable to retrieve a system property '{}'; default values will be used.", (Object)key2, (Object)e);
        }
        if (value2 == null) {
            return def2;
        }
        return value2;
    }

    public static boolean getBoolean(String key2, boolean def2) {
        String value2 = SystemPropertyUtil.get(key2);
        if (value2 == null) {
            return def2;
        }
        if ((value2 = value2.trim().toLowerCase()).isEmpty()) {
            return def2;
        }
        if ("true".equals(value2) || "yes".equals(value2) || "1".equals(value2)) {
            return true;
        }
        if ("false".equals(value2) || "no".equals(value2) || "0".equals(value2)) {
            return false;
        }
        logger.warn("Unable to parse the boolean system property '{}':{} - using the default value: {}", key2, value2, def2);
        return def2;
    }

    public static int getInt(String key2, int def2) {
        String value2 = SystemPropertyUtil.get(key2);
        if (value2 == null) {
            return def2;
        }
        value2 = value2.trim();
        try {
            return Integer.parseInt(value2);
        }
        catch (Exception exception) {
            logger.warn("Unable to parse the integer system property '{}':{} - using the default value: {}", key2, value2, def2);
            return def2;
        }
    }

    public static long getLong(String key2, long def2) {
        String value2 = SystemPropertyUtil.get(key2);
        if (value2 == null) {
            return def2;
        }
        value2 = value2.trim();
        try {
            return Long.parseLong(value2);
        }
        catch (Exception exception) {
            logger.warn("Unable to parse the long integer system property '{}':{} - using the default value: {}", key2, value2, def2);
            return def2;
        }
    }

    private SystemPropertyUtil() {
    }
}

