/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.concurrent;

import io.netty.util.concurrent.AbstractScheduledEventExecutor;
import io.netty.util.concurrent.DefaultPromise;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.FastThreadLocal;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GlobalEventExecutor;
import io.netty.util.concurrent.OrderedEventExecutor;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.RejectedExecutionHandler;
import io.netty.util.concurrent.ScheduledFutureTask;
import io.netty.util.concurrent.ThreadProperties;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.ThreadExecutorMap;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.Async;

public abstract class SingleThreadEventExecutor
extends AbstractScheduledEventExecutor
implements OrderedEventExecutor {
    static final int DEFAULT_MAX_PENDING_EXECUTOR_TASKS = Math.max(16, SystemPropertyUtil.getInt("io.netty.eventexecutor.maxPendingTasks", Integer.MAX_VALUE));
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(SingleThreadEventExecutor.class);
    private static final Runnable NOOP_TASK = new Runnable(){

        @Override
        public void run() {
        }
    };
    private static final AtomicIntegerFieldUpdater<SingleThreadEventExecutor> STATE_UPDATER = AtomicIntegerFieldUpdater.newUpdater(SingleThreadEventExecutor.class, "state");
    private static final AtomicReferenceFieldUpdater<SingleThreadEventExecutor, ThreadProperties> PROPERTIES_UPDATER = AtomicReferenceFieldUpdater.newUpdater(SingleThreadEventExecutor.class, ThreadProperties.class, "threadProperties");
    private final Queue<Runnable> taskQueue;
    private volatile Thread thread;
    private volatile ThreadProperties threadProperties;
    private final Executor executor;
    private volatile boolean interrupted;
    private final Lock processingLock = new ReentrantLock();
    private final CountDownLatch threadLock = new CountDownLatch(1);
    private final Set<Runnable> shutdownHooks = new LinkedHashSet<Runnable>();
    private final boolean addTaskWakesUp;
    private final int maxPendingTasks;
    private final RejectedExecutionHandler rejectedExecutionHandler;
    private final boolean supportSuspension;
    private long lastExecutionTime;
    private volatile int state = 1;
    private volatile long gracefulShutdownQuietPeriod;
    private volatile long gracefulShutdownTimeout;
    private long gracefulShutdownStartTime;
    private final Promise<?> terminationFuture = new DefaultPromise(GlobalEventExecutor.INSTANCE);
    private static final long SCHEDULE_PURGE_INTERVAL = TimeUnit.SECONDS.toNanos(1L);

    protected SingleThreadEventExecutor(EventExecutorGroup parent, Executor executor, boolean addTaskWakesUp, boolean supportSuspension, int maxPendingTasks, RejectedExecutionHandler rejectedHandler) {
        super(parent);
        this.addTaskWakesUp = addTaskWakesUp;
        this.supportSuspension = supportSuspension;
        this.maxPendingTasks = Math.max(16, maxPendingTasks);
        this.executor = ThreadExecutorMap.apply(executor, (EventExecutor)this);
        this.taskQueue = this.newTaskQueue(this.maxPendingTasks);
        this.rejectedExecutionHandler = ObjectUtil.checkNotNull(rejectedHandler, "rejectedHandler");
    }

    protected SingleThreadEventExecutor(EventExecutorGroup parent, Executor executor, boolean addTaskWakesUp, boolean supportSuspension, Queue<Runnable> taskQueue, RejectedExecutionHandler rejectedHandler) {
        super(parent);
        this.addTaskWakesUp = addTaskWakesUp;
        this.supportSuspension = supportSuspension;
        this.maxPendingTasks = DEFAULT_MAX_PENDING_EXECUTOR_TASKS;
        this.executor = ThreadExecutorMap.apply(executor, (EventExecutor)this);
        this.taskQueue = ObjectUtil.checkNotNull(taskQueue, "taskQueue");
        this.rejectedExecutionHandler = ObjectUtil.checkNotNull(rejectedHandler, "rejectedHandler");
    }

    protected Queue<Runnable> newTaskQueue(int maxPendingTasks) {
        return new LinkedBlockingQueue<Runnable>(maxPendingTasks);
    }

    protected Runnable pollTask() {
        assert (this.inEventLoop());
        return SingleThreadEventExecutor.pollTaskFrom(this.taskQueue);
    }

    protected static Runnable pollTaskFrom(Queue<Runnable> taskQueue) {
        Runnable task;
        while ((task = taskQueue.poll()) == WAKEUP_TASK) {
        }
        return task;
    }

    private boolean fetchFromScheduledTaskQueue() {
        Runnable scheduledTask;
        if (this.scheduledTaskQueue == null || this.scheduledTaskQueue.isEmpty()) {
            return true;
        }
        long nanoTime = this.getCurrentTimeNanos();
        do {
            if ((scheduledTask = this.pollScheduledTask(nanoTime)) != null) continue;
            return true;
        } while (this.taskQueue.offer(scheduledTask));
        this.scheduledTaskQueue.add((ScheduledFutureTask)scheduledTask);
        return false;
    }

    protected boolean hasTasks() {
        assert (this.inEventLoop());
        return !this.taskQueue.isEmpty();
    }

    protected void addTask(Runnable task) {
        ObjectUtil.checkNotNull(task, "task");
        if (!this.offerTask(task)) {
            this.reject(task);
        }
    }

    final boolean offerTask(Runnable task) {
        if (this.isShutdown()) {
            SingleThreadEventExecutor.reject();
        }
        return this.taskQueue.offer(task);
    }

    protected boolean removeTask(Runnable task) {
        return this.taskQueue.remove(ObjectUtil.checkNotNull(task, "task"));
    }

    protected boolean runAllTasks() {
        boolean fetchedAll;
        assert (this.inEventLoop());
        boolean ranAtLeastOne = false;
        do {
            fetchedAll = this.fetchFromScheduledTaskQueue();
            if (!this.runAllTasksFrom(this.taskQueue)) continue;
            ranAtLeastOne = true;
        } while (!fetchedAll);
        if (ranAtLeastOne) {
            this.lastExecutionTime = this.getCurrentTimeNanos();
        }
        this.afterRunningAllTasks();
        return ranAtLeastOne;
    }

    protected final boolean runAllTasksFrom(Queue<Runnable> taskQueue) {
        Runnable task = SingleThreadEventExecutor.pollTaskFrom(taskQueue);
        if (task == null) {
            return false;
        }
        do {
            SingleThreadEventExecutor.safeExecute(task);
        } while ((task = SingleThreadEventExecutor.pollTaskFrom(taskQueue)) != null);
        return true;
    }

    protected boolean runAllTasks(long timeoutNanos) {
        long lastExecutionTime;
        block2: {
            this.fetchFromScheduledTaskQueue();
            Runnable task = this.pollTask();
            if (task == null) {
                this.afterRunningAllTasks();
                return false;
            }
            long deadline = timeoutNanos > 0L ? this.getCurrentTimeNanos() + timeoutNanos : 0L;
            long runTasks = 0L;
            do {
                SingleThreadEventExecutor.safeExecute(task);
                if ((++runTasks & 0x3FL) == 0L && (lastExecutionTime = this.getCurrentTimeNanos()) >= deadline) break block2;
            } while ((task = this.pollTask()) != null);
            lastExecutionTime = this.getCurrentTimeNanos();
        }
        this.afterRunningAllTasks();
        this.lastExecutionTime = lastExecutionTime;
        return true;
    }

    protected void afterRunningAllTasks() {
    }

    protected long delayNanos(long currentTimeNanos) {
        currentTimeNanos -= SingleThreadEventExecutor.initialNanoTime();
        ScheduledFutureTask<?> scheduledTask = this.peekScheduledTask();
        if (scheduledTask == null) {
            return SCHEDULE_PURGE_INTERVAL;
        }
        return scheduledTask.delayNanos(currentTimeNanos);
    }

    protected void updateLastExecutionTime() {
        this.lastExecutionTime = this.getCurrentTimeNanos();
    }

    protected abstract void run();

    protected void cleanup() {
    }

    protected void wakeup(boolean inEventLoop) {
        if (!inEventLoop) {
            this.taskQueue.offer(WAKEUP_TASK);
        }
    }

    @Override
    public boolean inEventLoop(Thread thread2) {
        return thread2 == this.thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean runShutdownHooks() {
        boolean ran = false;
        while (!this.shutdownHooks.isEmpty()) {
            ArrayList<Runnable> copy2 = new ArrayList<Runnable>(this.shutdownHooks);
            this.shutdownHooks.clear();
            for (Runnable task : copy2) {
                try {
                    SingleThreadEventExecutor.runTask(task);
                }
                catch (Throwable t2) {
                    logger.warn("Shutdown hook raised an exception.", t2);
                }
                finally {
                    ran = true;
                }
            }
        }
        if (ran) {
            this.lastExecutionTime = this.getCurrentTimeNanos();
        }
        return ran;
    }

    @Override
    public Future<?> shutdownGracefully(long quietPeriod, long timeout2, TimeUnit unit) {
        boolean wakeup;
        int newState;
        int oldState;
        ObjectUtil.checkPositiveOrZero(quietPeriod, "quietPeriod");
        if (timeout2 < quietPeriod) {
            throw new IllegalArgumentException("timeout: " + timeout2 + " (expected >= quietPeriod (" + quietPeriod + "))");
        }
        ObjectUtil.checkNotNull(unit, "unit");
        if (this.isShuttingDown()) {
            return this.terminationFuture();
        }
        boolean inEventLoop = this.inEventLoop();
        do {
            if (this.isShuttingDown()) {
                return this.terminationFuture();
            }
            wakeup = true;
            oldState = this.state;
            if (inEventLoop) {
                newState = 5;
                continue;
            }
            switch (oldState) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    newState = 5;
                    break;
                }
                default: {
                    newState = oldState;
                    wakeup = false;
                }
            }
        } while (!STATE_UPDATER.compareAndSet(this, oldState, newState));
        this.gracefulShutdownQuietPeriod = unit.toNanos(quietPeriod);
        this.gracefulShutdownTimeout = unit.toNanos(timeout2);
        if (this.ensureThreadStarted(oldState)) {
            return this.terminationFuture;
        }
        if (wakeup) {
            this.taskQueue.offer(WAKEUP_TASK);
            if (!this.addTaskWakesUp) {
                this.wakeup(inEventLoop);
            }
        }
        return this.terminationFuture();
    }

    @Override
    public Future<?> terminationFuture() {
        return this.terminationFuture;
    }

    @Override
    @Deprecated
    public void shutdown() {
        boolean wakeup;
        int newState;
        int oldState;
        if (this.isShutdown()) {
            return;
        }
        boolean inEventLoop = this.inEventLoop();
        do {
            if (this.isShuttingDown()) {
                return;
            }
            wakeup = true;
            oldState = this.state;
            if (inEventLoop) {
                newState = 6;
                continue;
            }
            switch (oldState) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    newState = 6;
                    break;
                }
                default: {
                    newState = oldState;
                    wakeup = false;
                }
            }
        } while (!STATE_UPDATER.compareAndSet(this, oldState, newState));
        if (this.ensureThreadStarted(oldState)) {
            return;
        }
        if (wakeup) {
            this.taskQueue.offer(WAKEUP_TASK);
            if (!this.addTaskWakesUp) {
                this.wakeup(inEventLoop);
            }
        }
    }

    @Override
    public boolean isShuttingDown() {
        return this.state >= 5;
    }

    @Override
    public boolean isShutdown() {
        return this.state >= 6;
    }

    @Override
    public boolean isTerminated() {
        return this.state == 7;
    }

    public boolean trySuspend() {
        if (this.supportSuspension) {
            if (STATE_UPDATER.compareAndSet(this, 4, 2)) {
                this.wakeup(this.inEventLoop());
                return true;
            }
            int currentState = this.state;
            return currentState == 3 || currentState == 2;
        }
        return false;
    }

    protected boolean canSuspend() {
        return this.canSuspend(this.state);
    }

    protected boolean canSuspend(int state2) {
        assert (this.inEventLoop());
        return this.supportSuspension && (state2 == 3 || state2 == 2) && !this.hasTasks() && this.nextScheduledTaskDeadlineNanos() == -1L;
    }

    protected boolean confirmShutdown() {
        if (!this.isShuttingDown()) {
            return false;
        }
        if (!this.inEventLoop()) {
            throw new IllegalStateException("must be invoked from an event loop");
        }
        this.cancelScheduledTasks();
        if (this.gracefulShutdownStartTime == 0L) {
            this.gracefulShutdownStartTime = this.getCurrentTimeNanos();
        }
        if (this.runAllTasks() || this.runShutdownHooks()) {
            if (this.isShutdown()) {
                return true;
            }
            if (this.gracefulShutdownQuietPeriod == 0L) {
                return true;
            }
            this.taskQueue.offer(WAKEUP_TASK);
            return false;
        }
        long nanoTime = this.getCurrentTimeNanos();
        if (this.isShutdown() || nanoTime - this.gracefulShutdownStartTime > this.gracefulShutdownTimeout) {
            return true;
        }
        if (nanoTime - this.lastExecutionTime <= this.gracefulShutdownQuietPeriod) {
            this.taskQueue.offer(WAKEUP_TASK);
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean awaitTermination(long timeout2, TimeUnit unit) throws InterruptedException {
        ObjectUtil.checkNotNull(unit, "unit");
        if (this.inEventLoop()) {
            throw new IllegalStateException("cannot await termination of the current thread");
        }
        this.threadLock.await(timeout2, unit);
        return this.isTerminated();
    }

    @Override
    public void execute(Runnable task) {
        this.execute0(task);
    }

    @Override
    public void lazyExecute(Runnable task) {
        this.lazyExecute0(task);
    }

    private void execute0(@Async.Schedule Runnable task) {
        ObjectUtil.checkNotNull(task, "task");
        this.execute(task, this.wakesUpForTask(task));
    }

    private void lazyExecute0(@Async.Schedule Runnable task) {
        this.execute(ObjectUtil.checkNotNull(task, "task"), false);
    }

    @Override
    void scheduleRemoveScheduled(final ScheduledFutureTask<?> task) {
        ObjectUtil.checkNotNull(task, "task");
        int currentState = this.state;
        if (this.supportSuspension && currentState == 3) {
            this.execute(new Runnable(){

                @Override
                public void run() {
                    task.run();
                    if (SingleThreadEventExecutor.this.canSuspend(3)) {
                        SingleThreadEventExecutor.this.trySuspend();
                    }
                }
            }, true);
        } else {
            this.execute(task, false);
        }
    }

    private void execute(Runnable task, boolean immediate) {
        boolean inEventLoop = this.inEventLoop();
        this.addTask(task);
        if (!inEventLoop) {
            this.startThread();
            if (this.isShutdown()) {
                boolean reject = false;
                try {
                    if (this.removeTask(task)) {
                        reject = true;
                    }
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
                if (reject) {
                    SingleThreadEventExecutor.reject();
                }
            }
        }
        if (!this.addTaskWakesUp && immediate) {
            this.wakeup(inEventLoop);
        }
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        this.throwIfInEventLoop("invokeAny");
        return super.invokeAny(tasks);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout2, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        this.throwIfInEventLoop("invokeAny");
        return super.invokeAny(tasks, timeout2, unit);
    }

    @Override
    public <T> List<java.util.concurrent.Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        this.throwIfInEventLoop("invokeAll");
        return super.invokeAll(tasks);
    }

    @Override
    public <T> List<java.util.concurrent.Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout2, TimeUnit unit) throws InterruptedException {
        this.throwIfInEventLoop("invokeAll");
        return super.invokeAll(tasks, timeout2, unit);
    }

    private void throwIfInEventLoop(String method) {
        if (this.inEventLoop()) {
            throw new RejectedExecutionException("Calling " + method + " from within the EventLoop is not allowed");
        }
    }

    protected boolean wakesUpForTask(Runnable task) {
        return true;
    }

    protected static void reject() {
        throw new RejectedExecutionException("event executor terminated");
    }

    protected final void reject(Runnable task) {
        this.rejectedExecutionHandler.rejected(task, this);
    }

    private void startThread() {
        int currentState = this.state;
        if ((currentState == 1 || currentState == 3) && STATE_UPDATER.compareAndSet(this, currentState, 4)) {
            boolean success = false;
            try {
                this.doStartThread();
                success = true;
            }
            finally {
                if (!success) {
                    STATE_UPDATER.compareAndSet(this, 4, 1);
                }
            }
        }
    }

    private boolean ensureThreadStarted(int oldState) {
        if (oldState == 1 || oldState == 3) {
            try {
                this.doStartThread();
            }
            catch (Throwable cause) {
                STATE_UPDATER.set(this, 7);
                this.terminationFuture.tryFailure(cause);
                if (!(cause instanceof Exception)) {
                    PlatformDependent.throwException(cause);
                }
                return true;
            }
        }
        return false;
    }

    private void doStartThread() {
        this.executor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void run() {
                boolean shutdown2;
                boolean suspend;
                boolean success;
                block67: {
                    SingleThreadEventExecutor.this.processingLock.lock();
                    assert (SingleThreadEventExecutor.this.thread == null);
                    SingleThreadEventExecutor.this.thread = Thread.currentThread();
                    if (SingleThreadEventExecutor.this.interrupted) {
                        SingleThreadEventExecutor.this.thread.interrupt();
                        SingleThreadEventExecutor.this.interrupted = false;
                    }
                    success = false;
                    SingleThreadEventExecutor.this.updateLastExecutionTime();
                    suspend = false;
                    do {
                        SingleThreadEventExecutor.this.run();
                        success = true;
                        int currentState = SingleThreadEventExecutor.this.state;
                        if (!SingleThreadEventExecutor.this.canSuspend(currentState)) break block67;
                    } while (!STATE_UPDATER.compareAndSet(SingleThreadEventExecutor.this, 2, 3) || !SingleThreadEventExecutor.this.canSuspend(3) && STATE_UPDATER.compareAndSet(SingleThreadEventExecutor.this, 3, 4));
                    suspend = true;
                }
                boolean bl = shutdown2 = !suspend;
                if (shutdown2) {
                    int oldState;
                    while ((oldState = SingleThreadEventExecutor.this.state) < 5 && !STATE_UPDATER.compareAndSet(SingleThreadEventExecutor.this, oldState, 5)) {
                    }
                    if (success && SingleThreadEventExecutor.this.gracefulShutdownStartTime == 0L && logger.isErrorEnabled()) {
                        logger.error("Buggy " + EventExecutor.class.getSimpleName() + " implementation; " + SingleThreadEventExecutor.class.getSimpleName() + ".confirmShutdown() must be called before run() implementation terminates.");
                    }
                }
                try {
                    int currentState;
                    if (!shutdown2) return;
                    while (!SingleThreadEventExecutor.this.confirmShutdown()) {
                    }
                    while ((currentState = SingleThreadEventExecutor.this.state) < 6 && !STATE_UPDATER.compareAndSet(SingleThreadEventExecutor.this, currentState, 6)) {
                    }
                    SingleThreadEventExecutor.this.confirmShutdown();
                    return;
                }
                finally {
                    block68: {
                        try {
                            if (shutdown2) {
                                try {
                                    SingleThreadEventExecutor.this.cleanup();
                                    break block68;
                                }
                                finally {
                                    FastThreadLocal.removeAll();
                                    STATE_UPDATER.set(SingleThreadEventExecutor.this, 7);
                                    SingleThreadEventExecutor.this.threadLock.countDown();
                                    int numUserTasks = SingleThreadEventExecutor.this.drainTasks();
                                    if (numUserTasks > 0 && logger.isWarnEnabled()) {
                                        logger.warn("An event executor terminated with non-empty task queue (" + numUserTasks + ')');
                                    }
                                    SingleThreadEventExecutor.this.terminationFuture.setSuccess(null);
                                }
                            }
                            FastThreadLocal.removeAll();
                            SingleThreadEventExecutor.this.threadProperties = null;
                        }
                        finally {
                            SingleThreadEventExecutor.this.thread = null;
                            SingleThreadEventExecutor.this.processingLock.unlock();
                        }
                    }
                }
                catch (Throwable t2) {
                    logger.warn("Unexpected exception from an event executor: ", t2);
                    boolean bl2 = shutdown3 = !suspend;
                    if (shutdown3) {
                        int oldState;
                        while ((oldState = SingleThreadEventExecutor.this.state) < 5 && !STATE_UPDATER.compareAndSet(SingleThreadEventExecutor.this, oldState, 5)) {
                        }
                        if (success && SingleThreadEventExecutor.this.gracefulShutdownStartTime == 0L && logger.isErrorEnabled()) {
                            logger.error("Buggy " + EventExecutor.class.getSimpleName() + " implementation; " + SingleThreadEventExecutor.class.getSimpleName() + ".confirmShutdown() must be called before run() implementation terminates.");
                        }
                    }
                    try {
                        int currentState;
                        if (!shutdown3) return;
                        while (!SingleThreadEventExecutor.this.confirmShutdown()) {
                        }
                        while ((currentState = SingleThreadEventExecutor.this.state) < 6 && !STATE_UPDATER.compareAndSet(SingleThreadEventExecutor.this, currentState, 6)) {
                        }
                        SingleThreadEventExecutor.this.confirmShutdown();
                        return;
                    }
                    finally {
                        block69: {
                            try {
                                if (shutdown3) {
                                    try {
                                        SingleThreadEventExecutor.this.cleanup();
                                        break block69;
                                    }
                                    finally {
                                        FastThreadLocal.removeAll();
                                        STATE_UPDATER.set(SingleThreadEventExecutor.this, 7);
                                        SingleThreadEventExecutor.this.threadLock.countDown();
                                        int numUserTasks = SingleThreadEventExecutor.this.drainTasks();
                                        if (numUserTasks > 0 && logger.isWarnEnabled()) {
                                            logger.warn("An event executor terminated with non-empty task queue (" + numUserTasks + ')');
                                        }
                                        SingleThreadEventExecutor.this.terminationFuture.setSuccess(null);
                                    }
                                }
                                FastThreadLocal.removeAll();
                                SingleThreadEventExecutor.this.threadProperties = null;
                            }
                            finally {
                                SingleThreadEventExecutor.this.thread = null;
                                SingleThreadEventExecutor.this.processingLock.unlock();
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        boolean shutdown32;
                        boolean bl3 = shutdown32 = !suspend;
                        if (shutdown32) {
                            int oldState;
                            while ((oldState = SingleThreadEventExecutor.this.state) < 5 && !STATE_UPDATER.compareAndSet(SingleThreadEventExecutor.this, oldState, 5)) {
                            }
                            if (success && SingleThreadEventExecutor.this.gracefulShutdownStartTime == 0L && logger.isErrorEnabled()) {
                                logger.error("Buggy " + EventExecutor.class.getSimpleName() + " implementation; " + SingleThreadEventExecutor.class.getSimpleName() + ".confirmShutdown() must be called before run() implementation terminates.");
                            }
                        }
                        try {
                            int currentState;
                            if (!shutdown32) throw throwable;
                            while (!SingleThreadEventExecutor.this.confirmShutdown()) {
                            }
                            while ((currentState = SingleThreadEventExecutor.this.state) < 6 && !STATE_UPDATER.compareAndSet(SingleThreadEventExecutor.this, currentState, 6)) {
                            }
                            SingleThreadEventExecutor.this.confirmShutdown();
                            throw throwable;
                        }
                        finally {
                            block70: {
                                try {
                                    if (shutdown32) {
                                        try {
                                            SingleThreadEventExecutor.this.cleanup();
                                            break block70;
                                        }
                                        finally {
                                            FastThreadLocal.removeAll();
                                            STATE_UPDATER.set(SingleThreadEventExecutor.this, 7);
                                            SingleThreadEventExecutor.this.threadLock.countDown();
                                            int numUserTasks = SingleThreadEventExecutor.this.drainTasks();
                                            if (numUserTasks > 0 && logger.isWarnEnabled()) {
                                                logger.warn("An event executor terminated with non-empty task queue (" + numUserTasks + ')');
                                            }
                                            SingleThreadEventExecutor.this.terminationFuture.setSuccess(null);
                                        }
                                    }
                                    FastThreadLocal.removeAll();
                                    SingleThreadEventExecutor.this.threadProperties = null;
                                }
                                finally {
                                    SingleThreadEventExecutor.this.thread = null;
                                    SingleThreadEventExecutor.this.processingLock.unlock();
                                }
                            }
                        }
                    }
                }
            }
        });
    }

    final int drainTasks() {
        Runnable runnable2;
        int numTasks = 0;
        while ((runnable2 = this.taskQueue.poll()) != null) {
            if (WAKEUP_TASK == runnable2) continue;
            ++numTasks;
        }
        return numTasks;
    }
}

