/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.handler.ssl.OpenSslSession;
import io.netty.handler.ssl.OpenSslSessionContext;
import io.netty.handler.ssl.OpenSslSessionId;
import io.netty.handler.ssl.ReferenceCountedOpenSslEngine;
import io.netty.internal.tcnative.SSLSession;
import io.netty.internal.tcnative.SSLSessionCache;
import io.netty.util.ResourceLeakDetector;
import io.netty.util.ResourceLeakDetectorFactory;
import io.netty.util.ResourceLeakTracker;
import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.SystemPropertyUtil;
import java.security.Principal;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.security.cert.X509Certificate;

class OpenSslSessionCache
implements SSLSessionCache {
    private static final OpenSslSession[] EMPTY_SESSIONS = new OpenSslSession[0];
    private static final int DEFAULT_CACHE_SIZE;
    private final Map<OpenSslSessionId, NativeSslSession> sessions;
    private final AtomicInteger maximumCacheSize;
    private final AtomicInteger sessionTimeout;

    final void setSessionTimeout(int seconds) {
        int oldTimeout = this.sessionTimeout.getAndSet(seconds);
        if (oldTimeout > seconds) {
            this.clear();
        }
    }

    final int getSessionTimeout() {
        return this.sessionTimeout.get();
    }

    protected void sessionRemoved(NativeSslSession session2) {
    }

    final void setSessionCacheSize(int size) {
        long oldSize = this.maximumCacheSize.getAndSet(size);
        if (oldSize > (long)size || size == 0) {
            this.clear();
        }
    }

    final int getSessionCacheSize() {
        return this.maximumCacheSize.get();
    }

    boolean setSession(long ssl, OpenSslSession session2, String host, int port2) {
        return false;
    }

    final synchronized void removeSessionWithId(OpenSslSessionId id) {
        NativeSslSession sslSession = this.sessions.remove(id);
        if (sslSession != null) {
            this.notifyRemovalAndFree(sslSession);
        }
    }

    private void notifyRemovalAndFree(NativeSslSession session2) {
        this.sessionRemoved(session2);
        session2.free();
    }

    final synchronized OpenSslSession getSession(OpenSslSessionId id) {
        NativeSslSession session2 = this.sessions.get(id);
        if (session2 != null && !session2.isValid()) {
            this.removeSessionWithId(session2.sessionId());
            return null;
        }
        return session2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final List<OpenSslSessionId> getIds() {
        OpenSslSession[] sessionsArray;
        OpenSslSessionCache openSslSessionCache = this;
        synchronized (openSslSessionCache) {
            sessionsArray = this.sessions.values().toArray(EMPTY_SESSIONS);
        }
        ArrayList<OpenSslSessionId> ids = new ArrayList<OpenSslSessionId>(sessionsArray.length);
        for (OpenSslSession session2 : sessionsArray) {
            if (!session2.isValid()) continue;
            ids.add(session2.sessionId());
        }
        return ids;
    }

    synchronized void clear() {
        Iterator<Map.Entry<OpenSslSessionId, NativeSslSession>> iterator2 = this.sessions.entrySet().iterator();
        while (iterator2.hasNext()) {
            NativeSslSession session2 = iterator2.next().getValue();
            iterator2.remove();
            this.notifyRemovalAndFree(session2);
        }
    }

    static {
        int cacheSize = SystemPropertyUtil.getInt("javax.net.ssl.sessionCacheSize", 20480);
        DEFAULT_CACHE_SIZE = cacheSize >= 0 ? cacheSize : 20480;
    }

    static final class NativeSslSession
    implements OpenSslSession {
        static final ResourceLeakDetector<NativeSslSession> LEAK_DETECTOR = ResourceLeakDetectorFactory.instance().newResourceLeakDetector(NativeSslSession.class);
        private final ResourceLeakTracker<NativeSslSession> leakTracker;
        private final long session;
        private final String peerHost;
        private final int peerPort;
        private final OpenSslSessionId id;
        private final long timeout;
        private final long creationTime;
        private volatile long lastAccessedTime;
        private volatile boolean valid;
        private boolean freed;

        @Override
        public void prepareHandshake() {
            throw new UnsupportedOperationException();
        }

        synchronized void free() {
            this.close();
            SSLSession.free((long)this.session);
        }

        void close() {
            assert (!this.freed);
            this.freed = true;
            this.invalidate();
            if (this.leakTracker != null) {
                this.leakTracker.close(this);
            }
        }

        @Override
        public OpenSslSessionId sessionId() {
            return this.id;
        }

        boolean isValid(long now2) {
            return this.creationTime + this.timeout >= now2 && this.valid;
        }

        @Override
        public OpenSslSessionContext getSessionContext() {
            return null;
        }

        @Override
        public void tryExpandApplicationBufferSize(int packetLengthDataOnly) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void handshakeFinished(byte[] id, String cipher, String protocol, byte[] peerCertificate, byte[][] peerCertificateChain, long creationTime, long timeout2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public byte[] getId() {
            return this.id.cloneBytes();
        }

        @Override
        public long getCreationTime() {
            return this.creationTime;
        }

        @Override
        public long getLastAccessedTime() {
            return this.lastAccessedTime;
        }

        @Override
        public void invalidate() {
            this.valid = false;
        }

        @Override
        public boolean isValid() {
            return this.isValid(System.currentTimeMillis());
        }

        @Override
        public void putValue(String name2, Object value2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object getValue(String name2) {
            return null;
        }

        @Override
        public void removeValue(String name2) {
        }

        @Override
        public String[] getValueNames() {
            return EmptyArrays.EMPTY_STRINGS;
        }

        @Override
        public Certificate[] getPeerCertificates() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Certificate[] getLocalCertificates() {
            throw new UnsupportedOperationException();
        }

        @Override
        public X509Certificate[] getPeerCertificateChain() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Principal getPeerPrincipal() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Principal getLocalPrincipal() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getCipherSuite() {
            return null;
        }

        @Override
        public String getProtocol() {
            return null;
        }

        @Override
        public String getPeerHost() {
            return this.peerHost;
        }

        @Override
        public int getPeerPort() {
            return this.peerPort;
        }

        @Override
        public int getPacketBufferSize() {
            return ReferenceCountedOpenSslEngine.MAX_RECORD_SIZE;
        }

        @Override
        public int getApplicationBufferSize() {
            return ReferenceCountedOpenSslEngine.MAX_PLAINTEXT_LENGTH;
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof OpenSslSession)) {
                return false;
            }
            OpenSslSession session1 = (OpenSslSession)o;
            return this.id.equals(session1.sessionId());
        }
    }
}

