/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.util.AsciiString;

public class HttpStatusClass
extends Enum<HttpStatusClass> {
    public static final /* enum */ HttpStatusClass INFORMATIONAL = new HttpStatusClass(100, 200, "Informational");
    public static final /* enum */ HttpStatusClass SUCCESS = new HttpStatusClass(200, 300, "Success");
    public static final /* enum */ HttpStatusClass REDIRECTION = new HttpStatusClass(300, 400, "Redirection");
    public static final /* enum */ HttpStatusClass CLIENT_ERROR = new HttpStatusClass(400, 500, "Client Error");
    public static final /* enum */ HttpStatusClass SERVER_ERROR = new HttpStatusClass(500, 600, "Server Error");
    public static final /* enum */ HttpStatusClass UNKNOWN = new HttpStatusClass(0, 0, "Unknown Status"){

        @Override
        public boolean contains(int code) {
            return code < 100 || code >= 600;
        }
    };
    private static final HttpStatusClass[] statusArray;
    private final int min;
    private final int max;
    private final AsciiString defaultReasonPhrase;
    private static final /* synthetic */ HttpStatusClass[] $VALUES;

    public static HttpStatusClass valueOf(int code) {
        if (UNKNOWN.contains(code)) {
            return UNKNOWN;
        }
        return statusArray[HttpStatusClass.fast_div100(code)];
    }

    private static int fast_div100(int dividend) {
        return (int)((long)dividend * 1374389535L >> 37);
    }

    private HttpStatusClass(int min, int max, String defaultReasonPhrase) {
        this.min = min;
        this.max = max;
        this.defaultReasonPhrase = AsciiString.cached(defaultReasonPhrase);
    }

    public boolean contains(int code) {
        return code >= this.min && code < this.max;
    }

    static {
        $VALUES = new HttpStatusClass[]{INFORMATIONAL, SUCCESS, REDIRECTION, CLIENT_ERROR, SERVER_ERROR, UNKNOWN};
        statusArray = new HttpStatusClass[6];
        HttpStatusClass.statusArray[1] = INFORMATIONAL;
        HttpStatusClass.statusArray[2] = SUCCESS;
        HttpStatusClass.statusArray[3] = REDIRECTION;
        HttpStatusClass.statusArray[4] = CLIENT_ERROR;
        HttpStatusClass.statusArray[5] = SERVER_ERROR;
    }
}

