/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.handler.codec.HeadersUtils;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.util.AsciiString;
import io.netty.util.internal.ObjectUtil;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class HttpHeaders
implements Iterable<Map.Entry<String, String>> {
    @Deprecated
    public static final HttpHeaders EMPTY_HEADERS = EmptyHttpHeaders.instance();

    protected HttpHeaders() {
    }

    public abstract String get(String var1);

    public String get(CharSequence name2) {
        return this.get(name2.toString());
    }

    public abstract List<String> getAll(String var1);

    public List<String> getAll(CharSequence name2) {
        return this.getAll(name2.toString());
    }

    public abstract boolean contains(String var1);

    @Override
    @Deprecated
    public abstract Iterator<Map.Entry<String, String>> iterator();

    public abstract Iterator<Map.Entry<CharSequence, CharSequence>> iteratorCharSequence();

    public Iterator<String> valueStringIterator(CharSequence name2) {
        return this.getAll(name2).iterator();
    }

    public Iterator<? extends CharSequence> valueCharSequenceIterator(CharSequence name2) {
        return this.valueStringIterator(name2);
    }

    public boolean contains(CharSequence name2) {
        return this.contains(name2.toString());
    }

    public abstract boolean isEmpty();

    public abstract int size();

    public abstract Set<String> names();

    public abstract HttpHeaders add(String var1, Object var2);

    public HttpHeaders add(CharSequence name2, Object value2) {
        return this.add(name2.toString(), value2);
    }

    public abstract HttpHeaders add(String var1, Iterable<?> var2);

    public HttpHeaders add(CharSequence name2, Iterable<?> values) {
        return this.add(name2.toString(), values);
    }

    public HttpHeaders add(HttpHeaders headers2) {
        ObjectUtil.checkNotNull(headers2, "headers");
        for (Map.Entry<String, String> e : headers2) {
            this.add(e.getKey(), (Object)e.getValue());
        }
        return this;
    }

    public abstract HttpHeaders set(String var1, Object var2);

    public HttpHeaders set(CharSequence name2, Object value2) {
        return this.set(name2.toString(), value2);
    }

    public abstract HttpHeaders set(String var1, Iterable<?> var2);

    public HttpHeaders set(CharSequence name2, Iterable<?> values) {
        return this.set(name2.toString(), values);
    }

    public HttpHeaders set(HttpHeaders headers2) {
        ObjectUtil.checkNotNull(headers2, "headers");
        this.clear();
        if (headers2.isEmpty()) {
            return this;
        }
        for (Map.Entry<String, String> entry : headers2) {
            this.add(entry.getKey(), (Object)entry.getValue());
        }
        return this;
    }

    public abstract HttpHeaders setInt(CharSequence var1, int var2);

    public abstract HttpHeaders remove(String var1);

    public HttpHeaders remove(CharSequence name2) {
        return this.remove(name2.toString());
    }

    public abstract HttpHeaders clear();

    public boolean contains(String name2, String value2, boolean ignoreCase) {
        Iterator<String> valueIterator = this.valueStringIterator(name2);
        if (ignoreCase) {
            while (valueIterator.hasNext()) {
                if (!valueIterator.next().equalsIgnoreCase(value2)) continue;
                return true;
            }
        } else {
            while (valueIterator.hasNext()) {
                if (!valueIterator.next().equals(value2)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsValue(CharSequence name2, CharSequence value2, boolean ignoreCase) {
        Iterator<? extends CharSequence> itr = this.valueCharSequenceIterator(name2);
        while (itr.hasNext()) {
            if (!HttpHeaders.containsCommaSeparatedTrimmed(itr.next(), value2, ignoreCase)) continue;
            return true;
        }
        return false;
    }

    private static boolean containsCommaSeparatedTrimmed(CharSequence rawNext, CharSequence expected, boolean ignoreCase) {
        int begin = 0;
        if (ignoreCase) {
            int end = AsciiString.indexOf(rawNext, ',', begin);
            if (end == -1) {
                if (AsciiString.contentEqualsIgnoreCase(AsciiString.trim(rawNext), expected)) {
                    return true;
                }
            } else {
                do {
                    if (!AsciiString.contentEqualsIgnoreCase(AsciiString.trim(rawNext.subSequence(begin, end)), expected)) continue;
                    return true;
                } while ((end = AsciiString.indexOf(rawNext, ',', begin = end + 1)) != -1);
                if (begin < rawNext.length() && AsciiString.contentEqualsIgnoreCase(AsciiString.trim(rawNext.subSequence(begin, rawNext.length())), expected)) {
                    return true;
                }
            }
        } else {
            int end = AsciiString.indexOf(rawNext, ',', begin);
            if (end == -1) {
                if (AsciiString.contentEquals(AsciiString.trim(rawNext), expected)) {
                    return true;
                }
            } else {
                do {
                    if (!AsciiString.contentEquals(AsciiString.trim(rawNext.subSequence(begin, end)), expected)) continue;
                    return true;
                } while ((end = AsciiString.indexOf(rawNext, ',', begin = end + 1)) != -1);
                if (begin < rawNext.length() && AsciiString.contentEquals(AsciiString.trim(rawNext.subSequence(begin, rawNext.length())), expected)) {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean contains(CharSequence name2, CharSequence value2, boolean ignoreCase) {
        return this.contains(name2.toString(), value2.toString(), ignoreCase);
    }

    public String toString() {
        return HeadersUtils.toString(this.getClass(), this.iteratorCharSequence(), this.size());
    }

    public HttpHeaders copy() {
        return new DefaultHttpHeaders().set(this);
    }
}

