/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.handler.codec.CharSequenceValueConverter;
import io.netty.handler.codec.DateFormatter;
import io.netty.handler.codec.DefaultHeaders;
import io.netty.handler.codec.DefaultHeadersImpl;
import io.netty.handler.codec.HeadersUtils;
import io.netty.handler.codec.ValueConverter;
import io.netty.handler.codec.http.DefaultHttpHeadersFactory;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.util.AsciiString;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DefaultHttpHeaders
extends HttpHeaders {
    private final DefaultHeaders<CharSequence, CharSequence, ?> headers;

    public DefaultHttpHeaders() {
        this(DefaultHttpHeaders.nameValidator(true), DefaultHttpHeaders.valueValidator(true));
    }

    protected DefaultHttpHeaders(DefaultHeaders.NameValidator<CharSequence> nameValidator, DefaultHeaders.ValueValidator<CharSequence> valueValidator) {
        this(nameValidator, valueValidator, 16);
    }

    protected DefaultHttpHeaders(DefaultHeaders.NameValidator<CharSequence> nameValidator, DefaultHeaders.ValueValidator<CharSequence> valueValidator, int sizeHint) {
        this(new DefaultHeadersImpl<CharSequence, CharSequence>(AsciiString.CASE_INSENSITIVE_HASHER, HeaderValueConverter.INSTANCE, nameValidator, sizeHint, valueValidator));
    }

    protected DefaultHttpHeaders(DefaultHeaders<CharSequence, CharSequence, ?> headers2) {
        this.headers = headers2;
    }

    @Override
    public HttpHeaders add(HttpHeaders headers2) {
        if (headers2 instanceof DefaultHttpHeaders) {
            this.headers.add(((DefaultHttpHeaders)headers2).headers);
            return this;
        }
        return super.add(headers2);
    }

    @Override
    public HttpHeaders set(HttpHeaders headers2) {
        if (headers2 instanceof DefaultHttpHeaders) {
            this.headers.set(((DefaultHttpHeaders)headers2).headers);
            return this;
        }
        return super.set(headers2);
    }

    @Override
    public HttpHeaders add(String name2, Object value2) {
        this.headers.addObject((CharSequence)name2, value2);
        return this;
    }

    @Override
    public HttpHeaders add(CharSequence name2, Object value2) {
        this.headers.addObject(name2, value2);
        return this;
    }

    @Override
    public HttpHeaders add(String name2, Iterable<?> values) {
        this.headers.addObject((CharSequence)name2, values);
        return this;
    }

    @Override
    public HttpHeaders add(CharSequence name2, Iterable<?> values) {
        this.headers.addObject(name2, values);
        return this;
    }

    @Override
    public HttpHeaders remove(String name2) {
        this.headers.remove(name2);
        return this;
    }

    @Override
    public HttpHeaders remove(CharSequence name2) {
        this.headers.remove(name2);
        return this;
    }

    @Override
    public HttpHeaders set(String name2, Object value2) {
        this.headers.setObject((CharSequence)name2, value2);
        return this;
    }

    @Override
    public HttpHeaders set(CharSequence name2, Object value2) {
        this.headers.setObject(name2, value2);
        return this;
    }

    @Override
    public HttpHeaders set(String name2, Iterable<?> values) {
        this.headers.setObject((CharSequence)name2, values);
        return this;
    }

    @Override
    public HttpHeaders set(CharSequence name2, Iterable<?> values) {
        this.headers.setObject(name2, values);
        return this;
    }

    @Override
    public HttpHeaders setInt(CharSequence name2, int value2) {
        this.headers.setInt(name2, value2);
        return this;
    }

    @Override
    public HttpHeaders clear() {
        this.headers.clear();
        return this;
    }

    @Override
    public String get(String name2) {
        return this.get((CharSequence)name2);
    }

    @Override
    public String get(CharSequence name2) {
        return HeadersUtils.getAsString(this.headers, name2);
    }

    @Override
    public List<String> getAll(String name2) {
        return this.getAll((CharSequence)name2);
    }

    @Override
    public List<String> getAll(CharSequence name2) {
        return HeadersUtils.getAllAsString(this.headers, name2);
    }

    @Override
    @Deprecated
    public Iterator<Map.Entry<String, String>> iterator() {
        return HeadersUtils.iteratorAsString(this.headers);
    }

    @Override
    public Iterator<Map.Entry<CharSequence, CharSequence>> iteratorCharSequence() {
        return this.headers.iterator();
    }

    @Override
    public Iterator<String> valueStringIterator(CharSequence name2) {
        final Iterator<CharSequence> itr = this.valueCharSequenceIterator(name2);
        return new Iterator<String>(){

            @Override
            public boolean hasNext() {
                return itr.hasNext();
            }

            @Override
            public String next() {
                return ((CharSequence)itr.next()).toString();
            }

            @Override
            public void remove() {
                itr.remove();
            }
        };
    }

    public Iterator<CharSequence> valueCharSequenceIterator(CharSequence name2) {
        return this.headers.valueIterator(name2);
    }

    @Override
    public boolean contains(String name2) {
        return this.contains((CharSequence)name2);
    }

    @Override
    public boolean contains(CharSequence name2) {
        return this.headers.contains(name2);
    }

    @Override
    public boolean isEmpty() {
        return this.headers.isEmpty();
    }

    @Override
    public int size() {
        return this.headers.size();
    }

    @Override
    public boolean contains(String name2, String value2, boolean ignoreCase) {
        return this.contains((CharSequence)name2, (CharSequence)value2, ignoreCase);
    }

    @Override
    public boolean contains(CharSequence name2, CharSequence value2, boolean ignoreCase) {
        return this.headers.contains(name2, value2, ignoreCase ? AsciiString.CASE_INSENSITIVE_HASHER : AsciiString.CASE_SENSITIVE_HASHER);
    }

    @Override
    public Set<String> names() {
        return HeadersUtils.namesAsString(this.headers);
    }

    public boolean equals(Object o) {
        return o instanceof DefaultHttpHeaders && this.headers.equals(((DefaultHttpHeaders)o).headers, AsciiString.CASE_SENSITIVE_HASHER);
    }

    public int hashCode() {
        return this.headers.hashCode(AsciiString.CASE_SENSITIVE_HASHER);
    }

    @Override
    public HttpHeaders copy() {
        return new DefaultHttpHeaders(this.headers.copy());
    }

    static ValueConverter<CharSequence> valueConverter() {
        return HeaderValueConverter.INSTANCE;
    }

    static DefaultHeaders.ValueValidator<CharSequence> valueValidator(boolean validate2) {
        return validate2 ? DefaultHttpHeadersFactory.headersFactory().getValueValidator() : DefaultHttpHeadersFactory.headersFactory().withValidation(false).getValueValidator();
    }

    static DefaultHeaders.NameValidator<CharSequence> nameValidator(boolean validate2) {
        return validate2 ? DefaultHttpHeadersFactory.headersFactory().getNameValidator() : DefaultHttpHeadersFactory.headersFactory().withNameValidation(false).getNameValidator();
    }

    private static class HeaderValueConverter
    extends CharSequenceValueConverter {
        static final HeaderValueConverter INSTANCE = new HeaderValueConverter();

        private HeaderValueConverter() {
        }

        @Override
        public CharSequence convertObject(Object value2) {
            if (value2 instanceof CharSequence) {
                return (CharSequence)value2;
            }
            if (value2 instanceof Date) {
                return DateFormatter.format((Date)value2);
            }
            if (value2 instanceof Calendar) {
                return DateFormatter.format(((Calendar)value2).getTime());
            }
            return value2.toString();
        }
    }
}

