/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.handler.codec.DefaultHeaders;
import io.netty.handler.codec.Headers;
import io.netty.handler.codec.ValueConverter;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.util.AsciiString;
import io.netty.util.HashingStrategy;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.StringUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CombinedHttpHeaders
extends DefaultHttpHeaders {
    CombinedHttpHeaders(DefaultHeaders.NameValidator<CharSequence> nameValidator, DefaultHeaders.ValueValidator<CharSequence> valueValidator) {
        super(new CombinedHttpHeadersImpl(AsciiString.CASE_INSENSITIVE_HASHER, CombinedHttpHeaders.valueConverter(), ObjectUtil.checkNotNull(nameValidator, "nameValidator"), ObjectUtil.checkNotNull(valueValidator, "valueValidator")));
    }

    @Override
    public boolean containsValue(CharSequence name2, CharSequence value2, boolean ignoreCase) {
        return super.containsValue(name2, StringUtil.trimOws(value2), ignoreCase);
    }

    private static final class CombinedHttpHeadersImpl
    extends DefaultHeaders<CharSequence, CharSequence, CombinedHttpHeadersImpl> {
        private CsvValueEscaper<Object> objectEscaper;
        private CsvValueEscaper<CharSequence> charSequenceEscaper;

        private CsvValueEscaper<Object> objectEscaper() {
            if (this.objectEscaper == null) {
                this.objectEscaper = new CsvValueEscaper<Object>(){

                    @Override
                    public CharSequence escape(CharSequence name2, Object value2) {
                        CharSequence converted;
                        try {
                            converted = (CharSequence)this.valueConverter().convertObject(value2);
                        }
                        catch (IllegalArgumentException e) {
                            throw new IllegalArgumentException("Failed to convert object value for header '" + name2 + '\'', e);
                        }
                        return StringUtil.escapeCsv(converted, true);
                    }
                };
            }
            return this.objectEscaper;
        }

        private CsvValueEscaper<CharSequence> charSequenceEscaper() {
            if (this.charSequenceEscaper == null) {
                this.charSequenceEscaper = new CsvValueEscaper<CharSequence>(){

                    @Override
                    public CharSequence escape(CharSequence name2, CharSequence value2) {
                        return StringUtil.escapeCsv(value2, true);
                    }
                };
            }
            return this.charSequenceEscaper;
        }

        CombinedHttpHeadersImpl(HashingStrategy<CharSequence> nameHashingStrategy, ValueConverter<CharSequence> valueConverter, DefaultHeaders.NameValidator<CharSequence> nameValidator, DefaultHeaders.ValueValidator<CharSequence> valueValidator) {
            this(nameHashingStrategy, valueConverter, nameValidator, valueValidator, 16);
        }

        CombinedHttpHeadersImpl(HashingStrategy<CharSequence> nameHashingStrategy, ValueConverter<CharSequence> valueConverter, DefaultHeaders.NameValidator<CharSequence> nameValidator, DefaultHeaders.ValueValidator<CharSequence> valueValidator, int sizeHint) {
            super(nameHashingStrategy, valueConverter, nameValidator, sizeHint, valueValidator);
        }

        @Override
        public Iterator<CharSequence> valueIterator(CharSequence name2) {
            Iterator<CharSequence> itr = super.valueIterator(name2);
            if (!itr.hasNext() || CombinedHttpHeadersImpl.cannotBeCombined(name2)) {
                return itr;
            }
            Iterator<CharSequence> unescapedItr = StringUtil.unescapeCsvFields(itr.next()).iterator();
            if (itr.hasNext()) {
                throw new IllegalStateException("CombinedHttpHeaders should only have one value");
            }
            return unescapedItr;
        }

        @Override
        public List<CharSequence> getAll(CharSequence name2) {
            List<CharSequence> values = super.getAll(name2);
            if (values.isEmpty() || CombinedHttpHeadersImpl.cannotBeCombined(name2)) {
                return values;
            }
            if (values.size() != 1) {
                throw new IllegalStateException("CombinedHttpHeaders should only have one value");
            }
            return StringUtil.unescapeCsvFields(values.get(0));
        }

        @Override
        public CombinedHttpHeadersImpl add(Headers<? extends CharSequence, ? extends CharSequence, ?> headers2) {
            if (headers2 == this) {
                throw new IllegalArgumentException("can't add to itself.");
            }
            if (headers2 instanceof CombinedHttpHeadersImpl) {
                if (this.isEmpty()) {
                    this.addImpl(headers2);
                } else {
                    for (Map.Entry<CharSequence, CharSequence> entry : headers2) {
                        this.addEscapedValue(entry.getKey(), entry.getValue());
                    }
                }
            } else {
                for (Map.Entry<CharSequence, CharSequence> entry : headers2) {
                    this.add(entry.getKey(), entry.getValue());
                }
            }
            return this;
        }

        @Override
        public CombinedHttpHeadersImpl set(Headers<? extends CharSequence, ? extends CharSequence, ?> headers2) {
            if (headers2 == this) {
                return this;
            }
            this.clear();
            return this.add((Headers)headers2);
        }

        @Override
        public CombinedHttpHeadersImpl add(CharSequence name2, CharSequence value2) {
            return this.addEscapedValue(name2, this.charSequenceEscaper().escape(name2, value2));
        }

        @Override
        public CombinedHttpHeadersImpl addObject(CharSequence name2, Object value2) {
            return this.addEscapedValue(name2, CombinedHttpHeadersImpl.commaSeparate(name2, this.objectEscaper(), value2));
        }

        @Override
        public CombinedHttpHeadersImpl addObject(CharSequence name2, Iterable<?> values) {
            return this.addEscapedValue(name2, CombinedHttpHeadersImpl.commaSeparate(name2, this.objectEscaper(), values));
        }

        @Override
        public CombinedHttpHeadersImpl setObject(CharSequence name2, Object value2) {
            this.set(name2, CombinedHttpHeadersImpl.commaSeparate(name2, this.objectEscaper(), value2));
            return this;
        }

        @Override
        public CombinedHttpHeadersImpl setObject(CharSequence name2, Iterable<?> values) {
            this.set(name2, CombinedHttpHeadersImpl.commaSeparate(name2, this.objectEscaper(), values));
            return this;
        }

        private static boolean cannotBeCombined(CharSequence name2) {
            return HttpHeaderNames.SET_COOKIE.contentEqualsIgnoreCase(name2);
        }

        private CombinedHttpHeadersImpl addEscapedValue(CharSequence name2, CharSequence escapedValue) {
            CharSequence currentValue = (CharSequence)this.get(name2);
            if (currentValue == null || CombinedHttpHeadersImpl.cannotBeCombined(name2)) {
                super.add(name2, escapedValue);
            } else {
                this.set(name2, CombinedHttpHeadersImpl.commaSeparateEscapedValues(currentValue, escapedValue));
            }
            return this;
        }

        private static <T> CharSequence commaSeparate(CharSequence name2, CsvValueEscaper<T> escaper, T ... values) {
            StringBuilder sb = new StringBuilder(values.length * 10);
            if (values.length > 0) {
                int end = values.length - 1;
                for (int i2 = 0; i2 < end; ++i2) {
                    sb.append(escaper.escape(name2, values[i2])).append(',');
                }
                sb.append(escaper.escape(name2, values[end]));
            }
            return sb;
        }

        private static <T> CharSequence commaSeparate(CharSequence name2, CsvValueEscaper<T> escaper, Iterable<? extends T> values) {
            StringBuilder sb = values instanceof Collection ? new StringBuilder(((Collection)values).size() * 10) : new StringBuilder();
            Iterator<T> iterator2 = values.iterator();
            if (iterator2.hasNext()) {
                T next2 = iterator2.next();
                while (iterator2.hasNext()) {
                    sb.append(escaper.escape(name2, next2)).append(',');
                    next2 = iterator2.next();
                }
                sb.append(escaper.escape(name2, next2));
            }
            return sb;
        }

        private static CharSequence commaSeparateEscapedValues(CharSequence currentValue, CharSequence value2) {
            return new StringBuilder(currentValue.length() + 1 + value2.length()).append(currentValue).append(',').append(value2);
        }

        private static interface CsvValueEscaper<T> {
            public CharSequence escape(CharSequence var1, T var2);
        }
    }
}

