/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.channel.IoEventLoop;
import io.netty.channel.IoEventLoopGroup;
import io.netty.channel.IoExecutionContext;
import io.netty.channel.IoHandle;
import io.netty.channel.IoHandler;
import io.netty.channel.IoRegistration;
import io.netty.channel.SingleThreadEventLoop;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.RejectedExecutionHandler;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.SystemPropertyUtil;
import java.util.Queue;
import java.util.concurrent.Executor;

public class SingleThreadIoEventLoop
extends SingleThreadEventLoop
implements IoEventLoop {
    protected static final int DEFAULT_MAX_TASKS_PER_RUN = Math.max(1, SystemPropertyUtil.getInt("io.netty.eventLoop.maxTaskPerRun", 4096));
    private final int maxTasksPerRun = DEFAULT_MAX_TASKS_PER_RUN;
    private final IoExecutionContext context = new IoExecutionContext(){

        @Override
        public boolean canBlock() {
            assert (SingleThreadIoEventLoop.this.inEventLoop());
            return !SingleThreadIoEventLoop.this.hasTasks() && !SingleThreadIoEventLoop.this.hasScheduledTasks();
        }

        @Override
        public long delayNanos(long currentTimeNanos) {
            assert (SingleThreadIoEventLoop.this.inEventLoop());
            return SingleThreadIoEventLoop.this.delayNanos(currentTimeNanos);
        }
    };
    private final IoHandler ioHandler;
    private int numRegistrations;
    private final FutureListener<Object> decrementRegistrationListener = f -> {
        assert (this.inEventLoop());
        --this.numRegistrations;
    };

    public SingleThreadIoEventLoop(IoEventLoopGroup parent, Executor executor, IoHandler ioHandler) {
        super(parent, executor, false, true);
        this.ioHandler = ObjectUtil.checkNotNull(ioHandler, "ioHandler");
    }

    protected SingleThreadIoEventLoop(IoEventLoopGroup parent, Executor executor, IoHandler ioHandler, Queue<Runnable> taskQueue, Queue<Runnable> tailTaskQueue, RejectedExecutionHandler rejectedExecutionHandler) {
        super(parent, executor, false, true, taskQueue, tailTaskQueue, rejectedExecutionHandler);
        this.ioHandler = ObjectUtil.checkNotNull(ioHandler, "ioHandler");
    }

    @Override
    protected void run() {
        assert (this.inEventLoop());
        do {
            this.runIo();
            if (this.isShuttingDown()) {
                this.ioHandler.prepareToDestroy();
            }
            this.runAllTasks(this.maxTasksPerRun);
        } while (!this.confirmShutdown() && !this.canSuspend());
    }

    @Override
    protected boolean canSuspend(int state2) {
        return super.canSuspend(state2) && this.numRegistrations == 0;
    }

    protected int runIo() {
        assert (this.inEventLoop());
        return this.ioHandler.run(this.context);
    }

    @Override
    public IoEventLoop next() {
        return this;
    }

    @Override
    public final Future<IoRegistration> register(IoHandle handle2) {
        Promise<IoRegistration> promise = this.newPromise();
        if (this.inEventLoop()) {
            this.registerForIo0(handle2, promise);
        } else {
            this.execute(() -> this.registerForIo0(handle2, promise));
        }
        return promise;
    }

    private void registerForIo0(IoHandle handle2, Promise<IoRegistration> promise) {
        IoRegistration registration;
        assert (this.inEventLoop());
        try {
            registration = this.ioHandler.register(this, handle2);
        }
        catch (Exception e) {
            promise.setFailure(e);
            return;
        }
        registration.cancelFuture().addListener(this.decrementRegistrationListener);
        ++this.numRegistrations;
        promise.setSuccess(registration);
    }

    @Override
    protected final void wakeup(boolean inEventLoop) {
        this.ioHandler.wakeup(this);
    }

    @Override
    protected final void cleanup() {
        assert (this.inEventLoop());
        this.ioHandler.destroy();
    }

    @Override
    public boolean isCompatible(Class<? extends IoHandle> handleType) {
        return this.ioHandler.isCompatible(handleType);
    }
}

