/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledHeapByteBuf;
import io.netty.buffer.SwappedByteBuf;
import io.netty.buffer.UnsafeByteBufUtil;
import io.netty.buffer.UnsafeHeapSwappedByteBuf;
import io.netty.util.internal.ObjectPool;
import io.netty.util.internal.PlatformDependent;

final class PooledUnsafeHeapByteBuf
extends PooledHeapByteBuf {
    private static final ObjectPool<PooledUnsafeHeapByteBuf> RECYCLER = ObjectPool.newPool(new ObjectPool.ObjectCreator<PooledUnsafeHeapByteBuf>(){

        @Override
        public PooledUnsafeHeapByteBuf newObject(ObjectPool.Handle<PooledUnsafeHeapByteBuf> handle2) {
            return new PooledUnsafeHeapByteBuf(handle2, 0);
        }
    });

    static PooledUnsafeHeapByteBuf newUnsafeInstance(int maxCapacity) {
        PooledUnsafeHeapByteBuf buf = RECYCLER.get();
        buf.reuse(maxCapacity);
        return buf;
    }

    private PooledUnsafeHeapByteBuf(ObjectPool.Handle<PooledUnsafeHeapByteBuf> recyclerHandle, int maxCapacity) {
        super((ObjectPool.Handle<? extends PooledHeapByteBuf>)recyclerHandle, maxCapacity);
    }

    @Override
    protected byte _getByte(int index) {
        return UnsafeByteBufUtil.getByte((byte[])this.memory, this.idx(index));
    }

    @Override
    protected short _getShort(int index) {
        return UnsafeByteBufUtil.getShort((byte[])this.memory, this.idx(index));
    }

    @Override
    protected short _getShortLE(int index) {
        return UnsafeByteBufUtil.getShortLE((byte[])this.memory, this.idx(index));
    }

    @Override
    protected int _getUnsignedMedium(int index) {
        return UnsafeByteBufUtil.getUnsignedMedium((byte[])this.memory, this.idx(index));
    }

    @Override
    protected int _getInt(int index) {
        return UnsafeByteBufUtil.getInt((byte[])this.memory, this.idx(index));
    }

    @Override
    protected int _getIntLE(int index) {
        return UnsafeByteBufUtil.getIntLE((byte[])this.memory, this.idx(index));
    }

    @Override
    protected long _getLong(int index) {
        return UnsafeByteBufUtil.getLong((byte[])this.memory, this.idx(index));
    }

    @Override
    protected long _getLongLE(int index) {
        return UnsafeByteBufUtil.getLongLE((byte[])this.memory, this.idx(index));
    }

    @Override
    protected void _setByte(int index, int value2) {
        UnsafeByteBufUtil.setByte((byte[])this.memory, this.idx(index), value2);
    }

    @Override
    protected void _setShort(int index, int value2) {
        UnsafeByteBufUtil.setShort((byte[])this.memory, this.idx(index), value2);
    }

    @Override
    protected void _setMedium(int index, int value2) {
        UnsafeByteBufUtil.setMedium((byte[])this.memory, this.idx(index), value2);
    }

    @Override
    protected void _setInt(int index, int value2) {
        UnsafeByteBufUtil.setInt((byte[])this.memory, this.idx(index), value2);
    }

    @Override
    protected void _setLong(int index, long value2) {
        UnsafeByteBufUtil.setLong((byte[])this.memory, this.idx(index), value2);
    }

    @Override
    public ByteBuf setZero(int index, int length) {
        this.checkIndex(index, length);
        UnsafeByteBufUtil.setZero((byte[])this.memory, this.idx(index), length);
        return this;
    }

    @Override
    @Deprecated
    protected SwappedByteBuf newSwappedByteBuf() {
        if (PlatformDependent.isUnaligned()) {
            return new UnsafeHeapSwappedByteBuf(this);
        }
        return super.newSwappedByteBuf();
    }
}

