/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractByteBuf;
import io.netty.buffer.AbstractReferenceCountedByteBuf;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledDuplicatedByteBuf;
import io.netty.buffer.PooledSlicedByteBuf;
import io.netty.util.ByteProcessor;
import io.netty.util.IllegalReferenceCountException;
import io.netty.util.NettyRuntime;
import io.netty.util.Recycler;
import io.netty.util.ReferenceCounted;
import io.netty.util.concurrent.FastThreadLocal;
import io.netty.util.concurrent.FastThreadLocalThread;
import io.netty.util.internal.ObjectPool;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.ReferenceCountUpdater;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.ThreadExecutorMap;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.util.Arrays;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.StampedLock;

final class AdaptivePoolingAllocator {
    private static final int MAX_STRIPES = NettyRuntime.availableProcessors() * 2;
    private static final int CENTRAL_QUEUE_CAPACITY = SystemPropertyUtil.getInt("io.netty.allocator.centralQueueCapacity", NettyRuntime.availableProcessors());
    private static final Object NO_MAGAZINE = Boolean.TRUE;
    private final ChunkAllocator chunkAllocator;
    private final Queue<Chunk> centralQueue;
    private final StampedLock magazineExpandLock;
    private volatile Magazine[] magazines;
    private final FastThreadLocal<Object> threadLocalMagazine;
    private final Set<Magazine> liveCachedMagazines;
    private volatile boolean freed;

    AdaptivePoolingAllocator(ChunkAllocator chunkAllocator, MagazineCaching magazineCaching) {
        ObjectUtil.checkNotNull(chunkAllocator, "chunkAllocator");
        ObjectUtil.checkNotNull(magazineCaching, "magazineCaching");
        this.chunkAllocator = chunkAllocator;
        this.centralQueue = ObjectUtil.checkNotNull(AdaptivePoolingAllocator.createSharedChunkQueue(), "centralQueue");
        this.magazineExpandLock = new StampedLock();
        if (magazineCaching != MagazineCaching.None) {
            assert (magazineCaching == MagazineCaching.EventLoopThreads || magazineCaching == MagazineCaching.FastThreadLocalThreads);
            final boolean cachedMagazinesNonEventLoopThreads = magazineCaching == MagazineCaching.FastThreadLocalThreads;
            final CopyOnWriteArraySet<Magazine> liveMagazines = new CopyOnWriteArraySet<Magazine>();
            this.threadLocalMagazine = new FastThreadLocal<Object>(){

                @Override
                protected Object initialValue() {
                    if (cachedMagazinesNonEventLoopThreads || ThreadExecutorMap.currentExecutor() != null) {
                        Magazine mag = new Magazine(AdaptivePoolingAllocator.this, false);
                        if (FastThreadLocalThread.willCleanupFastThreadLocals(Thread.currentThread())) {
                            liveMagazines.add(mag);
                        }
                        return mag;
                    }
                    return NO_MAGAZINE;
                }

                @Override
                protected void onRemoval(Object value2) throws Exception {
                    if (value2 != NO_MAGAZINE) {
                        liveMagazines.remove(value2);
                    }
                }
            };
            this.liveCachedMagazines = liveMagazines;
        } else {
            this.threadLocalMagazine = null;
            this.liveCachedMagazines = null;
        }
        Magazine[] mags = new Magazine[4];
        for (int i2 = 0; i2 < mags.length; ++i2) {
            mags[i2] = new Magazine(this);
        }
        this.magazines = mags;
    }

    private static Queue<Chunk> createSharedChunkQueue() {
        return PlatformDependent.newFixedMpmcQueue(CENTRAL_QUEUE_CAPACITY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ByteBuf allocate(int size, int maxCapacity) {
        if (size <= 0xA00000) {
            Thread currentThread = Thread.currentThread();
            boolean willCleanupFastThreadLocals = FastThreadLocalThread.willCleanupFastThreadLocals(currentThread);
            AdaptiveByteBuf buf = AdaptiveByteBuf.newInstance(willCleanupFastThreadLocals);
            try {
                if (this.allocate(size, maxCapacity, currentThread, buf)) {
                    AdaptiveByteBuf result2 = buf;
                    buf = null;
                    AdaptiveByteBuf adaptiveByteBuf = result2;
                    return adaptiveByteBuf;
                }
            }
            finally {
                if (buf != null) {
                    buf.release();
                }
            }
        }
        return this.chunkAllocator.allocate(size, maxCapacity);
    }

    private boolean allocate(int size, int maxCapacity, Thread currentThread, AdaptiveByteBuf buf) {
        Magazine[] mags;
        Object mag;
        int sizeBucket = AllocationStatistics.sizeBucket(size);
        FastThreadLocal<Object> threadLocalMagazine = this.threadLocalMagazine;
        if (threadLocalMagazine != null && currentThread instanceof FastThreadLocalThread && (mag = threadLocalMagazine.get()) != NO_MAGAZINE) {
            boolean allocated = ((Magazine)mag).tryAllocate(size, sizeBucket, maxCapacity, buf);
            assert (allocated) : "Allocation of threadLocalMagazine must always succeed";
            return true;
        }
        long threadId = currentThread.getId();
        int expansions = 0;
        do {
            mags = this.magazines;
            int mask = mags.length - 1;
            int index = (int)(threadId & (long)mask);
            int m = Integer.numberOfTrailingZeros(~mask);
            for (int i2 = 0; i2 < m; ++i2) {
                Magazine mag2 = mags[index + i2 & mask];
                if (!mag2.tryAllocate(size, sizeBucket, maxCapacity, buf)) continue;
                return true;
            }
        } while (++expansions <= 3 && this.tryExpandMagazines(mags.length));
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void allocate(int size, int maxCapacity, AdaptiveByteBuf into) {
        Magazine magazine = into.chunk.magazine;
        if (!this.allocate(size, maxCapacity, Thread.currentThread(), into)) {
            AbstractByteBuf innerChunk = this.chunkAllocator.allocate(size, maxCapacity);
            Chunk chunk2 = new Chunk(innerChunk, magazine, false);
            try {
                chunk2.readInitInto(into, size, maxCapacity);
            }
            finally {
                chunk2.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryExpandMagazines(int currentLength) {
        if (currentLength >= MAX_STRIPES) {
            return true;
        }
        long writeLock = this.magazineExpandLock.tryWriteLock();
        if (writeLock != 0L) {
            try {
                Magazine[] mags = this.magazines;
                if (mags.length >= MAX_STRIPES || mags.length > currentLength || this.freed) {
                    boolean bl = true;
                    return bl;
                }
                int preferredChunkSize = mags[0].sharedPrefChunkSize;
                Magazine[] expanded = new Magazine[mags.length * 2];
                int l = expanded.length;
                for (int i2 = 0; i2 < l; ++i2) {
                    Magazine m = new Magazine(this);
                    m.localPrefChunkSize = preferredChunkSize;
                    m.sharedPrefChunkSize = preferredChunkSize;
                    expanded[i2] = m;
                }
                this.magazines = expanded;
                for (Magazine magazine : mags) {
                    magazine.free();
                }
            }
            finally {
                this.magazineExpandLock.unlockWrite(writeLock);
            }
        }
        return true;
    }

    private boolean offerToQueue(Chunk buffer) {
        if (this.freed) {
            return false;
        }
        return this.centralQueue.offer(buffer);
    }

    protected void finalize() throws Throwable {
        try {
            super.finalize();
        }
        finally {
            this.free();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void free() {
        Chunk chunk2;
        this.freed = true;
        long stamp = this.magazineExpandLock.writeLock();
        try {
            Magazine[] mags;
            for (Magazine magazine : mags = this.magazines) {
                magazine.free();
            }
        }
        finally {
            this.magazineExpandLock.unlockWrite(stamp);
        }
        while ((chunk2 = this.centralQueue.poll()) != null) {
            chunk2.release();
        }
    }

    static interface ChunkAllocator {
        public AbstractByteBuf allocate(int var1, int var2);
    }

    static final class AdaptiveByteBuf
    extends AbstractReferenceCountedByteBuf {
        static final ObjectPool<AdaptiveByteBuf> RECYCLER = ObjectPool.newPool(new ObjectPool.ObjectCreator<AdaptiveByteBuf>(){

            @Override
            public AdaptiveByteBuf newObject(ObjectPool.Handle<AdaptiveByteBuf> handle2) {
                return new AdaptiveByteBuf(handle2);
            }
        });
        private final ObjectPool.Handle<AdaptiveByteBuf> handle;
        private int adjustment;
        private AbstractByteBuf rootParent;
        private Chunk chunk;
        private int length;
        private ByteBuffer tmpNioBuf;
        private boolean hasArray;
        private boolean hasMemoryAddress;

        static AdaptiveByteBuf newInstance(boolean useThreadLocal) {
            if (useThreadLocal) {
                AdaptiveByteBuf buf = RECYCLER.get();
                buf.resetRefCnt();
                buf.discardMarks();
                return buf;
            }
            return new AdaptiveByteBuf(null);
        }

        AdaptiveByteBuf(ObjectPool.Handle<AdaptiveByteBuf> recyclerHandle) {
            super(0);
            this.handle = recyclerHandle;
        }

        void init(AbstractByteBuf unwrapped, Chunk wrapped, int readerIndex, int writerIndex, int adjustment, int capacity, int maxCapacity) {
            this.adjustment = adjustment;
            this.chunk = wrapped;
            this.length = capacity;
            this.maxCapacity(maxCapacity);
            this.setIndex0(readerIndex, writerIndex);
            this.hasArray = unwrapped.hasArray();
            this.hasMemoryAddress = unwrapped.hasMemoryAddress();
            this.rootParent = unwrapped;
            this.tmpNioBuf = unwrapped.internalNioBuffer(adjustment, capacity).slice();
        }

        private AbstractByteBuf rootParent() {
            AbstractByteBuf rootParent = this.rootParent;
            if (rootParent != null) {
                return rootParent;
            }
            throw new IllegalReferenceCountException();
        }

        @Override
        public ByteBuf retainedSlice() {
            if (this.handle == null) {
                return super.retainedSlice();
            }
            this.ensureAccessible();
            return PooledSlicedByteBuf.newInstance(this, this, this.readerIndex(), this.readableBytes());
        }

        @Override
        public ByteBuf retainedSlice(int index, int length) {
            if (this.handle == null) {
                return super.retainedSlice(index, length);
            }
            this.ensureAccessible();
            return PooledSlicedByteBuf.newInstance(this, this, index, length);
        }

        @Override
        public ByteBuf retainedDuplicate() {
            if (this.handle == null) {
                return super.retainedDuplicate();
            }
            this.ensureAccessible();
            return PooledDuplicatedByteBuf.newInstance(this, this, this.readerIndex(), this.writerIndex());
        }

        @Override
        public int capacity() {
            return this.length;
        }

        @Override
        public ByteBuf capacity(int newCapacity) {
            if (newCapacity == this.capacity()) {
                this.ensureAccessible();
                return this;
            }
            this.checkNewCapacity(newCapacity);
            if (newCapacity < this.capacity()) {
                this.length = newCapacity;
                this.setIndex0(Math.min(this.readerIndex(), newCapacity), Math.min(this.writerIndex(), newCapacity));
                return this;
            }
            ByteBuffer data2 = this.tmpNioBuf;
            data2.clear();
            this.tmpNioBuf = null;
            Chunk chunk2 = this.chunk;
            Magazine magazine = chunk2.magazine;
            AdaptivePoolingAllocator allocator = magazine.parent;
            int readerIndex = this.readerIndex;
            int writerIndex = this.writerIndex;
            allocator.allocate(newCapacity, this.maxCapacity(), this);
            this.tmpNioBuf.put(data2);
            this.tmpNioBuf.clear();
            chunk2.release();
            this.readerIndex = readerIndex;
            this.writerIndex = writerIndex;
            return this;
        }

        @Override
        public ByteBufAllocator alloc() {
            return this.rootParent().alloc();
        }

        @Override
        public ByteOrder order() {
            return this.rootParent().order();
        }

        @Override
        public ByteBuf unwrap() {
            return null;
        }

        @Override
        public boolean isDirect() {
            return this.rootParent().isDirect();
        }

        @Override
        public int arrayOffset() {
            return this.idx(this.rootParent().arrayOffset());
        }

        @Override
        public boolean hasMemoryAddress() {
            return this.hasMemoryAddress;
        }

        @Override
        public long memoryAddress() {
            this.ensureAccessible();
            return this.rootParent().memoryAddress() + (long)this.adjustment;
        }

        @Override
        public ByteBuffer nioBuffer(int index, int length) {
            this.checkIndex(index, length);
            return this.rootParent().nioBuffer(this.idx(index), length);
        }

        @Override
        public ByteBuffer internalNioBuffer(int index, int length) {
            this.checkIndex(index, length);
            return (ByteBuffer)this.internalNioBuffer().position(index).limit(index + length);
        }

        private ByteBuffer internalNioBuffer() {
            return (ByteBuffer)this.tmpNioBuf.clear();
        }

        @Override
        public ByteBuffer[] nioBuffers(int index, int length) {
            this.checkIndex(index, length);
            return this.rootParent().nioBuffers(this.idx(index), length);
        }

        @Override
        public boolean hasArray() {
            return this.hasArray;
        }

        @Override
        public byte[] array() {
            this.ensureAccessible();
            return this.rootParent().array();
        }

        @Override
        public int nioBufferCount() {
            return this.rootParent().nioBufferCount();
        }

        @Override
        protected byte _getByte(int index) {
            return this.rootParent()._getByte(this.idx(index));
        }

        @Override
        protected short _getShort(int index) {
            return this.rootParent()._getShort(this.idx(index));
        }

        @Override
        protected short _getShortLE(int index) {
            return this.rootParent()._getShortLE(this.idx(index));
        }

        @Override
        protected int _getUnsignedMedium(int index) {
            return this.rootParent()._getUnsignedMedium(this.idx(index));
        }

        @Override
        protected int _getInt(int index) {
            return this.rootParent()._getInt(this.idx(index));
        }

        @Override
        protected int _getIntLE(int index) {
            return this.rootParent()._getIntLE(this.idx(index));
        }

        @Override
        protected long _getLong(int index) {
            return this.rootParent()._getLong(this.idx(index));
        }

        @Override
        protected long _getLongLE(int index) {
            return this.rootParent()._getLongLE(this.idx(index));
        }

        @Override
        public ByteBuf getBytes(int index, ByteBuf dst, int dstIndex, int length) {
            this.checkIndex(index, length);
            this.rootParent().getBytes(this.idx(index), dst, dstIndex, length);
            return this;
        }

        @Override
        public ByteBuf getBytes(int index, byte[] dst, int dstIndex, int length) {
            this.checkIndex(index, length);
            this.rootParent().getBytes(this.idx(index), dst, dstIndex, length);
            return this;
        }

        @Override
        public ByteBuf getBytes(int index, ByteBuffer dst) {
            this.checkIndex(index, dst.remaining());
            this.rootParent().getBytes(this.idx(index), dst);
            return this;
        }

        @Override
        protected void _setByte(int index, int value2) {
            this.rootParent()._setByte(this.idx(index), value2);
        }

        @Override
        protected void _setShort(int index, int value2) {
            this.rootParent()._setShort(this.idx(index), value2);
        }

        @Override
        protected void _setMedium(int index, int value2) {
            this.rootParent()._setMedium(this.idx(index), value2);
        }

        @Override
        protected void _setInt(int index, int value2) {
            this.rootParent()._setInt(this.idx(index), value2);
        }

        @Override
        protected void _setLong(int index, long value2) {
            this.rootParent()._setLong(this.idx(index), value2);
        }

        @Override
        public ByteBuf setBytes(int index, byte[] src, int srcIndex, int length) {
            this.checkIndex(index, length);
            this.rootParent().setBytes(this.idx(index), src, srcIndex, length);
            return this;
        }

        @Override
        public ByteBuf setBytes(int index, ByteBuf src, int srcIndex, int length) {
            this.checkIndex(index, length);
            this.rootParent().setBytes(this.idx(index), src, srcIndex, length);
            return this;
        }

        @Override
        public ByteBuf setBytes(int index, ByteBuffer src) {
            this.checkIndex(index, src.remaining());
            this.rootParent().setBytes(this.idx(index), src);
            return this;
        }

        @Override
        public int getBytes(int index, GatheringByteChannel out, int length) throws IOException {
            return out.write(this.internalNioBuffer(index, length).duplicate());
        }

        @Override
        public int setBytes(int index, ScatteringByteChannel in, int length) throws IOException {
            try {
                return in.read(this.internalNioBuffer(index, length).duplicate());
            }
            catch (ClosedChannelException ignored) {
                return -1;
            }
        }

        @Override
        public int forEachByte(int index, int length, ByteProcessor processor) {
            this.checkIndex(index, length);
            int ret = this.rootParent().forEachByte(this.idx(index), length, processor);
            return this.forEachResult(ret);
        }

        private int forEachResult(int ret) {
            if (ret < this.adjustment) {
                return -1;
            }
            return ret - this.adjustment;
        }

        @Override
        public boolean isContiguous() {
            return this.rootParent().isContiguous();
        }

        private int idx(int index) {
            return index + this.adjustment;
        }

        @Override
        protected void deallocate() {
            if (this.chunk != null) {
                this.chunk.release();
            }
            this.tmpNioBuf = null;
            this.chunk = null;
            this.rootParent = null;
            if (this.handle instanceof Recycler.EnhancedHandle) {
                ((Recycler.EnhancedHandle)this.handle).unguardedRecycle(this);
            } else if (this.handle != null) {
                this.handle.recycle(this);
            }
        }
    }

    private static final class Chunk
    implements ReferenceCounted {
        private final AbstractByteBuf delegate;
        private final Magazine magazine;
        private final int capacity;
        private final boolean pooled;
        private int allocatedBytes;
        private static final long REFCNT_FIELD_OFFSET = ReferenceCountUpdater.getUnsafeOffset(Chunk.class, "refCnt");
        private static final AtomicIntegerFieldUpdater<Chunk> AIF_UPDATER = AtomicIntegerFieldUpdater.newUpdater(Chunk.class, "refCnt");
        private static final ReferenceCountUpdater<Chunk> updater = new ReferenceCountUpdater<Chunk>(){

            @Override
            protected AtomicIntegerFieldUpdater<Chunk> updater() {
                return AIF_UPDATER;
            }

            @Override
            protected long unsafeOffset() {
                return REFCNT_FIELD_OFFSET;
            }
        };
        private volatile int refCnt;

        Chunk() {
            this.delegate = null;
            this.magazine = null;
            this.capacity = 0;
            this.pooled = false;
        }

        Chunk(AbstractByteBuf delegate, Magazine magazine, boolean pooled) {
            this.delegate = delegate;
            this.magazine = magazine;
            this.pooled = pooled;
            this.capacity = delegate.capacity();
            magazine.usedMemory.getAndAdd(this.capacity);
            updater.setInitialValue(this);
        }

        @Override
        public Chunk touch(Object hint) {
            return this;
        }

        @Override
        public int refCnt() {
            return updater.refCnt(this);
        }

        @Override
        public Chunk retain() {
            return updater.retain(this);
        }

        @Override
        public Chunk touch() {
            return this;
        }

        @Override
        public boolean release() {
            if (updater.release(this)) {
                this.deallocate();
                return true;
            }
            return false;
        }

        private void deallocate() {
            Magazine mag = this.magazine;
            AdaptivePoolingAllocator parent = mag.parent;
            int chunkSize = mag.preferredChunkSize();
            int memSize = this.delegate.capacity();
            if (!this.pooled || memSize < chunkSize || memSize > chunkSize + (chunkSize >> 1)) {
                mag.usedMemory.getAndAdd(-this.capacity());
                this.delegate.release();
            } else {
                updater.resetRefCnt(this);
                this.delegate.setIndex(0, 0);
                this.allocatedBytes = 0;
                if (!mag.trySetNextInLine(this) && !parent.offerToQueue(this)) {
                    boolean released = updater.release(this);
                    this.delegate.release();
                    assert (released);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void readInitInto(AdaptiveByteBuf buf, int size, int maxCapacity) {
            int startIndex = this.allocatedBytes;
            this.allocatedBytes = startIndex + size;
            Chunk chunk2 = this;
            chunk2.retain();
            try {
                buf.init(this.delegate, chunk2, 0, 0, startIndex, size, maxCapacity);
                chunk2 = null;
            }
            finally {
                if (chunk2 != null) {
                    chunk2.release();
                }
            }
        }

        public int remainingCapacity() {
            return this.capacity - this.allocatedBytes;
        }

        public int capacity() {
            return this.capacity;
        }
    }

    private static final class Magazine
    extends AllocationStatistics {
        private static final AtomicReferenceFieldUpdater<Magazine, Chunk> NEXT_IN_LINE = AtomicReferenceFieldUpdater.newUpdater(Magazine.class, Chunk.class, "nextInLine");
        private static final Chunk MAGAZINE_FREED = new Chunk();
        private Chunk current;
        private volatile Chunk nextInLine;
        private final AtomicLong usedMemory;
        private final StampedLock allocationLock;

        Magazine(AdaptivePoolingAllocator parent) {
            this(parent, true);
        }

        Magazine(AdaptivePoolingAllocator parent, boolean shareable) {
            super(parent, shareable);
            this.allocationLock = shareable ? new StampedLock() : null;
            this.usedMemory = new AtomicLong();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean tryAllocate(int size, int sizeBucket, int maxCapacity, AdaptiveByteBuf buf) {
            if (this.allocationLock == null) {
                return this.allocate(size, sizeBucket, maxCapacity, buf);
            }
            long writeLock = this.allocationLock.tryWriteLock();
            if (writeLock != 0L) {
                try {
                    boolean bl = this.allocate(size, sizeBucket, maxCapacity, buf);
                    return bl;
                }
                finally {
                    this.allocationLock.unlockWrite(writeLock);
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean allocate(int size, int sizeBucket, int maxCapacity, AdaptiveByteBuf buf) {
            this.recordAllocationSize(sizeBucket);
            Chunk curr = this.current;
            if (curr != null) {
                if (curr.remainingCapacity() > size) {
                    curr.readInitInto(buf, size, maxCapacity);
                    return true;
                }
                this.current = null;
                if (curr.remainingCapacity() == size) {
                    try {
                        curr.readInitInto(buf, size, maxCapacity);
                        boolean bl = true;
                        return bl;
                    }
                    finally {
                        curr.release();
                    }
                }
            }
            Chunk last = curr;
            assert (this.current == null);
            if (this.nextInLine != null) {
                curr = NEXT_IN_LINE.getAndSet(this, null);
                if (curr == MAGAZINE_FREED) {
                    this.restoreMagazineFreed();
                    return false;
                }
            } else {
                curr = (Chunk)this.parent.centralQueue.poll();
                if (curr == null) {
                    curr = this.newChunkAllocation(size);
                }
            }
            this.current = curr;
            assert (this.current != null);
            if (last != null) {
                if (last.remainingCapacity() < 4096) {
                    last.release();
                } else {
                    this.transferChunk(last);
                }
            }
            if (curr.remainingCapacity() > size) {
                curr.readInitInto(buf, size, maxCapacity);
            } else {
                if (curr.remainingCapacity() == size) {
                    try {
                        curr.readInitInto(buf, size, maxCapacity);
                    }
                    finally {
                        curr.release();
                        this.current = null;
                    }
                }
                Chunk newChunk = this.newChunkAllocation(size);
                try {
                    newChunk.readInitInto(buf, size, maxCapacity);
                    if (curr.remainingCapacity() < 4096) {
                        curr.release();
                        this.current = newChunk;
                    } else {
                        this.transferChunk(newChunk);
                    }
                    newChunk = null;
                }
                finally {
                    if (newChunk != null) {
                        assert (this.current == null);
                        newChunk.release();
                    }
                }
            }
            return true;
        }

        private void restoreMagazineFreed() {
            Chunk next2 = NEXT_IN_LINE.getAndSet(this, MAGAZINE_FREED);
            if (next2 != null && next2 != MAGAZINE_FREED) {
                next2.release();
            }
        }

        private void transferChunk(Chunk current) {
            if (NEXT_IN_LINE.compareAndSet(this, null, current) || this.parent.offerToQueue(current)) {
                return;
            }
            Chunk nextChunk = NEXT_IN_LINE.get(this);
            if (nextChunk != null && current.remainingCapacity() > nextChunk.remainingCapacity() && NEXT_IN_LINE.compareAndSet(this, nextChunk, current)) {
                if (nextChunk != MAGAZINE_FREED) {
                    nextChunk.release();
                }
                return;
            }
            current.release();
        }

        private Chunk newChunkAllocation(int promptingSize) {
            int size = Math.max(promptingSize * 10, this.preferredChunkSize());
            ChunkAllocator chunkAllocator = this.parent.chunkAllocator;
            return new Chunk(chunkAllocator.allocate(size, size), this, true);
        }

        boolean trySetNextInLine(Chunk chunk2) {
            return NEXT_IN_LINE.compareAndSet(this, null, chunk2);
        }

        void free() {
            this.restoreMagazineFreed();
            long stamp = this.allocationLock.writeLock();
            try {
                if (this.current != null) {
                    this.current.release();
                    this.current = null;
                }
            }
            finally {
                this.allocationLock.unlockWrite(stamp);
            }
        }
    }

    private static class AllocationStatistics {
        protected final AdaptivePoolingAllocator parent;
        private final boolean shareable;
        private final short[][] histos = new short[][]{new short[8], new short[8], new short[8], new short[8]};
        private short[] histo = this.histos[0];
        private final int[] sums = new int[8];
        private int histoIndex;
        private int datumCount;
        private int datumTarget = 9;
        protected volatile int sharedPrefChunkSize = 131072;
        protected volatile int localPrefChunkSize = 131072;

        private AllocationStatistics(AdaptivePoolingAllocator parent, boolean shareable) {
            this.parent = parent;
            this.shareable = shareable;
        }

        protected void recordAllocationSize(int bucket) {
            int n = bucket;
            this.histo[n] = (short)(this.histo[n] + 1);
            if (this.datumCount++ == this.datumTarget) {
                this.rotateHistograms();
            }
        }

        static int sizeBucket(int size) {
            if (size == 0) {
                return 0;
            }
            int normalizedSize = size - 1 >> 13 & 0x9FFFFF;
            return Math.min(32 - Integer.numberOfLeadingZeros(normalizedSize), 7);
        }

        private void rotateHistograms() {
            int prefChunkSize;
            int sizeBucket;
            short[][] hs = this.histos;
            for (int i2 = 0; i2 < 8; ++i2) {
                this.sums[i2] = (hs[0][i2] & 0xFFFF) + (hs[1][i2] & 0xFFFF) + (hs[2][i2] & 0xFFFF) + (hs[3][i2] & 0xFFFF);
            }
            int sum = 0;
            for (int count : this.sums) {
                sum += count;
            }
            int targetPercentile = (int)((double)sum * 0.99);
            for (sizeBucket = 0; sizeBucket < this.sums.length && this.sums[sizeBucket] <= targetPercentile; targetPercentile -= this.sums[sizeBucket], ++sizeBucket) {
            }
            int percentileSize = 1 << sizeBucket + 13;
            this.localPrefChunkSize = prefChunkSize = Math.max(percentileSize * 10, 131072);
            if (this.shareable) {
                for (Magazine mag : this.parent.magazines) {
                    prefChunkSize = Math.max(prefChunkSize, mag.localPrefChunkSize);
                }
            }
            if (this.sharedPrefChunkSize != prefChunkSize) {
                this.datumTarget = Math.max(this.datumTarget >> 1, 1024);
                this.sharedPrefChunkSize = prefChunkSize;
            } else {
                this.datumTarget = Math.min(this.datumTarget << 1, 65534);
            }
            this.histoIndex = this.histoIndex + 1 & 3;
            this.histo = this.histos[this.histoIndex];
            this.datumCount = 0;
            Arrays.fill(this.histo, (short)0);
        }

        protected int preferredChunkSize() {
            return this.sharedPrefChunkSize;
        }
    }

    static final class MagazineCaching
    extends Enum<MagazineCaching> {
        public static final /* enum */ MagazineCaching EventLoopThreads = new MagazineCaching();
        public static final /* enum */ MagazineCaching FastThreadLocalThreads = new MagazineCaching();
        public static final /* enum */ MagazineCaching None = new MagazineCaching();
        private static final /* synthetic */ MagazineCaching[] $VALUES;

        static {
            $VALUES = new MagazineCaching[]{EventLoopThreads, FastThreadLocalThreads, None};
        }
    }
}

