/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.routing;

import io.ktor.http.Headers;
import io.ktor.http.Parameters;
import io.ktor.http.RequestConnectionPoint;
import io.ktor.server.request.ApplicationRequest;
import io.ktor.server.request.PipelineRequest;
import io.ktor.server.request.RequestCookies;
import io.ktor.server.routing.RoutingCall;
import io.ktor.utils.io.ByteReadChannel;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

public final class RoutingRequest
implements ApplicationRequest {
    @NotNull
    private final Parameters pathVariables;
    @NotNull
    private final PipelineRequest request;
    @NotNull
    private final RoutingCall call;
    @NotNull
    private final Parameters queryParameters;
    @NotNull
    private final Parameters rawQueryParameters;
    @NotNull
    private final Headers headers;
    @NotNull
    private final RequestConnectionPoint local;
    @NotNull
    private final RequestCookies cookies;

    public RoutingRequest(@NotNull Parameters pathVariables, @NotNull PipelineRequest request2, @NotNull RoutingCall call2) {
        Intrinsics.checkNotNullParameter((Object)pathVariables, (String)"pathVariables");
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
        this.pathVariables = pathVariables;
        this.request = request2;
        this.call = call2;
        this.queryParameters = this.request.getQueryParameters();
        this.rawQueryParameters = this.request.getRawQueryParameters();
        this.headers = this.request.getHeaders();
        this.local = this.request.getLocal();
        this.cookies = this.request.getCookies();
    }

    @Override
    @NotNull
    public RoutingCall getCall() {
        return this.call;
    }

    @Override
    @NotNull
    public Parameters getQueryParameters() {
        return this.queryParameters;
    }

    @Override
    @NotNull
    public Parameters getRawQueryParameters() {
        return this.rawQueryParameters;
    }

    @Override
    @NotNull
    public Headers getHeaders() {
        return this.headers;
    }

    @Override
    @NotNull
    public RequestConnectionPoint getLocal() {
        return this.local;
    }

    @Override
    @NotNull
    public RequestCookies getCookies() {
        return this.cookies;
    }

    @Override
    @NotNull
    public ByteReadChannel receiveChannel() {
        return this.request.receiveChannel();
    }
}

