/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.routing;

import io.ktor.http.HttpMethod;
import io.ktor.server.routing.HttpMethodRouteSelector;
import io.ktor.server.routing.PathSegmentSelectorBuilder;
import io.ktor.server.routing.Route;
import io.ktor.server.routing.RouteSelector;
import io.ktor.server.routing.RoutingContext;
import io.ktor.server.routing.RoutingPath;
import io.ktor.server.routing.RoutingPathSegment;
import io.ktor.server.routing.RoutingPathSegmentKind;
import io.ktor.server.routing.TrailingSlashRouteSelector;
import io.ktor.utils.io.KtorDsl;
import java.util.Collection;
import java.util.List;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

public final class RoutingBuilderKt {
    @KtorDsl
    @NotNull
    public static final Route route(@NotNull Route $this$route, @NotNull String path2, @NotNull HttpMethod method, @NotNull Function1<? super Route, Unit> build2) {
        Intrinsics.checkNotNullParameter((Object)$this$route, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter(build2, (String)"build");
        HttpMethodRouteSelector selector = new HttpMethodRouteSelector(method);
        Route route = RoutingBuilderKt.createRouteFromPath($this$route, path2).createChild(selector);
        build2.invoke((Object)route);
        return route;
    }

    @KtorDsl
    @NotNull
    public static final Route get(@NotNull Route $this$get, @NotNull String path2, @NotNull Function2<? super RoutingContext, ? super Continuation<? super Unit>, ? extends Object> body) {
        Intrinsics.checkNotNullParameter((Object)$this$get, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Intrinsics.checkNotNullParameter(body, (String)"body");
        return RoutingBuilderKt.route($this$get, path2, HttpMethod.Companion.getGet(), (Function1<? super Route, Unit>)((Function1)arg_0 -> RoutingBuilderKt.get$lambda$0(body, arg_0)));
    }

    @KtorDsl
    @NotNull
    public static final Route post(@NotNull Route $this$post, @NotNull String path2, @NotNull Function2<? super RoutingContext, ? super Continuation<? super Unit>, ? extends Object> body) {
        Intrinsics.checkNotNullParameter((Object)$this$post, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Intrinsics.checkNotNullParameter(body, (String)"body");
        return RoutingBuilderKt.route($this$post, path2, HttpMethod.Companion.getPost(), (Function1<? super Route, Unit>)((Function1)arg_0 -> RoutingBuilderKt.post$lambda$2(body, arg_0)));
    }

    @NotNull
    public static final Route createRouteFromPath(@NotNull Route $this$createRouteFromPath, @NotNull String path2) {
        Intrinsics.checkNotNullParameter((Object)$this$createRouteFromPath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        List<RoutingPathSegment> parts = RoutingPath.Companion.parse(path2).getParts();
        Route current = $this$createRouteFromPath;
        int n = ((Collection)parts).size();
        for (int index = 0; index < n; ++index) {
            RouteSelector routeSelector;
            RoutingPathSegment routingPathSegment = parts.get(index);
            String value2 = routingPathSegment.component1();
            RoutingPathSegmentKind kind = routingPathSegment.component2();
            switch (WhenMappings.$EnumSwitchMapping$0[kind.ordinal()]) {
                case 1: {
                    routeSelector = PathSegmentSelectorBuilder.INSTANCE.parseParameter(value2);
                    break;
                }
                case 2: {
                    routeSelector = PathSegmentSelectorBuilder.INSTANCE.parseConstant(value2);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            RouteSelector selector = routeSelector;
            current = current.createChild(selector);
        }
        if (StringsKt.endsWith$default((String)path2, (String)"/", (boolean)false, (int)2, null)) {
            current = current.createChild(TrailingSlashRouteSelector.INSTANCE);
        }
        return current;
    }

    private static final Unit get$lambda$0(Function2 $body, Route $this$route) {
        Intrinsics.checkNotNullParameter((Object)$this$route, (String)"$this$route");
        $this$route.handle((Function2<? super RoutingContext, ? super Continuation<? super Unit>, ? extends Object>)$body);
        return Unit.INSTANCE;
    }

    private static final Unit post$lambda$2(Function2 $body, Route $this$route) {
        Intrinsics.checkNotNullParameter((Object)$this$route, (String)"$this$route");
        $this$route.handle((Function2<? super RoutingContext, ? super Continuation<? super Unit>, ? extends Object>)$body);
        return Unit.INSTANCE;
    }

    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RoutingPathSegmentKind.values().length];
            try {
                nArray[RoutingPathSegmentKind.Parameter.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RoutingPathSegmentKind.Constant.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

