/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.engine.internal;

import io.ktor.server.application.Application;
import io.ktor.server.application.ApplicationEnvironment;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.nio.file.WatchEvent;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KCallable;
import kotlin.reflect.KClass;
import kotlin.reflect.KFunction;
import kotlin.reflect.KParameter;
import kotlin.reflect.KType;
import kotlin.reflect.full.KCallables;
import kotlin.reflect.jvm.ReflectJvmMapping;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nAutoReloadUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AutoReloadUtils.kt\nio/ktor/server/engine/internal/AutoReloadUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,79:1\n1#2:80\n1740#3,3:81\n1788#3,4:84\n*S KotlinDebug\n*F\n+ 1 AutoReloadUtils.kt\nio/ktor/server/engine/internal/AutoReloadUtilsKt\n*L\n59#1:81,3\n36#1:84,4\n*E\n"})
public final class AutoReloadUtilsKt {
    @NotNull
    private static final ThreadLocal<List<String>> currentStartupModules = new ThreadLocal();
    @NotNull
    private static final Class<ApplicationEnvironment> ApplicationEnvironmentClassInstance = ApplicationEnvironment.class;
    @NotNull
    private static final Class<Application> ApplicationClassInstance = Application.class;

    @NotNull
    public static final ThreadLocal<List<String>> getCurrentStartupModules() {
        return currentStartupModules;
    }

    @NotNull
    public static final Class<Application> getApplicationClassInstance() {
        return ApplicationClassInstance;
    }

    public static final boolean isApplicationEnvironment(@NotNull KParameter parameter) {
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        return AutoReloadUtilsKt.isParameterOfType(parameter, ApplicationEnvironmentClassInstance);
    }

    public static final boolean isApplication(@NotNull KParameter parameter) {
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        return AutoReloadUtilsKt.isParameterOfType(parameter, ApplicationClassInstance);
    }

    @Nullable
    public static final Class<?> loadClassOrNull(@NotNull ClassLoader $this$loadClassOrNull, @NotNull String name2) {
        Class<?> clazz;
        Intrinsics.checkNotNullParameter((Object)$this$loadClassOrNull, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        try {
            clazz = $this$loadClassOrNull.loadClass(name2);
        }
        catch (ClassNotFoundException cause) {
            clazz = null;
        }
        return clazz;
    }

    public static final boolean isParameterOfType(@NotNull KParameter parameter, @NotNull Class<?> type2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        Intrinsics.checkNotNullParameter(type2, (String)"type");
        Type type3 = ReflectJvmMapping.getJavaType((KType)parameter.getType());
        Class clazz = type3 instanceof Class ? (Class)type3 : null;
        if (clazz != null) {
            Class it = clazz;
            boolean bl2 = false;
            bl = type2.isAssignableFrom(it);
        } else {
            bl = false;
        }
        return bl;
    }

    @Nullable
    public static final <R> KFunction<R> bestFunction(@NotNull List<? extends KFunction<? extends R>> $this$bestFunction) {
        Intrinsics.checkNotNullParameter($this$bestFunction, (String)"<this>");
        Function1[] function1Array = new Function1[]{AutoReloadUtilsKt::bestFunction$lambda$1, AutoReloadUtilsKt::bestFunction$lambda$3, AutoReloadUtilsKt::bestFunction$lambda$4};
        return (KFunction)CollectionsKt.lastOrNull((List)CollectionsKt.sortedWith((Iterable)$this$bestFunction, (Comparator)ComparisonsKt.compareBy((Function1[])function1Array)));
    }

    public static final boolean isApplicableFunction(@NotNull KFunction<?> $this$isApplicableFunction) {
        boolean bl;
        block10: {
            Object it;
            Intrinsics.checkNotNullParameter($this$isApplicableFunction, (String)"<this>");
            if ($this$isApplicableFunction.isOperator() || $this$isApplicableFunction.isInfix() || $this$isApplicableFunction.isInline() || $this$isApplicableFunction.isAbstract()) {
                return false;
            }
            if ($this$isApplicableFunction.isSuspend()) {
                return false;
            }
            KParameter kParameter = KCallables.getExtensionReceiverParameter((KCallable)((KCallable)$this$isApplicableFunction));
            if (kParameter != null) {
                it = kParameter;
                boolean bl2 = false;
                if (!AutoReloadUtilsKt.isApplication((KParameter)it) && !AutoReloadUtilsKt.isApplicationEnvironment((KParameter)it)) {
                    return false;
                }
            }
            Method method = ReflectJvmMapping.getJavaMethod($this$isApplicableFunction);
            if (method != null) {
                it = method;
                boolean bl3 = false;
                if (((Method)it).isSynthetic()) {
                    return false;
                }
                if (Modifier.isStatic(((Method)it).getModifiers()) && $this$isApplicableFunction.getParameters().isEmpty()) {
                    return false;
                }
            }
            Iterable $this$all$iv = $this$isApplicableFunction.getParameters();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    KParameter it2 = (KParameter)element$iv;
                    boolean bl4 = false;
                    if (AutoReloadUtilsKt.isApplication(it2) || AutoReloadUtilsKt.isApplicationEnvironment(it2) || it2.getKind() == KParameter.Kind.INSTANCE || it2.isOptional()) continue;
                    bl = false;
                    break block10;
                }
                bl = true;
            }
        }
        return bl;
    }

    @Nullable
    public static final KClass<?> takeIfNotFacade(@NotNull Class<?> $this$takeIfNotFacade) {
        Object object;
        Intrinsics.checkNotNullParameter($this$takeIfNotFacade, (String)"<this>");
        Metadata metadata = $this$takeIfNotFacade.getAnnotation(Metadata.class);
        if (metadata != null) {
            Metadata metadata2;
            Metadata it = metadata2 = metadata;
            boolean bl = false;
            object = it.k() == 1 ? metadata2 : null;
        } else {
            object = null;
        }
        return object != null ? JvmClassMappingKt.getKotlinClass($this$takeIfNotFacade) : null;
    }

    @Nullable
    public static final WatchEvent.Modifier get_com_sun_nio_file_SensitivityWatchEventModifier_HIGH() {
        WatchEvent.Modifier modifier2;
        if (System.getenv("ANDROID_DATA") != null) {
            return null;
        }
        try {
            Class<?> modifierClass = Class.forName("com.sun.nio.file.SensitivityWatchEventModifier");
            Field field = modifierClass.getField("HIGH");
            Object object = field.get(modifierClass);
            modifier2 = object instanceof WatchEvent.Modifier ? (WatchEvent.Modifier)object : null;
        }
        catch (Throwable cause) {
            modifier2 = null;
        }
        return modifier2;
    }

    private static final Comparable bestFunction$lambda$1(KFunction it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Boolean.valueOf(!((Collection)it.getParameters()).isEmpty() && AutoReloadUtilsKt.isApplication((KParameter)it.getParameters().get(0)));
    }

    /*
     * WARNING - void declaration
     */
    private static final Comparable bestFunction$lambda$3(KFunction it) {
        int n;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Iterable $this$count$iv = it.getParameters();
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            void var3_3;
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                KParameter it2 = (KParameter)element$iv;
                boolean bl = false;
                if (!(!it2.isOptional()) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = var3_3;
        }
        return Integer.valueOf(n);
    }

    private static final Comparable bestFunction$lambda$4(KFunction it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Integer.valueOf(it.getParameters().size());
    }
}

