/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.engine;

import java.io.IOException;
import java.util.concurrent.CancellationException;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineExceptionHandler;
import kotlinx.coroutines.CoroutineName;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public final class DefaultUncaughtExceptionHandler
implements CoroutineExceptionHandler {
    @NotNull
    private final Function0<Logger> logger;

    public DefaultUncaughtExceptionHandler(@NotNull Function0<? extends Logger> logger) {
        Intrinsics.checkNotNullParameter(logger, (String)"logger");
        this.logger = logger;
    }

    public DefaultUncaughtExceptionHandler(@NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this((Function0<? extends Logger>)((Function0)() -> DefaultUncaughtExceptionHandler._init_$lambda$0(logger)));
    }

    @NotNull
    public CoroutineContext.Key<?> getKey() {
        return (CoroutineContext.Key)CoroutineExceptionHandler.Key;
    }

    public void handleException(@NotNull CoroutineContext context2, @NotNull Throwable exception) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        if (exception instanceof CancellationException) {
            return;
        }
        if (exception instanceof IOException) {
            return;
        }
        Object object = (CoroutineName)context2.get((CoroutineContext.Key)CoroutineName.Key);
        if (object == null) {
            object = context2.toString();
        }
        CoroutineName coroutineName = object;
        ((Logger)this.logger.invoke()).error("Unhandled exception caught for " + coroutineName, exception);
    }

    @Nullable
    public <E extends CoroutineContext.Element> E get(@NotNull CoroutineContext.Key<E> key2) {
        return (E)CoroutineExceptionHandler.DefaultImpls.get((CoroutineExceptionHandler)this, key2);
    }

    public <R> R fold(R initial, @NotNull Function2<? super R, ? super CoroutineContext.Element, ? extends R> operation) {
        return (R)CoroutineExceptionHandler.DefaultImpls.fold((CoroutineExceptionHandler)this, initial, operation);
    }

    @NotNull
    public CoroutineContext minusKey(@NotNull CoroutineContext.Key<?> key2) {
        return CoroutineExceptionHandler.DefaultImpls.minusKey((CoroutineExceptionHandler)this, key2);
    }

    @NotNull
    public CoroutineContext plus(@NotNull CoroutineContext context2) {
        return CoroutineExceptionHandler.DefaultImpls.plus((CoroutineExceptionHandler)this, (CoroutineContext)context2);
    }

    private static final Logger _init_$lambda$0(Logger $logger) {
        return $logger;
    }
}

