/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.engine;

import io.ktor.events.Events;
import io.ktor.server.application.Application;
import io.ktor.server.application.ApplicationEnvironment;
import io.ktor.server.application.DefaultApplicationEventsKt;
import io.ktor.server.engine.ApplicationEngine;
import io.ktor.server.engine.BaseApplicationEngineKt;
import io.ktor.server.engine.BaseApplicationResponse;
import io.ktor.server.engine.DefaultEnginePipelineKt;
import io.ktor.server.engine.DefaultTransformKt;
import io.ktor.server.engine.EngineConnectorConfig;
import io.ktor.server.engine.EnginePipeline;
import io.ktor.server.engine.StartupInfo;
import io.ktor.util.date.DateJvmKt;
import java.util.List;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseApplicationEngine
implements ApplicationEngine {
    @NotNull
    private final ApplicationEnvironment environment;
    @NotNull
    private final Events monitor;
    @NotNull
    private final EnginePipeline pipeline;
    @NotNull
    private final CompletableDeferred<List<EngineConnectorConfig>> resolvedConnectorsDeferred;

    public BaseApplicationEngine(@NotNull ApplicationEnvironment environment, @NotNull Events monitor2, boolean developmentMode, @NotNull EnginePipeline pipeline) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)monitor2, (String)"monitor");
        Intrinsics.checkNotNullParameter((Object)((Object)pipeline), (String)"pipeline");
        this.environment = environment;
        this.monitor = monitor2;
        this.pipeline = pipeline;
        this.resolvedConnectorsDeferred = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
        ApplicationEnvironment environment2 = this.environment;
        StartupInfo info = new StartupInfo();
        EnginePipeline pipeline2 = this.pipeline;
        BaseApplicationResponse.Companion.setupSendPipeline(pipeline2.getSendPipeline());
        BaseApplicationResponse.Companion.setupFallbackResponse$ktor_server_core(pipeline2, environment2.getLog());
        this.monitor.subscribe(DefaultApplicationEventsKt.getApplicationStarting(), arg_0 -> BaseApplicationEngine._init_$lambda$0(info, pipeline2, arg_0));
        this.monitor.subscribe(DefaultApplicationEventsKt.getApplicationStarted(), arg_0 -> BaseApplicationEngine._init_$lambda$1(info, environment2, arg_0));
    }

    public /* synthetic */ BaseApplicationEngine(ApplicationEnvironment applicationEnvironment, Events events, boolean bl, EnginePipeline enginePipeline, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            enginePipeline = DefaultEnginePipelineKt.defaultEnginePipeline(applicationEnvironment.getConfig(), bl);
        }
        this(applicationEnvironment, events, bl, enginePipeline);
    }

    @NotNull
    public final ApplicationEnvironment getEnvironment() {
        return this.environment;
    }

    @NotNull
    protected final Events getMonitor() {
        return this.monitor;
    }

    @NotNull
    public final EnginePipeline getPipeline() {
        return this.pipeline;
    }

    @NotNull
    protected final CompletableDeferred<List<EngineConnectorConfig>> getResolvedConnectorsDeferred() {
        return this.resolvedConnectorsDeferred;
    }

    @Override
    @Nullable
    public Object resolvedConnectors(@NotNull Continuation<? super List<? extends EngineConnectorConfig>> $completion) {
        return this.resolvedConnectorsDeferred.await($completion);
    }

    @Nullable
    public Object startSuspend(boolean wait, @NotNull Continuation<? super ApplicationEngine> $completion) {
        return ApplicationEngine.DefaultImpls.startSuspend(this, wait, $completion);
    }

    @Nullable
    public Object stopSuspend(long gracePeriodMillis, long timeoutMillis, @NotNull Continuation<? super Unit> $completion) {
        return ApplicationEngine.DefaultImpls.stopSuspend(this, gracePeriodMillis, timeoutMillis, $completion);
    }

    private static final Unit _init_$lambda$0(StartupInfo $info, EnginePipeline $pipeline, Application it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        if (!$info.isFirstLoading()) {
            $info.setInitializedStartAt(DateJvmKt.getTimeMillis());
        }
        it.getReceivePipeline().merge($pipeline.getReceivePipeline());
        it.getSendPipeline().merge($pipeline.getSendPipeline());
        DefaultTransformKt.installDefaultTransformations(it.getReceivePipeline());
        DefaultTransformKt.installDefaultTransformations(it.getSendPipeline());
        BaseApplicationEngineKt.access$installDefaultInterceptors(it);
        BaseApplicationEngineKt.access$installDefaultTransformationChecker(it);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(StartupInfo $info, ApplicationEnvironment $environment, Application it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        long finishedAt = DateJvmKt.getTimeMillis();
        double elapsedTimeInSeconds = (double)(finishedAt - $info.getInitializedStartAt()) / 1000.0;
        if ($info.isFirstLoading()) {
            $environment.getLog().info("Application started in " + elapsedTimeInSeconds + " seconds.");
            $info.setFirstLoading(false);
        } else {
            $environment.getLog().info("Application auto-reloaded in " + elapsedTimeInSeconds + " seconds.");
        }
        return Unit.INSTANCE;
    }

    public static class Configuration
    extends ApplicationEngine.Configuration {
    }
}

