/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.engine;

import io.ktor.http.Parameters;
import io.ktor.server.application.Application;
import io.ktor.server.application.PipelineCall;
import io.ktor.server.engine.BaseApplicationRequest;
import io.ktor.server.engine.BaseApplicationResponse;
import io.ktor.util.Attributes;
import io.ktor.util.AttributesJvmKt;
import io.ktor.util.reflect.TypeInfo;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseApplicationCall
implements PipelineCall {
    @NotNull
    private final Application application;
    @NotNull
    private final Attributes attributes;

    public BaseApplicationCall(@NotNull Application application) {
        Intrinsics.checkNotNullParameter((Object)((Object)application), (String)"application");
        this.application = application;
        this.attributes = AttributesJvmKt.Attributes$default((boolean)false, (int)1, null);
    }

    @Override
    @NotNull
    public final Application getApplication() {
        return this.application;
    }

    @Override
    @NotNull
    public final Attributes getAttributes() {
        return this.attributes;
    }

    @Override
    @NotNull
    public Parameters getParameters() {
        return this.getRequest().getQueryParameters();
    }

    @Override
    @NotNull
    public abstract BaseApplicationRequest getRequest();

    @Override
    @NotNull
    public abstract BaseApplicationResponse getResponse();

    protected final void putResponseAttribute(@NotNull BaseApplicationResponse response2) {
        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
        this.attributes.put(BaseApplicationResponse.Companion.getEngineResponseAttributeKey(), (Object)response2);
    }

    public static /* synthetic */ void putResponseAttribute$default(BaseApplicationCall baseApplicationCall, BaseApplicationResponse baseApplicationResponse, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: putResponseAttribute");
        }
        if ((n & 1) != 0) {
            baseApplicationResponse = baseApplicationCall.getResponse();
        }
        baseApplicationCall.putResponseAttribute(baseApplicationResponse);
    }

    @Override
    @Nullable
    public <T> Object receiveNullable(@NotNull TypeInfo typeInfo, @NotNull Continuation<? super T> $completion) {
        return PipelineCall.DefaultImpls.receiveNullable(this, typeInfo, $completion);
    }

    @Override
    @Nullable
    public Object respond(@Nullable Object message2, @Nullable TypeInfo typeInfo, @NotNull Continuation<? super Unit> $completion) {
        return PipelineCall.DefaultImpls.respond(this, message2, typeInfo, $completion);
    }
}

