/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.cio;

import io.ktor.http.Headers;
import io.ktor.http.HttpHeaders;
import io.ktor.http.HttpMethod;
import io.ktor.http.Parameters;
import io.ktor.http.QueryKt;
import io.ktor.http.RequestConnectionPoint;
import io.ktor.http.cio.CIOHeaders;
import io.ktor.http.cio.Request;
import io.ktor.server.application.PipelineCall;
import io.ktor.server.cio.CIOApplicationRequestKt;
import io.ktor.server.cio.CIOConnectionPoint;
import io.ktor.server.engine.BaseApplicationRequest;
import io.ktor.server.request.PipelineRequestKt;
import io.ktor.server.request.RequestCookies;
import io.ktor.utils.io.ByteReadChannel;
import java.net.SocketAddress;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nCIOApplicationRequest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CIOApplicationRequest.kt\nio/ktor/server/cio/CIOApplicationRequest\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,125:1\n1#2:126\n*E\n"})
public final class CIOApplicationRequest
extends BaseApplicationRequest {
    @NotNull
    private final ByteReadChannel input;
    @NotNull
    private final Request request;
    @NotNull
    private final Lazy cookies$delegate;
    @NotNull
    private final ByteReadChannel engineReceiveChannel;
    @NotNull
    private Headers engineHeaders;
    @NotNull
    private final Lazy queryParameters$delegate;
    @NotNull
    private final Lazy rawQueryParameters$delegate;
    @NotNull
    private final RequestConnectionPoint local;

    public CIOApplicationRequest(@NotNull PipelineCall call2, @Nullable SocketAddress remoteAddress2, @Nullable SocketAddress localAddress, @NotNull ByteReadChannel input, @NotNull Request request2) {
        Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        super(call2);
        this.input = input;
        this.request = request2;
        this.cookies$delegate = LazyKt.lazy(() -> CIOApplicationRequest.cookies_delegate$lambda$0(this));
        this.engineReceiveChannel = this.input;
        this.engineHeaders = (Headers)new CIOHeaders(this.request.getHeaders());
        this.queryParameters$delegate = LazyKt.lazy(() -> CIOApplicationRequest.queryParameters_delegate$lambda$1(this));
        this.rawQueryParameters$delegate = LazyKt.lazy(() -> CIOApplicationRequest.rawQueryParameters_delegate$lambda$3(this));
        CharSequence charSequence = this.request.getHeaders().get(HttpHeaders.INSTANCE.getHost());
        this.local = new CIOConnectionPoint(remoteAddress2, localAddress, ((Object)this.request.getVersion()).toString(), ((Object)this.request.getUri()).toString(), charSequence != null ? ((Object)charSequence).toString() : null, HttpMethod.Companion.parse(this.request.getMethod().getValue()));
    }

    @Override
    @NotNull
    public RequestCookies getCookies() {
        Lazy lazy = this.cookies$delegate;
        return (RequestCookies)lazy.getValue();
    }

    @Override
    @NotNull
    protected ByteReadChannel getEngineReceiveChannel() {
        return this.engineReceiveChannel;
    }

    @Override
    @NotNull
    protected Headers getEngineHeaders() {
        return this.engineHeaders;
    }

    @Override
    @NotNull
    public Parameters getQueryParameters() {
        Lazy lazy = this.queryParameters$delegate;
        return (Parameters)lazy.getValue();
    }

    @Override
    @NotNull
    public Parameters getRawQueryParameters() {
        Lazy lazy = this.rawQueryParameters$delegate;
        return (Parameters)lazy.getValue();
    }

    @Override
    @NotNull
    public RequestConnectionPoint getLocal() {
        return this.local;
    }

    public final void release$ktor_server_cio() {
        this.request.release();
    }

    private static final RequestCookies cookies_delegate$lambda$0(CIOApplicationRequest this$0) {
        return new RequestCookies(this$0);
    }

    private static final Parameters queryParameters_delegate$lambda$1(CIOApplicationRequest this$0) {
        return CIOApplicationRequestKt.access$toQueryParameters(PipelineRequestKt.encodeParameters(this$0, this$0.getRawQueryParameters()));
    }

    private static final Parameters rawQueryParameters_delegate$lambda$3(CIOApplicationRequest this$0) {
        String uri = ((Object)this$0.request.getUri()).toString();
        Integer n = StringsKt.indexOf$default((CharSequence)uri, (char)'?', (int)0, (boolean)false, (int)6, null);
        int it = ((Number)n).intValue();
        boolean bl = false;
        Integer n2 = it != -1 ? n : null;
        if (n2 == null) {
            return Parameters.Companion.getEmpty();
        }
        int queryStartIndex = n2;
        return QueryKt.parseQueryString$default((String)uri, (int)(queryStartIndex + 1), (int)0, (boolean)false, (int)4, null);
    }
}

