/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.application;

import io.ktor.server.application.Application;
import io.ktor.server.application.ApplicationEnvironment;
import io.ktor.server.application.ServerConfig;
import io.ktor.server.engine.ServerEngineUtilsKt;
import io.ktor.util.PlatformUtils;
import java.util.ArrayList;
import java.util.List;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.EmptyCoroutineContext;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

public final class ServerConfigBuilder {
    @NotNull
    private final ApplicationEnvironment environment;
    @NotNull
    private final List<Function1<Application, Unit>> modules;
    @NotNull
    private List<String> watchPaths;
    @NotNull
    private String rootPath;
    private boolean developmentMode;
    @NotNull
    private CoroutineContext parentCoroutineContext;

    public ServerConfigBuilder(@NotNull ApplicationEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        this.environment = environment;
        this.modules = new ArrayList();
        this.watchPaths = CollectionsKt.listOf((Object)ServerEngineUtilsKt.getWORKING_DIRECTORY_PATH());
        this.rootPath = "";
        this.developmentMode = PlatformUtils.INSTANCE.getIS_DEVELOPMENT_MODE();
        this.parentCoroutineContext = (CoroutineContext)EmptyCoroutineContext.INSTANCE;
    }

    public final void setWatchPaths(@NotNull List<String> list2) {
        Intrinsics.checkNotNullParameter(list2, (String)"<set-?>");
        this.watchPaths = list2;
    }

    public final void setParentCoroutineContext(@NotNull CoroutineContext coroutineContext) {
        Intrinsics.checkNotNullParameter((Object)coroutineContext, (String)"<set-?>");
        this.parentCoroutineContext = coroutineContext;
    }

    public final void module(@NotNull Function1<? super Application, Unit> body) {
        Intrinsics.checkNotNullParameter(body, (String)"body");
        this.modules.add(body);
    }

    @NotNull
    public final ServerConfig build$ktor_server_core() {
        return new ServerConfig(this.environment, CollectionsKt.toList((Iterable)this.modules), this.watchPaths, this.rootPath, this.developmentMode, this.parentCoroutineContext);
    }
}

