/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.application;

import io.ktor.server.application.Application;
import io.ktor.server.application.ApplicationEnvironment;
import io.ktor.server.application.ApplicationRootConfigBridge;
import java.util.List;
import kotlin.Unit;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

public final class ServerConfig {
    @NotNull
    private final ApplicationEnvironment environment;
    @NotNull
    private final List<Function1<Application, Unit>> modules;
    @NotNull
    private final List<String> watchPaths;
    @NotNull
    private final String rootPath;
    private final boolean developmentMode;
    @NotNull
    private final ApplicationRootConfigBridge bridge;
    @NotNull
    private final CoroutineContext parentCoroutineContext;

    public ServerConfig(@NotNull ApplicationEnvironment environment, @NotNull List<? extends Function1<? super Application, Unit>> modules, @NotNull List<String> watchPaths, @NotNull String rootPath, boolean developmentMode, @NotNull CoroutineContext parentCoroutineContext) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter(modules, (String)"modules");
        Intrinsics.checkNotNullParameter(watchPaths, (String)"watchPaths");
        Intrinsics.checkNotNullParameter((Object)rootPath, (String)"rootPath");
        Intrinsics.checkNotNullParameter((Object)parentCoroutineContext, (String)"parentCoroutineContext");
        this.environment = environment;
        this.modules = modules;
        this.watchPaths = watchPaths;
        this.rootPath = rootPath;
        this.developmentMode = developmentMode;
        this.bridge = new ApplicationRootConfigBridge(this, parentCoroutineContext);
        this.parentCoroutineContext = this.bridge.getParentCoroutineContext();
    }

    @NotNull
    public final ApplicationEnvironment getEnvironment() {
        return this.environment;
    }

    @NotNull
    public final List<Function1<Application, Unit>> getModules$ktor_server_core() {
        return this.modules;
    }

    @NotNull
    public final List<String> getWatchPaths$ktor_server_core() {
        return this.watchPaths;
    }

    @NotNull
    public final String getRootPath() {
        return this.rootPath;
    }

    public final boolean getDevelopmentMode() {
        return this.developmentMode;
    }

    @NotNull
    public final CoroutineContext getParentCoroutineContext() {
        return this.parentCoroutineContext;
    }
}

