/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.application;

import io.ktor.events.Events;
import io.ktor.server.application.ApplicationCallPipeline;
import io.ktor.server.application.ApplicationEnvironment;
import io.ktor.server.application.ApplicationPluginKt;
import io.ktor.server.engine.ApplicationEngine;
import io.ktor.util.pipeline.Pipeline;
import io.ktor.utils.io.KtorDsl;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CompletableJob;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.SupervisorKt;
import org.jetbrains.annotations.NotNull;

@KtorDsl
public final class Application
extends ApplicationCallPipeline
implements CoroutineScope {
    @NotNull
    private String rootPath;
    @NotNull
    private final Events monitor;
    @NotNull
    private final CoroutineContext parentCoroutineContext;
    @NotNull
    private final Function0<ApplicationEngine> engineProvider;
    @NotNull
    private final CompletableJob applicationJob;
    @NotNull
    private final CoroutineContext coroutineContext;

    public Application(@NotNull ApplicationEnvironment environment, boolean developmentMode, @NotNull String rootPath, @NotNull Events monitor2, @NotNull CoroutineContext parentCoroutineContext, @NotNull Function0<? extends ApplicationEngine> engineProvider) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)rootPath, (String)"rootPath");
        Intrinsics.checkNotNullParameter((Object)monitor2, (String)"monitor");
        Intrinsics.checkNotNullParameter((Object)parentCoroutineContext, (String)"parentCoroutineContext");
        Intrinsics.checkNotNullParameter(engineProvider, (String)"engineProvider");
        super(developmentMode, environment);
        this.rootPath = rootPath;
        this.monitor = monitor2;
        this.parentCoroutineContext = parentCoroutineContext;
        this.engineProvider = engineProvider;
        this.applicationJob = SupervisorKt.SupervisorJob((Job)((Job)this.parentCoroutineContext.get((CoroutineContext.Key)Job.Key)));
        this.coroutineContext = this.parentCoroutineContext.plus((CoroutineContext)this.applicationJob);
    }

    @NotNull
    public final String getRootPath() {
        return this.rootPath;
    }

    @NotNull
    public final Events getMonitor() {
        return this.monitor;
    }

    @NotNull
    public final CoroutineContext getParentCoroutineContext() {
        return this.parentCoroutineContext;
    }

    @NotNull
    public CoroutineContext getCoroutineContext() {
        return this.coroutineContext;
    }

    public final void dispose() {
        Job.DefaultImpls.cancel$default((Job)((Job)this.applicationJob), null, (int)1, null);
        ApplicationPluginKt.uninstallAllPlugins((Pipeline)this);
    }
}

