/*
 * Decompiled with CFR 0.152.
 */
package fleet.util.bifurcan;

import fleet.util.BifurcanListSerializer;
import fleet.util.bifurcan.nodes.ListNodes;
import fleet.util.bifurcan.utils.Bits;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.function.UnaryOperator;
import kotlin.NotImplementedError;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlinx.collections.immutable.ImmutableList;
import kotlinx.collections.immutable.PersistentList;
import kotlinx.serialization.Serializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Serializable(with=BifurcanListSerializer.class)
@SourceDebugExtension(value={"SMAP\nList.kt\nKotlin\n*S Kotlin\n*F\n+ 1 List.kt\nfleet/util/bifurcan/List\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,645:1\n1869#2,2:646\n774#2:648\n865#2,2:649\n1878#2,3:651\n1869#2,2:654\n1869#2,2:656\n1869#2,2:658\n1869#2,2:660\n388#2,7:663\n1#3:662\n*S KotlinDebug\n*F\n+ 1 List.kt\nfleet/util/bifurcan/List\n*L\n136#1:646,2\n163#1:648\n163#1:649,2\n218#1:651,3\n227#1:654,2\n240#1:656,2\n243#1:658,2\n247#1:660,2\n372#1:663,7\n*E\n"})
public class List<V>
implements PersistentList<V> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private ListNodes.Node root;
    private int prefixLen;
    private int suffixLen;
    @Nullable
    private Object[] prefix;
    @Nullable
    private Object[] suffix;
    @Nullable
    private final Object editor;
    @NotNull
    private static final List<?> EMPTY = new List();

    @Nullable
    public final Object[] getSuffix() {
        return this.suffix;
    }

    public List() {
        this.editor = null;
        this.root = ListNodes.Node.Companion.getEMPTY();
        this.prefixLen = 0;
        this.prefix = null;
        this.suffixLen = 0;
        this.suffix = null;
    }

    protected List(boolean linear, @NotNull ListNodes.Node root, int prefixLen, @Nullable Object[] prefix, int suffixLen, @Nullable Object[] suffix) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        this.editor = linear ? new Object() : null;
        this.root = root;
        this.prefixLen = prefixLen;
        this.suffixLen = suffixLen;
        this.prefix = prefix;
        this.suffix = suffix;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof List)) {
            return false;
        }
        if (this.size() != ((List)other).size()) {
            return false;
        }
        long l = this.size();
        for (long i2 = 0L; i2 < l; ++i2) {
            if (Intrinsics.areEqual(this.nth(i2), ((List)other).nth(i2))) continue;
            return false;
        }
        return true;
    }

    public final V nth(long idx) {
        Object object;
        long rootSize = this.root.size();
        if (idx < 0L || idx >= rootSize + (long)this.prefixLen + (long)this.suffixLen) {
            throw new IndexOutOfBoundsException(idx + " must be within [0," + this.size() + ")");
        }
        if (idx < (long)this.prefixLen) {
            Intrinsics.checkNotNull((Object)this.prefix);
            Intrinsics.checkNotNull((Object)this.prefix);
            object = this.prefix[(int)((long)this.prefix.length + idx - (long)this.prefixLen)];
        } else if (idx - (long)this.prefixLen < rootSize) {
            object = this.root.nth(idx - (long)this.prefixLen, false);
        } else {
            Intrinsics.checkNotNull((Object)this.suffix);
            object = this.suffix[(int)(idx - (rootSize + (long)this.prefixLen))];
        }
        return (V)object;
    }

    public final long size() {
        return this.root.size() + (long)this.prefixLen + (long)this.suffixLen;
    }

    public final boolean isLinear() {
        return this.editor != null;
    }

    @NotNull
    public final List<V> addLast(V value2) {
        return (this.isLinear() ? this : this.clone()).pushLast(value2);
    }

    @Override
    @NotNull
    public List<V> add(V element) {
        return this.addLast(element);
    }

    @Override
    @NotNull
    public List<V> addAll(@NotNull Collection<? extends V> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        List l = null;
        l = this.isLinear() ? this : this.clone();
        Iterable $this$forEach$iv = elements;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv;
            Object elem = element$iv = iterator2.next();
            boolean bl = false;
            l = l.addLast((V)elem);
        }
        return l;
    }

    @Override
    @NotNull
    public final List<V> removeLast() {
        return (this.isLinear() ? this : this.clone()).popLast();
    }

    @Override
    @NotNull
    public final List<V> removeFirst() {
        return (this.isLinear() ? this : this.clone()).popFirst();
    }

    @Override
    @NotNull
    public List<V> removeAt(int index) {
        List<V> l = this.isLinear() ? this : this.clone();
        int n = index;
        if (n == 0) {
            l = l.removeFirst();
        } else if (n == l.size() - 1) {
            l = l.removeLast();
        } else {
            List<V> left = l.slice(0L, index);
            List<V> right = l.slice((long)index + 1L, l.size());
            l = left.concat(right);
        }
        return l;
    }

    public int getSize() {
        return (int)this.size();
    }

    @Override
    @NotNull
    public PersistentList.Builder<V> builder() {
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    public V get(int index) {
        return this.nth(index);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0L;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int indexOf(Object element) {
        Iterable $this$forEachIndexed$iv = this;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void value2;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object t2 = item$iv;
            int index = n;
            boolean bl = false;
            if (value2 == null || !Intrinsics.areEqual((Object)value2, (Object)element)) continue;
            return index;
        }
        return -1;
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Iterable $this$forEach$iv = elements;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv;
            Object elem = element$iv = iterator2.next();
            boolean bl = false;
            if (this.contains(elem)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean contains(Object element) {
        return this.indexOf(element) != -1;
    }

    @Override
    @NotNull
    public Iterator<V> iterator() {
        Object[] initChunk = null;
        int initOffset = 0;
        int initLimit = 0;
        long size = this.size();
        long rootSize = this.root.size();
        if (this.prefixLen > 0) {
            initChunk = this.prefix;
            initOffset = this.pIdx(0);
            Intrinsics.checkNotNull((Object)this.prefix);
            initLimit = this.prefix.length;
        } else if (rootSize > 0L) {
            Object result2 = this.root.nth(0L, true);
            Object[] objectArray = result2 instanceof Object[] ? (Object[])result2 : null;
            if (objectArray == null) {
                Object[] objectArray2 = new Object[]{result2};
                objectArray = objectArray2;
            }
            initChunk = objectArray;
            initOffset = 0;
            initLimit = initChunk.length;
        } else {
            initChunk = this.suffix;
            initOffset = 0;
            initLimit = this.suffixLen;
        }
        return new Iterator<V>(initChunk, initOffset, initLimit, size, this, rootSize){
            private long idx;
            private Object[] chunk;
            private int offset;
            private int limit;
            private int chunkSize;
            final /* synthetic */ long $size;
            final /* synthetic */ List<V> this$0;
            final /* synthetic */ long $rootSize;
            {
                this.$size = $size;
                this.this$0 = $receiver;
                this.$rootSize = $rootSize;
                this.chunk = $initChunk;
                this.offset = $initOffset;
                this.limit = $initLimit;
                this.chunkSize = this.limit - this.offset;
            }

            public boolean hasNext() {
                return this.idx < this.$size;
            }

            public V next() {
                Intrinsics.checkNotNull((Object)this.chunk);
                int n = this.offset;
                this.offset = n + 1;
                Object value2 = this.chunk[n];
                if (this.offset == this.limit) {
                    this.idx += (long)this.chunkSize;
                    if (this.idx < this.$size) {
                        if (this.idx == (long)List.access$getPrefixLen$p(this.this$0) + this.$rootSize) {
                            this.chunk = this.this$0.getSuffix();
                            this.limit = List.access$getSuffixLen$p(this.this$0);
                        } else {
                            Object result2 = List.access$getRoot$p(this.this$0).nth(this.idx - (long)List.access$getPrefixLen$p(this.this$0), true);
                            Object[] objectArray = result2 instanceof Object[] ? (Object[])result2 : null;
                            if (objectArray == null) {
                                Object[] objectArray2 = new Object[]{result2};
                                objectArray = objectArray2;
                            }
                            this.chunk = objectArray;
                            Intrinsics.checkNotNull((Object)this.chunk);
                            this.limit = this.chunk.length;
                        }
                        this.offset = 0;
                        this.chunkSize = this.limit;
                    }
                }
                return (V)value2;
            }

            public void remove() {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }
        };
    }

    @Override
    @NotNull
    public ListIterator<V> listIterator() {
        return this.listIterator(0);
    }

    @Override
    @NotNull
    public ListIterator<V> listIterator(int index) {
        long l = this.size();
        long l2 = index;
        if (!(0L <= l2 ? l2 < l : false)) {
            throw new IndexOutOfBoundsException(index + " must be within [0," + this.size() + ")");
        }
        Iterator<V> iter = this.iterator();
        for (int j = 0; j < index; ++j) {
            int it = j;
            boolean bl = false;
            if (!iter.hasNext()) continue;
            iter.next();
        }
        Intrinsics.checkNotNull(iter, (String)"null cannot be cast to non-null type kotlin.collections.ListIterator<V of fleet.util.bifurcan.List>");
        return (ListIterator)iter;
    }

    @Override
    public int lastIndexOf(Object element) {
        int n;
        block1: {
            java.util.List $this$indexOfLast$iv = this;
            boolean $i$f$indexOfLast = false;
            ListIterator iterator$iv = $this$indexOfLast$iv.listIterator($this$indexOfLast$iv.size());
            while (iterator$iv.hasPrevious()) {
                Object elem = iterator$iv.previous();
                boolean bl = false;
                if (!Intrinsics.areEqual(elem, (Object)element)) continue;
                n = iterator$iv.nextIndex();
                break block1;
            }
            n = -1;
        }
        return n;
    }

    @NotNull
    public final List<V> slice(long start2, long end) {
        if (start2 < 0L || end > this.size()) {
            throw new IndexOutOfBoundsException("[" + start2 + "," + end + ") isn't a subset of [0," + this.size() + ")");
        }
        if (end <= start2) {
            return new List<V>();
        }
        int pStart = (int)Math.min((double)this.prefixLen, (double)start2);
        int pEnd = (int)Math.min((double)this.prefixLen, (double)end);
        int pLen = pEnd - pStart;
        Object[] pre = null;
        if (pLen > 0) {
            pre = new Object[1 << Bits.INSTANCE.log2Ceil(pLen)];
            Object[] prefixArray = this.prefix;
            Intrinsics.checkNotNull((Object)prefixArray);
            ArraysKt.copyInto((Object[])prefixArray, (Object[])pre, (int)(pre.length - pLen), (int)this.pIdx(pStart), (int)(this.pIdx(pStart) + pLen));
        }
        int sStart = RangesKt.coerceAtLeast((int)((int)(start2 - ((long)this.prefixLen + this.root.size()))), (int)0);
        int sLen = RangesKt.coerceAtLeast((int)((int)(end - ((long)this.prefixLen + this.root.size())) - sStart), (int)0);
        Object[] suf = null;
        if (sLen > 0) {
            suf = new Object[1 << Bits.INSTANCE.log2Ceil(sLen)];
            Intrinsics.checkNotNull((Object)this.suffix);
            ArraysKt.copyInto((Object[])this.suffix, (Object[])suf, (int)0, (int)sStart, (int)(sStart + sLen));
        }
        return new List<V>(this.isLinear(), this.root.slice(RangesKt.coerceAtLeast((int)((int)Math.min(this.root.size(), start2 - (long)this.prefixLen)), (int)0), RangesKt.coerceAtLeast((int)((int)Math.min(this.root.size(), end - (long)this.prefixLen)), (int)0), new Object()), pLen, pre, sLen, suf);
    }

    @NotNull
    public final List<V> concat(@NotNull PersistentList<? extends V> l) {
        Object[] objectArray;
        Object[] objectArray2;
        Intrinsics.checkNotNullParameter(l, (String)"l");
        List b = (List)l;
        ListNodes.Node r = this.root;
        Object editor = new Object();
        if (this.suffixLen > 0) {
            r = r.pushLast(this.suffixArray(), editor);
        }
        if (b.prefixLen > 0) {
            r = r.pushLast(b.prefixArray(), editor);
        }
        if (b.root.size() > 0L) {
            r = r.concat(b.root, editor);
        }
        boolean bl = this.isLinear();
        if (this.prefixLen > 0) {
            Intrinsics.checkNotNull((Object)this.prefix);
            Object[] objectArray3 = Arrays.copyOf(this.prefix, this.prefix.length);
            objectArray2 = objectArray3;
            Intrinsics.checkNotNullExpressionValue((Object)objectArray3, (String)"copyOf(...)");
        } else {
            objectArray2 = null;
        }
        int n = b.suffixLen;
        if (b.suffixLen > 0) {
            Object[] objectArray4 = b.suffix;
            Intrinsics.checkNotNull((Object)b.suffix);
            Object[] objectArray5 = Arrays.copyOf(objectArray4, objectArray4.length);
            objectArray = objectArray5;
            Intrinsics.checkNotNullExpressionValue((Object)objectArray5, (String)"copyOf(...)");
        } else {
            objectArray = null;
        }
        return new List<V>(bl, r, this.prefixLen, objectArray2, n, objectArray);
    }

    @NotNull
    public final List<V> forked() {
        return this.isLinear() ? new List<V>(false, this.root, this.prefixLen, this.prefix, this.suffixLen, this.suffix).clone() : this;
    }

    @NotNull
    public final List<V> linear() {
        return this.isLinear() ? this : new List<V>(true, this.root, this.prefixLen, this.prefix, this.suffixLen, this.suffix).clone();
    }

    @NotNull
    public final List<V> clone() {
        Object[] objectArray;
        Object[] objectArray2;
        boolean bl = this.isLinear();
        if (this.prefix == null) {
            objectArray2 = null;
        } else if (this.prefix != null) {
            Object[] objectArray3 = Arrays.copyOf(this.prefix, this.prefix.length);
            objectArray2 = objectArray3;
            Intrinsics.checkNotNullExpressionValue((Object)objectArray3, (String)"copyOf(...)");
        } else {
            objectArray2 = null;
        }
        if (this.suffix == null) {
            objectArray = null;
        } else if (this.suffix != null) {
            Object[] objectArray4 = Arrays.copyOf(this.suffix, this.suffix.length);
            objectArray = objectArray4;
            Intrinsics.checkNotNullExpressionValue((Object)objectArray4, (String)"copyOf(...)");
        } else {
            objectArray = null;
        }
        return new List<V>(bl, this.root, this.prefixLen, objectArray2, this.suffixLen, objectArray);
    }

    private final Object[] suffixArray() {
        Object[] objectArray = this.suffix != null ? ArraysKt.copyOfRange((Object[])this.suffix, (int)0, (int)this.suffixLen) : null;
        Intrinsics.checkNotNull((Object)objectArray);
        return objectArray;
    }

    private final Object[] prefixArray() {
        Object[] objectArray = this.prefix != null ? ArraysKt.copyOfRange((Object[])this.prefix, (int)this.pIdx(0), (int)(this.pIdx(0) + this.prefixLen)) : null;
        Intrinsics.checkNotNull(objectArray);
        return objectArray;
    }

    private final int pIdx(int idx) {
        Intrinsics.checkNotNull((Object)this.prefix);
        return this.prefix.length - this.prefixLen + idx;
    }

    @NotNull
    public final List<V> pushLast(V value2) {
        if (this.suffix == null) {
            this.suffix = new Object[2];
        } else {
            Intrinsics.checkNotNull((Object)this.suffix);
            if (this.suffixLen == this.suffix.length) {
                Intrinsics.checkNotNull((Object)this.suffix);
                Object[] newSuffix = new Object[(int)Math.min(32.0, (double)(this.suffix.length << 1))];
                Intrinsics.checkNotNull((Object)this.suffix);
                Intrinsics.checkNotNull((Object)this.suffix);
                ArraysKt.copyInto((Object[])this.suffix, (Object[])newSuffix, (int)0, (int)0, (int)this.suffix.length);
                this.suffix = newSuffix;
            }
        }
        Intrinsics.checkNotNull((Object)this.suffix);
        int newSuffix = this.suffixLen;
        this.suffixLen = newSuffix + 1;
        this.suffix[newSuffix] = value2;
        if (this.suffixLen == 32) {
            Object editor = this.isLinear() ? this.editor : new Object();
            this.root = this.root.pushLast(this.suffix, editor);
            this.suffix = null;
            this.suffixLen = 0;
        }
        return this;
    }

    @NotNull
    public final List<V> popFirst() {
        if (this.prefixLen == 0) {
            if (this.root.size() > 0L) {
                Object[] chunk2 = this.root.first();
                if (chunk2 != null) {
                    Object editor = this.isLinear() ? this.editor : new Object();
                    Object[] objectArray = Arrays.copyOf(chunk2, chunk2.length);
                    Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"copyOf(...)");
                    this.prefix = objectArray;
                    Intrinsics.checkNotNull((Object)this.prefix);
                    this.prefixLen = this.prefix.length;
                    this.root = this.root.popFirst(editor);
                }
            } else if (this.suffixLen > 0) {
                Intrinsics.checkNotNull((Object)this.suffix);
                Intrinsics.checkNotNull((Object)this.suffix);
                ArraysKt.copyInto((Object[])this.suffix, (Object[])this.suffix, (int)0, (int)1, (int)this.suffixLen);
                --this.suffixLen;
                Intrinsics.checkNotNull((Object)this.suffix);
                this.suffix[this.suffixLen] = null;
            }
        }
        if (this.prefixLen > 0) {
            int n = this.prefixLen;
            this.prefixLen = n + -1;
            Intrinsics.checkNotNull((Object)this.prefix);
            this.prefix[this.pIdx((int)-1)] = null;
        }
        return this;
    }

    @NotNull
    public final List<V> popLast() {
        if (this.suffixLen == 0) {
            if (this.root.size() > 0L) {
                Object[] chunk2 = this.root.last();
                if (chunk2 != null) {
                    Object editor = this.isLinear() ? this.editor : new Object();
                    Object[] objectArray = Arrays.copyOf(chunk2, chunk2.length);
                    Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"copyOf(...)");
                    this.suffix = objectArray;
                    Intrinsics.checkNotNull((Object)this.suffix);
                    this.suffixLen = this.suffix.length;
                    this.root = this.root.popLast(editor);
                }
            } else if (this.prefixLen > 0) {
                int n = this.prefixLen;
                this.prefixLen = n + -1;
                Intrinsics.checkNotNull((Object)this.prefix);
                Intrinsics.checkNotNull((Object)this.prefix);
                ArraysKt.copyInto((Object[])this.prefix, (Object[])this.prefix, (int)this.pIdx(0), (int)this.pIdx(-1), (int)(this.pIdx(-1) + this.prefixLen));
                Intrinsics.checkNotNull((Object)this.prefix);
                this.prefix[this.pIdx((int)-1)] = null;
            }
        }
        if (this.suffixLen > 0) {
            Intrinsics.checkNotNull((Object)this.suffix);
            this.suffixLen += -1;
            this.suffix[this.suffixLen] = null;
        }
        return this;
    }

    @Override
    @NotNull
    public ImmutableList<V> subList(int fromIndex, int toIndex) {
        return PersistentList.DefaultImpls.subList(this, fromIndex, toIndex);
    }

    @Override
    public boolean add(V element) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public void add(int index, V element) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean remove(Object element) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean addAll(Collection<? extends V> elements) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean addAll(int index, Collection<? extends V> elements) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean removeAll(Collection<?> elements) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean retainAll(Collection<?> elements) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public V set(int index, V element) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public V remove(int index) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public void replaceAll(UnaryOperator<V> p0) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public void sort(Comparator<? super V> p0) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    public static final /* synthetic */ int access$getPrefixLen$p(List $this) {
        return $this.prefixLen;
    }

    public static final /* synthetic */ int access$getSuffixLen$p(List $this) {
        return $this.suffixLen;
    }

    public static final /* synthetic */ ListNodes.Node access$getRoot$p(List $this) {
        return $this.root;
    }

    @Override
    public <T> T[] toArray(T[] array) {
        Intrinsics.checkNotNullParameter(array, (String)"array");
        return CollectionToArray.toArray((Collection)this, (Object[])array);
    }

    @Override
    public Object[] toArray() {
        return CollectionToArray.toArray((Collection)this);
    }

    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final <V> List<V> from(@NotNull Iterable<? extends V> iterable) {
            Intrinsics.checkNotNullParameter(iterable, (String)"iterable");
            return this.from(iterable.iterator());
        }

        @NotNull
        public final <V> List<V> from(@NotNull Iterator<? extends V> iterator2) {
            Intrinsics.checkNotNullParameter(iterator2, (String)"iterator");
            List list2 = new List().linear();
            while (iterator2.hasNext()) {
                list2.add((Object)iterator2.next());
            }
            return list2.forked();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

