/*
 * Decompiled with CFR 0.152.
 */
package fleet.util;

import fleet.util.Random;
import fleet.util.serialization.DelegateSerializer;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.Regex;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Serializable(with=Serializer.class)
public final class UID {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String id;
    @NotNull
    private static final Regex uidRegex = new Regex("^([A-Za-z0-9_-]{1,36})$");

    private UID(String id) {
        this.id = id;
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof UID && Intrinsics.areEqual((Object)this.id, (Object)((UID)other).id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    @NotNull
    public String toString() {
        return this.id;
    }

    public /* synthetic */ UID(String id, DefaultConstructorMarker $constructor_marker) {
        this(id);
    }

    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final UID random() {
            return new UID(Random.INSTANCE.nextUidString$fleet_util_core(20), null);
        }

        public final boolean isUid(@NotNull String id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            CharSequence charSequence = id;
            return uidRegex.matches(charSequence);
        }

        @NotNull
        public final UID fromString(@NotNull String id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Companion $this$fromString_u24lambda_u241 = this;
            boolean bl = false;
            if (!$this$fromString_u24lambda_u241.isUid(id)) {
                boolean bl2 = false;
                String string = "Invalid UID format: \"" + id + "\", UID is a random [A-Za-z0-9_-] string, case-sensitive, no more than 36 characters long.";
                throw new IllegalStateException(string.toString());
            }
            return new UID(id, null);
        }

        @NotNull
        public final KSerializer<UID> serializer() {
            return Serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    public static final class Serializer
    extends DelegateSerializer<UID, String> {
        @NotNull
        public static final Serializer INSTANCE = new Serializer();

        private Serializer() {
            super(1.INSTANCE, BuiltinSerializersKt.serializer((StringCompanionObject)StringCompanionObject.INSTANCE), (Function1)new Function1<String, UID>((Object)Companion){

                public final UID invoke(String p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return ((Companion)this.receiver).fromString(p0);
                }
            });
        }
    }
}

