/*
 * Decompiled with CFR 0.152.
 */
package fleet.multiplatform.shims;

import fleet.multiplatform.shims.ThreadLocal;
import fleet.multiplatform.shims.ThreadLocalKey;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.EmptyCoroutineContext;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.ThreadContextElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ThreadLocalElement<T>
implements ThreadContextElement<T> {
    private final T value;
    @NotNull
    private final ThreadLocal<T> threadLocal;
    @NotNull
    private final CoroutineContext.Key<?> key;

    public ThreadLocalElement(T value2, @NotNull ThreadLocal<T> threadLocal2) {
        Intrinsics.checkNotNullParameter(threadLocal2, (String)"threadLocal");
        this.value = value2;
        this.threadLocal = threadLocal2;
        this.key = new ThreadLocalKey(this.threadLocal);
    }

    @NotNull
    public CoroutineContext.Key<?> getKey() {
        return this.key;
    }

    public T updateThreadContext(@NotNull CoroutineContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        T oldState = this.threadLocal.get();
        this.threadLocal.set(this.value);
        return oldState;
    }

    public void restoreThreadContext(@NotNull CoroutineContext context2, T oldState) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.threadLocal.set(oldState);
    }

    @NotNull
    public CoroutineContext minusKey(@NotNull CoroutineContext.Key<?> key2) {
        Intrinsics.checkNotNullParameter(key2, (String)"key");
        return Intrinsics.areEqual(this.getKey(), key2) ? (CoroutineContext)EmptyCoroutineContext.INSTANCE : (CoroutineContext)this;
    }

    @Nullable
    public <E extends CoroutineContext.Element> E get(@NotNull CoroutineContext.Key<E> key2) {
        CoroutineContext.Element element;
        Intrinsics.checkNotNullParameter(key2, (String)"key");
        if (Intrinsics.areEqual(this.getKey(), key2)) {
            Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type E of fleet.multiplatform.shims.ThreadLocalElement.get");
            element = (CoroutineContext.Element)this;
        } else {
            element = null;
        }
        return (E)element;
    }

    @NotNull
    public String toString() {
        return "ThreadLocal(value=" + this.value + ", threadLocal = " + this.threadLocal + ")";
    }

    public <R> R fold(R initial, @NotNull Function2<? super R, ? super CoroutineContext.Element, ? extends R> operation) {
        return (R)ThreadContextElement.DefaultImpls.fold((ThreadContextElement)this, initial, operation);
    }

    @NotNull
    public CoroutineContext plus(@NotNull CoroutineContext context2) {
        return ThreadContextElement.DefaultImpls.plus((ThreadContextElement)this, (CoroutineContext)context2);
    }
}

