/*
 * Decompiled with CFR 0.152.
 */
package fleet.kernel.rebase;

import com.jetbrains.rhizomedb.Novelty;
import fleet.fastutil.ints.IntMap;
import fleet.util.UID;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SpeculationData {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Novelty novelty;
    @NotNull
    private final List<IntMap<UID>> idMappings;

    public SpeculationData(@NotNull Novelty novelty2, @NotNull List<? extends IntMap<UID>> idMappings) {
        Intrinsics.checkNotNullParameter((Object)novelty2, (String)"novelty");
        Intrinsics.checkNotNullParameter(idMappings, (String)"idMappings");
        this.novelty = novelty2;
        this.idMappings = idMappings;
    }

    @NotNull
    public final Novelty getNovelty() {
        return this.novelty;
    }

    @NotNull
    public final List<IntMap<UID>> getIdMappings() {
        return this.idMappings;
    }

    @NotNull
    public final SpeculationData copy(@NotNull Novelty novelty2, @NotNull List<? extends IntMap<UID>> idMappings) {
        Intrinsics.checkNotNullParameter((Object)novelty2, (String)"novelty");
        Intrinsics.checkNotNullParameter(idMappings, (String)"idMappings");
        return new SpeculationData(novelty2, idMappings);
    }

    @NotNull
    public String toString() {
        return "SpeculationData(novelty=" + this.novelty + ", idMappings=" + this.idMappings + ")";
    }

    public int hashCode() {
        int result2 = this.novelty.hashCode();
        result2 = result2 * 31 + ((Object)this.idMappings).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SpeculationData)) {
            return false;
        }
        SpeculationData speculationData = (SpeculationData)other;
        if (!Intrinsics.areEqual((Object)this.novelty, (Object)speculationData.novelty)) {
            return false;
        }
        return Intrinsics.areEqual(this.idMappings, speculationData.idMappings);
    }

    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SpeculationData empty() {
            return new SpeculationData(Novelty.Companion.getEmpty(), CollectionsKt.emptyList());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

