/*
 * Decompiled with CFR 0.152.
 */
package fleet.kernel.rebase;

import com.jetbrains.rhizomedb.DB;
import fleet.fastutil.ints.IntMap;
import fleet.kernel.rebase.SharedBlock;
import fleet.kernel.rebase.Transaction;
import fleet.util.UID;
import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RebaseLogEntry {
    @NotNull
    private final List<SharedBlock> sharedBlocks;
    @NotNull
    private final IntMap<UID> idMapping;
    @NotNull
    private final DB dbBefore;
    @NotNull
    private final DB dbAfter;
    @Nullable
    private final Transaction transaction;
    private final long sendEpoch;
    private final boolean replayFailed;

    public RebaseLogEntry(@NotNull List<? extends SharedBlock> sharedBlocks, @NotNull IntMap<UID> idMapping, @NotNull DB dbBefore, @NotNull DB dbAfter, @Nullable Transaction transaction, long sendEpoch, boolean replayFailed) {
        Intrinsics.checkNotNullParameter(sharedBlocks, (String)"sharedBlocks");
        Intrinsics.checkNotNullParameter(idMapping, (String)"idMapping");
        Intrinsics.checkNotNullParameter((Object)dbBefore, (String)"dbBefore");
        Intrinsics.checkNotNullParameter((Object)dbAfter, (String)"dbAfter");
        this.sharedBlocks = sharedBlocks;
        this.idMapping = idMapping;
        this.dbBefore = dbBefore;
        this.dbAfter = dbAfter;
        this.transaction = transaction;
        this.sendEpoch = sendEpoch;
        this.replayFailed = replayFailed;
    }

    @NotNull
    public final List<SharedBlock> getSharedBlocks() {
        return this.sharedBlocks;
    }

    @NotNull
    public final IntMap<UID> getIdMapping() {
        return this.idMapping;
    }

    @NotNull
    public final DB getDbBefore() {
        return this.dbBefore;
    }

    @NotNull
    public final DB getDbAfter() {
        return this.dbAfter;
    }

    @Nullable
    public final Transaction getTransaction() {
        return this.transaction;
    }

    public final long getSendEpoch() {
        return this.sendEpoch;
    }

    public final boolean getReplayFailed() {
        return this.replayFailed;
    }

    @NotNull
    public final RebaseLogEntry copy(@NotNull List<? extends SharedBlock> sharedBlocks, @NotNull IntMap<UID> idMapping, @NotNull DB dbBefore, @NotNull DB dbAfter, @Nullable Transaction transaction, long sendEpoch, boolean replayFailed) {
        Intrinsics.checkNotNullParameter(sharedBlocks, (String)"sharedBlocks");
        Intrinsics.checkNotNullParameter(idMapping, (String)"idMapping");
        Intrinsics.checkNotNullParameter((Object)dbBefore, (String)"dbBefore");
        Intrinsics.checkNotNullParameter((Object)dbAfter, (String)"dbAfter");
        return new RebaseLogEntry(sharedBlocks, idMapping, dbBefore, dbAfter, transaction, sendEpoch, replayFailed);
    }

    public static /* synthetic */ RebaseLogEntry copy$default(RebaseLogEntry rebaseLogEntry, List list2, IntMap intMap, DB dB, DB dB2, Transaction transaction, long l, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            list2 = rebaseLogEntry.sharedBlocks;
        }
        if ((n & 2) != 0) {
            intMap = rebaseLogEntry.idMapping;
        }
        if ((n & 4) != 0) {
            dB = rebaseLogEntry.dbBefore;
        }
        if ((n & 8) != 0) {
            dB2 = rebaseLogEntry.dbAfter;
        }
        if ((n & 0x10) != 0) {
            transaction = rebaseLogEntry.transaction;
        }
        if ((n & 0x20) != 0) {
            l = rebaseLogEntry.sendEpoch;
        }
        if ((n & 0x40) != 0) {
            bl = rebaseLogEntry.replayFailed;
        }
        return rebaseLogEntry.copy(list2, intMap, dB, dB2, transaction, l, bl);
    }

    @NotNull
    public String toString() {
        return "RebaseLogEntry(sharedBlocks=" + this.sharedBlocks + ", idMapping=" + this.idMapping + ", dbBefore=" + this.dbBefore + ", dbAfter=" + this.dbAfter + ", transaction=" + this.transaction + ", sendEpoch=" + this.sendEpoch + ", replayFailed=" + this.replayFailed + ")";
    }

    public int hashCode() {
        int result2 = ((Object)this.sharedBlocks).hashCode();
        result2 = result2 * 31 + this.idMapping.hashCode();
        result2 = result2 * 31 + this.dbBefore.hashCode();
        result2 = result2 * 31 + this.dbAfter.hashCode();
        result2 = result2 * 31 + (this.transaction == null ? 0 : this.transaction.hashCode());
        result2 = result2 * 31 + Long.hashCode(this.sendEpoch);
        result2 = result2 * 31 + Boolean.hashCode(this.replayFailed);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RebaseLogEntry)) {
            return false;
        }
        RebaseLogEntry rebaseLogEntry = (RebaseLogEntry)other;
        if (!Intrinsics.areEqual(this.sharedBlocks, rebaseLogEntry.sharedBlocks)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.idMapping, rebaseLogEntry.idMapping)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.dbBefore, (Object)rebaseLogEntry.dbBefore)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.dbAfter, (Object)rebaseLogEntry.dbAfter)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.transaction, (Object)rebaseLogEntry.transaction)) {
            return false;
        }
        if (this.sendEpoch != rebaseLogEntry.sendEpoch) {
            return false;
        }
        return this.replayFailed == rebaseLogEntry.replayFailed;
    }
}

