/*
 * Decompiled with CFR 0.152.
 */
package fleet.kernel.rebase;

import com.jetbrains.rhizomedb.DB;
import fleet.kernel.rebase.LogSegment;
import fleet.kernel.rebase.RebaseLogEntry;
import fleet.kernel.rebase.RebaseLogKt;
import fleet.kernel.rebase.Transaction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nRebaseLog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RebaseLog.kt\nfleet/kernel/rebase/RebaseLog\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,410:1\n1563#2:411\n1634#2,3:412\n1869#2,2:415\n1563#2:417\n1634#2,3:418\n1869#2,2:421\n*S KotlinDebug\n*F\n+ 1 RebaseLog.kt\nfleet/kernel/rebase/RebaseLog\n*L\n75#1:411\n75#1:412,3\n75#1:415,2\n79#1:417\n79#1:418,3\n79#1:421,2\n*E\n"})
public final class RebaseLog {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LogSegment speculation;
    @NotNull
    private final LogSegment rebasing;
    private final long sendEpoch;

    public RebaseLog(@NotNull LogSegment speculation, @NotNull LogSegment rebasing, long sendEpoch) {
        Intrinsics.checkNotNullParameter((Object)speculation, (String)"speculation");
        Intrinsics.checkNotNullParameter((Object)rebasing, (String)"rebasing");
        this.speculation = speculation;
        this.rebasing = rebasing;
        this.sendEpoch = sendEpoch;
        DB lastSpeculativeDB = RebaseLogKt.isEmpty(this.speculation) ? this.speculation.getBase() : ((RebaseLogEntry)CollectionsKt.last((List)this.speculation.getEntries())).getDbAfter();
        RebaseLogKt.invariant(this, Intrinsics.areEqual((Object)this.rebasing.getBase(), (Object)lastSpeculativeDB), (Function0<String>)((Function0)1.INSTANCE));
    }

    @NotNull
    public final LogSegment getSpeculation() {
        return this.speculation;
    }

    @NotNull
    public final LogSegment getRebasing() {
        return this.rebasing;
    }

    public final long getSendEpoch() {
        return this.sendEpoch;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String debugString() {
        void $this$forEach$iv;
        RebaseLogEntry e;
        Collection collection;
        Object item$iv$iv;
        Iterable $this$mapTo$iv$iv;
        StringBuilder stringBuilder;
        StringBuilder $this$debugString_u24lambda_u244 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$debugString_u24lambda_u244.append("rebaseLog dump:").append('\n');
        $this$debugString_u24lambda_u244.append("speculation:").append('\n');
        Iterable $this$map$iv = this.speculation.getEntries();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            item$iv$iv = iterator2.next();
            RebaseLogEntry rebaseLogEntry = (RebaseLogEntry)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(e.getTransaction());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Transaction tx = (Transaction)element$iv;
            boolean bl3 = false;
            $this$debugString_u24lambda_u244.append(tx).append('\n');
        }
        $this$debugString_u24lambda_u244.append("rebasing:").append('\n');
        $this$map$iv = this.rebasing.getEntries();
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        Iterator bl3 = $this$mapTo$iv$iv.iterator();
        while (bl3.hasNext()) {
            item$iv$iv = bl3.next();
            e = (RebaseLogEntry)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl4 = false;
            collection.add(e.getTransaction());
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Transaction tx = (Transaction)element$iv;
            boolean bl5 = false;
            $this$debugString_u24lambda_u244.append(tx).append('\n');
        }
        return stringBuilder.toString();
    }

    @NotNull
    public final RebaseLog copy(@NotNull LogSegment speculation, @NotNull LogSegment rebasing, long sendEpoch) {
        Intrinsics.checkNotNullParameter((Object)speculation, (String)"speculation");
        Intrinsics.checkNotNullParameter((Object)rebasing, (String)"rebasing");
        return new RebaseLog(speculation, rebasing, sendEpoch);
    }

    public static /* synthetic */ RebaseLog copy$default(RebaseLog rebaseLog, LogSegment logSegment, LogSegment logSegment2, long l, int n, Object object) {
        if ((n & 1) != 0) {
            logSegment = rebaseLog.speculation;
        }
        if ((n & 2) != 0) {
            logSegment2 = rebaseLog.rebasing;
        }
        if ((n & 4) != 0) {
            l = rebaseLog.sendEpoch;
        }
        return rebaseLog.copy(logSegment, logSegment2, l);
    }

    @NotNull
    public String toString() {
        return "RebaseLog(speculation=" + this.speculation + ", rebasing=" + this.rebasing + ", sendEpoch=" + this.sendEpoch + ")";
    }

    public int hashCode() {
        int result2 = this.speculation.hashCode();
        result2 = result2 * 31 + this.rebasing.hashCode();
        result2 = result2 * 31 + Long.hashCode(this.sendEpoch);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RebaseLog)) {
            return false;
        }
        RebaseLog rebaseLog = (RebaseLog)other;
        if (!Intrinsics.areEqual((Object)this.speculation, (Object)rebaseLog.speculation)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.rebasing, (Object)rebaseLog.rebasing)) {
            return false;
        }
        return this.sendEpoch == rebaseLog.sendEpoch;
    }

    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RebaseLog empty(@NotNull DB db) {
            Intrinsics.checkNotNullParameter((Object)db, (String)"db");
            LogSegment emptySegment = LogSegment.Companion.empty(db);
            return new RebaseLog(emptySegment, emptySegment, 1L);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

