/*
 * Decompiled with CFR 0.152.
 */
package fleet.kernel.rebase;

import com.jetbrains.rhizomedb.Instruction;
import com.jetbrains.rhizomedb.InstructionEffect;
import com.jetbrains.rhizomedb.Novelty;
import fleet.kernel.rebase.SharedBlock;
import fleet.kernel.rebase.SharedInstruction;
import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InstructionsPair
extends SharedBlock {
    @Nullable
    private final SharedInstruction sharedInstruction;
    @NotNull
    private final Instruction localInstruction;
    @NotNull
    private final List<InstructionEffect> sharedEffects;
    @NotNull
    private final Novelty sharedNovelty;

    public InstructionsPair(@Nullable SharedInstruction sharedInstruction, @NotNull Instruction localInstruction, @NotNull List<InstructionEffect> sharedEffects, @NotNull Novelty sharedNovelty) {
        Intrinsics.checkNotNullParameter((Object)localInstruction, (String)"localInstruction");
        Intrinsics.checkNotNullParameter(sharedEffects, (String)"sharedEffects");
        Intrinsics.checkNotNullParameter((Object)sharedNovelty, (String)"sharedNovelty");
        super(null);
        this.sharedInstruction = sharedInstruction;
        this.localInstruction = localInstruction;
        this.sharedEffects = sharedEffects;
        this.sharedNovelty = sharedNovelty;
    }

    @Nullable
    public final SharedInstruction getSharedInstruction() {
        return this.sharedInstruction;
    }

    @NotNull
    public final Instruction getLocalInstruction() {
        return this.localInstruction;
    }

    @NotNull
    public final List<InstructionEffect> getSharedEffects() {
        return this.sharedEffects;
    }

    @NotNull
    public final Novelty getSharedNovelty() {
        return this.sharedNovelty;
    }

    @NotNull
    public String toString() {
        return "InstructionsPair(sharedInstruction=" + this.sharedInstruction + ", localInstruction=" + this.localInstruction + ", sharedEffects=" + this.sharedEffects + ", sharedNovelty=" + this.sharedNovelty + ")";
    }

    public int hashCode() {
        int result2 = this.sharedInstruction == null ? 0 : this.sharedInstruction.hashCode();
        result2 = result2 * 31 + this.localInstruction.hashCode();
        result2 = result2 * 31 + ((Object)this.sharedEffects).hashCode();
        result2 = result2 * 31 + this.sharedNovelty.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof InstructionsPair)) {
            return false;
        }
        InstructionsPair instructionsPair = (InstructionsPair)other;
        if (!Intrinsics.areEqual((Object)this.sharedInstruction, (Object)instructionsPair.sharedInstruction)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.localInstruction, (Object)instructionsPair.localInstruction)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.sharedEffects, instructionsPair.sharedEffects)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.sharedNovelty, (Object)instructionsPair.sharedNovelty);
    }
}

