/*
 * Decompiled with CFR 0.152.
 */
package fleet.kernel;

import com.jetbrains.rhizomedb.Change;
import com.jetbrains.rhizomedb.ChangeScope;
import fleet.tracing.runtime.Span;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.Deferred;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ChangeTask {
    @NotNull
    private final Function1<ChangeScope, Unit> f;
    @NotNull
    private final Deferred<Unit> rendezvous;
    @NotNull
    private final CompletableDeferred<Change> resultDeferred;
    @Nullable
    private final Span causeSpan;

    public ChangeTask(@NotNull Function1<? super ChangeScope, Unit> f, @NotNull Deferred<Unit> rendezvous, @NotNull CompletableDeferred<Change> resultDeferred, @Nullable Span causeSpan) {
        Intrinsics.checkNotNullParameter(f, (String)"f");
        Intrinsics.checkNotNullParameter(rendezvous, (String)"rendezvous");
        Intrinsics.checkNotNullParameter(resultDeferred, (String)"resultDeferred");
        this.f = f;
        this.rendezvous = rendezvous;
        this.resultDeferred = resultDeferred;
        this.causeSpan = causeSpan;
    }

    @NotNull
    public final Function1<ChangeScope, Unit> getF() {
        return this.f;
    }

    @NotNull
    public final Deferred<Unit> getRendezvous() {
        return this.rendezvous;
    }

    @NotNull
    public final CompletableDeferred<Change> getResultDeferred() {
        return this.resultDeferred;
    }

    @Nullable
    public final Span getCauseSpan() {
        return this.causeSpan;
    }

    @NotNull
    public String toString() {
        return "ChangeTask(f=" + this.f + ", rendezvous=" + this.rendezvous + ", resultDeferred=" + this.resultDeferred + ", causeSpan=" + this.causeSpan + ")";
    }

    public int hashCode() {
        int result2 = this.f.hashCode();
        result2 = result2 * 31 + this.rendezvous.hashCode();
        result2 = result2 * 31 + this.resultDeferred.hashCode();
        result2 = result2 * 31 + (this.causeSpan == null ? 0 : this.causeSpan.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ChangeTask)) {
            return false;
        }
        ChangeTask changeTask = (ChangeTask)other;
        if (!Intrinsics.areEqual(this.f, changeTask.f)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.rendezvous, changeTask.rendezvous)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.resultDeferred, changeTask.resultDeferred)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.causeSpan, (Object)changeTask.causeSpan);
    }
}

