/*
 * Decompiled with CFR 0.152.
 */
package fleet.fastutil.longs;

import fleet.fastutil.HashCommon;
import fleet.fastutil.longs.LongArrayList;
import fleet.fastutil.longs.LongSet;
import fleet.fastutil.longs.LongSetExtensionsKt;
import fleet.fastutil.longs.MutableLongIterator;
import fleet.fastutil.longs.MutableLongSet;
import java.util.NoSuchElementException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nLongOpenHashSet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LongOpenHashSet.kt\nfleet/fastutil/longs/LongOpenHashSet\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,548:1\n1#2:549\n*E\n"})
public final class LongOpenHashSet
implements MutableLongSet {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private long[] key;
    private int mask;
    private boolean containsNull;
    private int n;
    private int maxFill;
    private final int minN;
    private int size;
    private final float f;

    public LongOpenHashSet(int expected, float f) {
        if (f <= 0.0f || f >= 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than 1");
        }
        if (expected < 0) {
            throw new IllegalArgumentException("The expected number of elements must be nonnegative");
        }
        this.f = f;
        this.minN = this.n = HashCommon.INSTANCE.arraySize(expected, f);
        this.mask = this.n - 1;
        this.maxFill = HashCommon.INSTANCE.maxFill(this.n, f);
        this.key = new long[this.n + 1];
    }

    public /* synthetic */ LongOpenHashSet(int n, float f, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 16;
        }
        if ((n2 & 2) != 0) {
            f = 0.75f;
        }
        this(n, f);
    }

    @Override
    public int getSize() {
        return this.size;
    }

    public void setSize(int n) {
        this.size = n;
    }

    @Override
    @NotNull
    public MutableLongIterator getValues() {
        return new SetIterator();
    }

    private final int realSize() {
        return this.containsNull ? this.getSize() - 1 : this.getSize();
    }

    /*
     * WARNING - void declaration
     */
    public boolean add(long element) {
        int pos = 0;
        if (element == 0L) {
            if (this.containsNull) {
                return false;
            }
            this.containsNull = true;
        } else {
            block7: {
                long l;
                void it;
                int n;
                long curr = 0L;
                long[] key2 = this.key;
                int n2 = n = (int)HashCommon.INSTANCE.mix(element) & this.mask;
                long[] lArray = key2;
                boolean bl = false;
                pos = it;
                long it32 = l = lArray[n];
                boolean bl2 = false;
                curr = it32;
                if (l != 0L) {
                    if (curr == element) {
                        return false;
                    }
                    do {
                        int n3;
                        int it32 = n3 = pos + 1 & this.mask;
                        lArray = key2;
                        boolean bl3 = false;
                        pos = it32;
                        it32 = l = lArray[n3];
                        boolean bl4 = false;
                        curr = it32;
                        if (l == 0L) break block7;
                    } while (curr != element);
                    return false;
                }
            }
            key2[pos] = element;
        }
        int n = this.getSize();
        this.setSize(n + 1);
        if (n >= this.maxFill) {
            this.rehash(HashCommon.INSTANCE.arraySize(this.getSize() + 1, this.f));
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean contains(long element) {
        long l;
        void it;
        int n;
        if (element == 0L) {
            return this.containsNull;
        }
        long curr = 0L;
        long[] key2 = this.key;
        int pos = 0;
        int n2 = n = (int)HashCommon.INSTANCE.mix(element) & this.mask;
        long[] lArray = key2;
        boolean bl = false;
        pos = it;
        long it32 = l = lArray[n];
        boolean bl2 = false;
        curr = it32;
        if (l == 0L) {
            return false;
        }
        if (element == curr) {
            return true;
        }
        do {
            int n3;
            int it32 = n3 = pos + 1 & this.mask;
            lArray = key2;
            boolean bl3 = false;
            pos = it32;
            it32 = l = lArray[n3];
            boolean bl4 = false;
            curr = it32;
            if (l != 0L) continue;
            return false;
        } while (element != curr);
        return true;
    }

    private final void rehash(int newN) {
        long[] key2 = this.key;
        int mask = newN - 1;
        long[] newKey = new long[newN + 1];
        int i2 = this.n;
        int pos = 0;
        int j = this.realSize();
        while (j-- != 0) {
            int it;
            int n;
            while (key2[--i2] == 0L) {
            }
            int n2 = n = (int)HashCommon.INSTANCE.mix(key2[i2]) & mask;
            long[] lArray = newKey;
            boolean bl = false;
            pos = it;
            if (lArray[n] != 0L) {
                do {
                    it = n = pos + 1 & mask;
                    lArray = newKey;
                    boolean bl2 = false;
                    pos = it;
                } while (lArray[n] != 0L);
            }
            newKey[pos] = key2[i2];
        }
        this.n = newN;
        this.mask = mask;
        this.maxFill = HashCommon.INSTANCE.maxFill(this.n, this.f);
        this.key = newKey;
    }

    public boolean equals(@Nullable Object other) {
        if (other == null) {
            return false;
        }
        if (super.equals(other)) {
            return true;
        }
        if (other instanceof LongSet) {
            if (((LongSet)other).getSize() != this.getSize()) {
                return false;
            }
            return LongSetExtensionsKt.containsAll(this, (LongSet)other);
        }
        return false;
    }

    public int hashCode() {
        int h = 0;
        long[] key2 = this.key;
        int j = this.realSize();
        int i2 = 0;
        while (j-- != 0) {
            while (key2[i2] == 0L) {
                ++i2;
            }
            h += (int)key2[i2];
            ++i2;
        }
        return h;
    }

    public LongOpenHashSet() {
        this(0, 0.0f, 3, null);
    }

    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @SourceDebugExtension(value={"SMAP\nLongOpenHashSet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LongOpenHashSet.kt\nfleet/fastutil/longs/LongOpenHashSet$SetIterator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,548:1\n1#2:549\n*E\n"})
    private final class SetIterator
    implements MutableLongIterator {
        private int pos;
        private int last;
        private int c;
        private boolean mustReturnNull;
        public LongArrayList wrapped;

        public SetIterator() {
            this.pos = LongOpenHashSet.this.n;
            this.last = -1;
            this.c = LongOpenHashSet.this.getSize();
            this.mustReturnNull = LongOpenHashSet.this.containsNull;
        }

        @NotNull
        public final LongArrayList getWrapped() {
            LongArrayList longArrayList = this.wrapped;
            if (longArrayList != null) {
                return longArrayList;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"wrapped");
            return null;
        }

        @Override
        public boolean hasNext() {
            return this.c != 0;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public long next() {
            void it;
            int n;
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int n2 = this.c;
            this.c = n2 + -1;
            long[] key2 = LongOpenHashSet.this.key;
            if (this.mustReturnNull) {
                this.mustReturnNull = false;
                this.last = LongOpenHashSet.this.n;
                return key2[LongOpenHashSet.this.n];
            }
            do {
                this.pos += -1;
                if (this.pos >= 0) continue;
                this.last = Integer.MIN_VALUE;
                return this.getWrapped().get(-this.pos - 1);
            } while (key2[this.pos] == 0L);
            int n3 = n = this.pos;
            long[] lArray = key2;
            boolean bl = false;
            this.last = it;
            return lArray[n];
        }
    }
}

