/*
 * Decompiled with CFR 0.152.
 */
package fleet.fastutil.ints;

import fleet.fastutil.HashCommon;
import fleet.fastutil.ints.IntArrayList;
import fleet.fastutil.ints.IntEntry;
import fleet.fastutil.ints.IntMap;
import fleet.fastutil.ints.MutableIntMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nInt2ObjectOpenHashMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Int2ObjectOpenHashMap.kt\nfleet/fastutil/ints/Int2ObjectOpenHashMap\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,597:1\n1#2:598\n*E\n"})
public final class Int2ObjectOpenHashMap<V>
implements MutableIntMap<V> {
    @NotNull
    private int[] key;
    @NotNull
    private V[] value;
    private int mask;
    private boolean containsNullKey;
    private int n;
    private int maxFill;
    private int minN;
    private int size;
    private float f;
    @Nullable
    private V defaultValue;

    @Override
    public int getSize() {
        return this.size;
    }

    public void setSize(int n) {
        this.size = n;
    }

    @NotNull
    public Iterator<IntEntry<V>> getEntries() {
        return new EntryIterator();
    }

    @NotNull
    public Iterator<V> getValues() {
        return new ValueIterator();
    }

    public Int2ObjectOpenHashMap(int expected, float f) {
        if (f <= 0.0f || f >= 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than 1");
        }
        if (expected < 0) {
            throw new IllegalArgumentException("The expected number of elements must be nonnegative");
        }
        this.f = f;
        this.minN = this.n = HashCommon.INSTANCE.arraySize(expected, f);
        this.mask = this.n - 1;
        this.maxFill = HashCommon.INSTANCE.maxFill(this.n, f);
        this.key = new int[this.n + 1];
        this.value = new Object[this.n + 1];
    }

    public Int2ObjectOpenHashMap() {
        this(16, 0.75f);
    }

    public Int2ObjectOpenHashMap(int expected) {
        this(expected, 0.75f);
    }

    public Int2ObjectOpenHashMap(@NotNull Int2ObjectOpenHashMap<V> m, float f) {
        Intrinsics.checkNotNullParameter(m, (String)"m");
        this(m.getSize(), f);
        this.putAll(m);
    }

    public /* synthetic */ Int2ObjectOpenHashMap(Int2ObjectOpenHashMap int2ObjectOpenHashMap, float f, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            f = 0.75f;
        }
        this(int2ObjectOpenHashMap, f);
    }

    public final boolean isEmpty() {
        return this.getSize() == 0;
    }

    private final int realSize() {
        return this.containsNullKey ? this.getSize() - 1 : this.getSize();
    }

    private final void ensureCapacity(int capacity) {
        int needed = HashCommon.INSTANCE.arraySize(capacity, this.f);
        if (needed > this.n) {
            this.rehash(needed);
        }
    }

    private final void tryCapacity(long capacity) {
        int needed = Math.min(0x40000000, Math.max(2, HashCommon.INSTANCE.nextPowerOfTwo((int)Math.ceil((float)capacity / this.f))));
        if (needed > this.n) {
            this.rehash(needed);
        }
    }

    private final V removeEntry(int pos) {
        V oldValue = this.value[pos];
        this.value[pos] = null;
        int n = this.getSize();
        this.setSize(n + -1);
        this.shiftKeys(pos);
        if (this.n > this.minN && this.getSize() < this.maxFill / 4 && this.n > 16) {
            this.rehash(this.n / 2);
        }
        return oldValue;
    }

    private final V removeNullEntry() {
        this.containsNullKey = false;
        V oldValue = this.value[this.n];
        this.value[this.n] = null;
        int n = this.getSize();
        this.setSize(n + -1);
        if (this.n > this.minN && this.getSize() < this.maxFill / 4 && this.n > 16) {
            this.rehash(this.n / 2);
        }
        V v = oldValue;
        Intrinsics.checkNotNull(v);
        return v;
    }

    public final void putAll(@NotNull Int2ObjectOpenHashMap<V> from) {
        Intrinsics.checkNotNullParameter(from, (String)"from");
        if ((double)this.f <= 0.5) {
            this.ensureCapacity(from.getSize());
        } else {
            this.tryCapacity(this.getSize() + from.getSize());
        }
        int n = from.getSize();
        Iterator<IntEntry<V>> i2 = from.getEntries();
        IntEntry<V> e = null;
        while (n-- != 0) {
            e = i2.next();
            this.put(e.getKey(), e.getValue());
        }
    }

    private final int find(int k) {
        int it;
        int n;
        if (k == 0) {
            return this.containsNullKey ? this.n : -(this.n + 1);
        }
        int curr = 0;
        int[] key2 = this.key;
        int pos = 0;
        int n2 = n = HashCommon.INSTANCE.mix(k) & this.mask;
        int[] nArray = key2;
        boolean bl = false;
        pos = it;
        it = n = nArray[n];
        boolean bl2 = false;
        curr = it;
        if (n == 0) {
            return -(pos + 1);
        }
        if (k == curr) {
            return pos;
        }
        do {
            it = n = pos + 1 & this.mask;
            nArray = key2;
            boolean bl3 = false;
            pos = it;
            it = n = nArray[n];
            boolean bl4 = false;
            curr = it;
            if (n != 0) continue;
            return -(pos + 1);
        } while (k != curr);
        return pos;
    }

    private final void insert(int pos, int k, V v) {
        if (pos == this.n) {
            this.containsNullKey = true;
        }
        this.key[pos] = k;
        this.value[pos] = v;
        int n = this.getSize();
        this.setSize(n + 1);
        if (n >= this.maxFill) {
            this.rehash(HashCommon.INSTANCE.arraySize(this.getSize() + 1, this.f));
        }
    }

    @Override
    @Nullable
    public V put(int key2, V value2) {
        int pos = this.find(key2);
        if (pos < 0) {
            this.insert(-pos - 1, key2, value2);
            return this.defaultReturnValue();
        }
        V oldValue = this.value[pos];
        this.value[pos] = value2;
        this.key[pos] = key2;
        return oldValue;
    }

    private final void shiftKeys(int pos) {
        int pos2 = pos;
        int last = 0;
        int slot = 0;
        int curr = 0;
        int[] key2 = this.key;
        V[] value2 = this.value;
        while (true) {
            int n;
            int it = n = pos2;
            boolean bl = false;
            last = it;
            pos2 = n + 1 & this.mask;
            while (true) {
                it = n = key2[pos2];
                boolean bl2 = false;
                curr = it;
                if (n == 0) {
                    key2[last] = 0;
                    value2[last] = null;
                    return;
                }
                slot = HashCommon.INSTANCE.mix(curr) & this.mask;
                if (last <= pos2 ? last >= slot || slot > pos2 : (pos2 + 1 <= slot ? slot <= last : false)) break;
                pos2 = pos2 + 1 & this.mask;
            }
            key2[last] = curr;
            value2[last] = value2[pos2];
        }
    }

    @Override
    @Nullable
    public V remove(int k) {
        int it;
        int n;
        if (k == 0) {
            if (this.containsNullKey) {
                return this.removeNullEntry();
            }
            return this.defaultReturnValue();
        }
        int curr = 0;
        int[] key2 = this.key;
        int pos = 0;
        int n2 = n = HashCommon.INSTANCE.mix(k) & this.mask;
        int[] nArray = key2;
        boolean bl = false;
        pos = it;
        it = n = nArray[n];
        boolean bl2 = false;
        curr = it;
        if (n == 0) {
            return this.defaultReturnValue();
        }
        if (k == curr) {
            return this.removeEntry(pos);
        }
        do {
            it = n = pos + 1 & this.mask;
            nArray = key2;
            boolean bl3 = false;
            pos = it;
            it = n = nArray[n];
            boolean bl4 = false;
            curr = it;
            if (n != 0) continue;
            return this.defaultReturnValue();
        } while (k != curr);
        return this.removeEntry(pos);
    }

    @Override
    @Nullable
    public V get(int k) {
        int it;
        int n;
        if (k == 0) {
            return this.containsNullKey ? this.value[this.n] : this.defaultReturnValue();
        }
        int curr = 0;
        int[] key2 = this.key;
        int pos = 0;
        int n2 = n = HashCommon.INSTANCE.mix(k) & this.mask;
        int[] nArray = key2;
        boolean bl = false;
        pos = it;
        it = n = nArray[n];
        boolean bl2 = false;
        curr = it;
        if (n == 0) {
            return this.defaultReturnValue();
        }
        if (k == curr) {
            return this.value[pos];
        }
        do {
            it = n = pos + 1 & this.mask;
            nArray = key2;
            boolean bl3 = false;
            pos = it;
            it = n = nArray[n];
            boolean bl4 = false;
            curr = it;
            if (n != 0) continue;
            return this.defaultReturnValue();
        } while (k != curr);
        return this.value[pos];
    }

    public final boolean containsKey(int k) {
        int it;
        int n;
        if (k == 0) {
            return this.containsNullKey;
        }
        int curr = 0;
        int[] key2 = this.key;
        int pos = 0;
        int n2 = n = HashCommon.INSTANCE.mix(k) & this.mask;
        int[] nArray = key2;
        boolean bl = false;
        pos = it;
        it = n = nArray[n];
        boolean bl2 = false;
        curr = it;
        if (n == 0) {
            return false;
        }
        if (k == curr) {
            return true;
        }
        do {
            it = n = pos + 1 & this.mask;
            nArray = key2;
            boolean bl3 = false;
            pos = it;
            it = n = nArray[n];
            boolean bl4 = false;
            curr = it;
            if (n != 0) continue;
            return false;
        } while (k != curr);
        return true;
    }

    @Nullable
    public final V defaultReturnValue() {
        return this.defaultValue;
    }

    private final void rehash(int newN) {
        int[] key2 = this.key;
        V[] value2 = this.value;
        int mask = newN - 1;
        int[] newKey = new int[newN + 1];
        Object[] newValue = new Object[newN + 1];
        int i2 = this.n;
        int pos = 0;
        int j = this.realSize();
        while (j-- != 0) {
            int it;
            int n;
            while (key2[--i2] == 0) {
            }
            int n2 = n = HashCommon.INSTANCE.mix(key2[i2]) & mask;
            int[] nArray = newKey;
            boolean bl = false;
            pos = it;
            if (nArray[n] != 0) {
                do {
                    it = n = pos + 1 & mask;
                    nArray = newKey;
                    boolean bl2 = false;
                    pos = it;
                } while (nArray[n] != 0);
            }
            newKey[pos] = key2[i2];
            newValue[pos] = value2[i2];
        }
        newValue[newN] = value2[this.n];
        this.n = newN;
        this.mask = mask;
        this.maxFill = HashCommon.INSTANCE.maxFill(this.n, this.f);
        this.key = newKey;
        this.value = newValue;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IntMap)) {
            return false;
        }
        if (this.getSize() != ((IntMap)o).getSize()) {
            return false;
        }
        Iterator<IntEntry<V>> iterator2 = this.getEntries();
        while (iterator2.hasNext()) {
            IntEntry<V> intEntry = iterator2.next();
            int key2 = intEntry.component1();
            V value2 = intEntry.component2();
            if (Intrinsics.areEqual(((IntMap)o).get(key2), value2)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int h = 0;
        int[] key2 = this.key;
        V[] value2 = this.value;
        int j = this.realSize();
        int i2 = 0;
        int t2 = 0;
        while (j-- != 0) {
            while (key2[i2] == 0) {
                ++i2;
            }
            t2 = key2[i2];
            if (this != value2[i2]) {
                int n;
                if (value2[i2] == null) {
                    n = 0;
                } else {
                    V v = value2[i2];
                    n = v != null ? v.hashCode() : 0;
                }
                t2 ^= n;
            }
            h += t2;
            ++i2;
        }
        if (this.containsNullKey) {
            int n;
            if (value2[this.n] == null) {
                n = 0;
            } else {
                V v = value2[this.n];
                n = v != null ? v.hashCode() : 0;
            }
            h += n;
        }
        return h;
    }

    @Override
    @Nullable
    public V set(int key2, V value2) {
        return MutableIntMap.super.set(key2, value2);
    }

    private final class EntryIterator
    extends MapIterator
    implements Iterator,
    KMappedMarker {
        @NotNull
        public IntEntry<V> next() {
            int nextIndex = this.nextEntry();
            int n = Int2ObjectOpenHashMap.this.key[nextIndex];
            Object object = Int2ObjectOpenHashMap.this.value[nextIndex];
            Intrinsics.checkNotNull((Object)object);
            return new IntEntry<Object>(n, object);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }
    }

    @SourceDebugExtension(value={"SMAP\nInt2ObjectOpenHashMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Int2ObjectOpenHashMap.kt\nfleet/fastutil/ints/Int2ObjectOpenHashMap$MapIterator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,597:1\n1#2:598\n*E\n"})
    private abstract class MapIterator {
        private int pos;
        private int last;
        private int c;
        private boolean mustReturnNullKey;
        @Nullable
        private IntArrayList wrapped;

        public MapIterator() {
            this.pos = Int2ObjectOpenHashMap.this.n;
            this.last = -1;
            this.c = Int2ObjectOpenHashMap.this.getSize();
            this.mustReturnNullKey = Int2ObjectOpenHashMap.this.containsNullKey;
        }

        public final boolean hasNext() {
            return this.c != 0;
        }

        public final int nextEntry() {
            int n;
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int n2 = this.c;
            this.c = n2 + -1;
            if (this.mustReturnNullKey) {
                this.mustReturnNullKey = false;
                int it = n2 = Int2ObjectOpenHashMap.this.n;
                boolean bl = false;
                this.last = it;
                return n2;
            }
            int[] key2 = Int2ObjectOpenHashMap.this.key;
            do {
                this.pos += -1;
                if (this.pos >= 0) continue;
                this.last = Integer.MIN_VALUE;
                if (this.wrapped == null) {
                    throw new IllegalStateException();
                }
                IntArrayList intArrayList = this.wrapped;
                Intrinsics.checkNotNull((Object)intArrayList);
                int k = intArrayList.get(-this.pos - 1);
                int p = HashCommon.INSTANCE.mix(k) & Int2ObjectOpenHashMap.this.mask;
                while (k != key2[p]) {
                    p = p + 1 & Int2ObjectOpenHashMap.this.mask;
                }
                return p;
            } while (key2[this.pos] == 0);
            int it = n = this.pos;
            boolean bl = false;
            this.last = it;
            return n;
        }
    }

    private final class ValueIterator
    extends MapIterator
    implements Iterator,
    KMappedMarker {
        public V next() {
            Object object = Int2ObjectOpenHashMap.this.value[this.nextEntry()];
            Intrinsics.checkNotNull((Object)object);
            return object;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }
    }
}

