/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.webserver;

import com.jetbrains.toolbox.Build;
import com.jetbrains.toolbox.BuildNumber;
import com.jetbrains.toolbox.UIGlobalState;
import com.jetbrains.toolbox.UIModalState;
import com.jetbrains.toolbox.common.RateLimiter;
import com.jetbrains.toolbox.feed.ApplicationType;
import com.jetbrains.toolbox.manager.tool.ToolManager;
import com.jetbrains.toolbox.tools.model.AvailableBuild;
import com.jetbrains.toolbox.tools.model.AvailableTools;
import com.jetbrains.toolbox.tools.model.ChannelState;
import com.jetbrains.toolbox.tools.model.ToolBuild;
import com.jetbrains.toolbox.tools.model.ToolWithVersions;
import com.jetbrains.toolbox.tools.model.VersionWithBuilds;
import com.jetbrains.toolbox.webserver.Webserver;
import com.jetbrains.toolbox.webserver.WebserverExtension;
import fi.iki.elonen.NanoHTTPD;
import java.io.Closeable;
import java.util.List;
import java.util.Map;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;
import org.tinylog.kotlin.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@SourceDebugExtension(value={"SMAP\nWebserverImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebserverImpl.kt\ncom/jetbrains/toolbox/webserver/WebserverImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,136:1\n295#2,2:137\n1#3:139\n*S KotlinDebug\n*F\n+ 1 WebserverImpl.kt\ncom/jetbrains/toolbox/webserver/WebserverImpl\n*L\n66#1:137,2\n*E\n"})
public final class WebserverImpl
extends NanoHTTPD
implements Webserver,
Closeable {
    @NotNull
    private final ToolManager toolManager;
    @NotNull
    private final StateFlow<AvailableTools> availableTools;
    @NotNull
    private final UIGlobalState uiGlobalState;
    @NotNull
    private final RateLimiter rateLimiter;
    @NotNull
    private final List<WebserverExtension> extensions;

    public WebserverImpl(@NotNull ToolManager toolManager, @NotNull StateFlow<AvailableTools> availableTools2, @NotNull UIGlobalState uiGlobalState, @NotNull RateLimiter rateLimiter, int port2, @NotNull List<? extends WebserverExtension> extensions) {
        Intrinsics.checkNotNullParameter((Object)toolManager, (String)"toolManager");
        Intrinsics.checkNotNullParameter(availableTools2, (String)"availableTools");
        Intrinsics.checkNotNullParameter((Object)uiGlobalState, (String)"uiGlobalState");
        Intrinsics.checkNotNullParameter((Object)rateLimiter, (String)"rateLimiter");
        Intrinsics.checkNotNullParameter(extensions, (String)"extensions");
        super("localhost", port2);
        this.toolManager = toolManager;
        this.availableTools = availableTools2;
        this.uiGlobalState = uiGlobalState;
        this.rateLimiter = rateLimiter;
        this.extensions = extensions;
        try {
            this.start(5000, false);
            Logger.INSTANCE.debug(() -> WebserverImpl._init_$lambda$0(port2));
        }
        catch (Throwable t2) {
            Logger.INSTANCE.error(t2, "Failed to create built-in webserver");
        }
    }

    @NotNull
    public NanoHTTPD.Response serve(@NotNull NanoHTTPD.IHTTPSession session2) {
        NanoHTTPD.Response responseFromExtensions;
        String origin;
        block16: {
            NanoHTTPD.Response response2;
            List path2;
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            if (!this.rateLimiter.ensureRateLimit()) {
                NanoHTTPD.Response response3 = NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.TOO_MANY_REQUESTS), (String)"text/plain", (String)"Too many requests");
                Intrinsics.checkNotNullExpressionValue((Object)response3, (String)"newFixedLengthResponse(...)");
                return response3;
            }
            origin = (String)session2.getHeaders().get("origin");
            if (!this.isValidOrigin(origin)) {
                NanoHTTPD.Response response4 = NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.FORBIDDEN), (String)"text/plain", (String)"Forbidden");
                Intrinsics.checkNotNullExpressionValue((Object)response4, (String)"newFixedLengthResponse(...)");
                return response4;
            }
            Logger.INSTANCE.debug("Serving " + session2.getMethod().name() + " " + session2.getUri());
            if (session2.getMethod() == NanoHTTPD.Method.OPTIONS) {
                NanoHTTPD.Response response5 = NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.NO_CONTENT), (String)"", (String)"");
                Intrinsics.checkNotNullExpressionValue((Object)response5, (String)"newFixedLengthResponse(...)");
                return this.addCORS(response5, origin);
            }
            if (session2.getMethod() == NanoHTTPD.Method.GET && Intrinsics.areEqual((Object)session2.getUri(), (Object)"/version")) {
                NanoHTTPD.Response response6 = NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK), (String)"application/json", (String)("{\"build\":\"" + BuildNumber.toString-impl(Build.INSTANCE.getBuildNumber-Y_E1uuk()) + "\"}"));
                Intrinsics.checkNotNullExpressionValue((Object)response6, (String)"newFixedLengthResponse(...)");
                return this.addCORS(response6, origin);
            }
            String string = session2.getUri();
            if (string != null) {
                char[] cArray = new char[]{'/'};
                v5 = StringsKt.split$default((CharSequence)string, (char[])cArray, (boolean)false, (int)0, (int)6, null);
            } else {
                v5 = path2 = null;
            }
            if (session2.getMethod() == NanoHTTPD.Method.GET && path2 != null && path2.size() == 4 && Intrinsics.areEqual(path2.get(0), (Object)"") && Intrinsics.areEqual(path2.get(1), (Object)"install")) {
                Object v6;
                String buildNumber;
                String applicationType;
                block15: {
                    applicationType = ApplicationType.constructor-impl((String)path2.get(2));
                    buildNumber = BuildNumber.constructor-impl((String)path2.get(3));
                    Iterable $this$firstOrNull$iv = ((Map)this.toolManager.getModel().getValue()).values();
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        ChannelState it = (ChannelState)element$iv;
                        boolean bl = false;
                        if (!(ApplicationType.equals-impl0(it.getTool().getToolId-UtVBrGo(), applicationType) && BuildNumber.equals-impl0(it.getTool().getBuildNumber-Y_E1uuk(), buildNumber))) continue;
                        v6 = element$iv;
                        break block15;
                    }
                    v6 = null;
                }
                ChannelState existing = v6;
                if (existing instanceof ChannelState.Installing) {
                    Logger.INSTANCE.info("Requested application and build is already installing: " + ApplicationType.toString-impl(applicationType) + " " + BuildNumber.toString-impl(buildNumber));
                    NanoHTTPD.Response response7 = NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.CONFLICT), (String)"text/plain", (String)"Busy");
                    Intrinsics.checkNotNullExpressionValue((Object)response7, (String)"newFixedLengthResponse(...)");
                    return this.addCORS(response7, origin);
                }
                if (existing != null) {
                    Logger.INSTANCE.info("Requested application and build is already installed: " + ApplicationType.toString-impl(applicationType) + " " + BuildNumber.toString-impl(buildNumber));
                    NanoHTTPD.Response response8 = NanoHTTPD.newFixedLengthResponse((String)"OK");
                    Intrinsics.checkNotNullExpressionValue((Object)response8, (String)"newFixedLengthResponse(...)");
                    return this.addCORS(response8, origin);
                }
                ToolBuild toolBuild = this.findAvailableTool-dgXOpgo(applicationType, buildNumber);
                if (toolBuild != null) {
                    NanoHTTPD.Response response9;
                    Logger.INSTANCE.info("Prompt user to install " + toolBuild);
                    this.uiGlobalState.updateState((Function1<? super UIModalState, ? extends UIModalState>)((Function1)arg_0 -> WebserverImpl.serve$lambda$2(toolBuild, arg_0)));
                    if (this.uiGlobalState.getState().getValue() instanceof UIModalState.FeedjetItem) {
                        NanoHTTPD.Response response10 = NanoHTTPD.newFixedLengthResponse((String)"OK");
                        Intrinsics.checkNotNullExpressionValue((Object)response10, (String)"newFixedLengthResponse(...)");
                        response9 = this.addCORS(response10, origin);
                    } else {
                        Logger.INSTANCE.error("UI is not in the normal state: " + this.uiGlobalState.getState().getValue());
                        NanoHTTPD.Response response11 = NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.CONFLICT), (String)"text/plain", (String)"Busy");
                        Intrinsics.checkNotNullExpressionValue((Object)response11, (String)"newFixedLengthResponse(...)");
                        response9 = this.addCORS(response11, origin);
                    }
                    return response9;
                }
                Logger.INSTANCE.warn("Requested application and build not found: " + ApplicationType.toString-impl(applicationType) + " " + BuildNumber.toString-impl(buildNumber));
            }
            for (WebserverExtension it : (Iterable)this.extensions) {
                boolean bl = false;
                NanoHTTPD.Response response12 = it.tryProcessSession(session2);
                if (response12 == null) continue;
                response2 = response12;
                break block16;
            }
            response2 = responseFromExtensions = null;
        }
        if (responseFromExtensions != null) {
            return this.addCORS(responseFromExtensions, origin);
        }
        NanoHTTPD.Response response13 = NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.NOT_FOUND), (String)"text/plain", (String)"Not Found");
        Intrinsics.checkNotNullExpressionValue((Object)response13, (String)"newFixedLengthResponse(...)");
        return this.addCORS(response13, origin);
    }

    private final ToolBuild findAvailableTool-dgXOpgo(String applicationType, String buildNumber) {
        ToolWithVersions toolWithVersions = ((AvailableTools)this.availableTools.getValue()).getTools().get(ApplicationType.box-impl(applicationType));
        if (toolWithVersions == null) {
            return null;
        }
        ToolWithVersions app = toolWithVersions;
        for (VersionWithBuilds version : app.getVersions()) {
            for (AvailableBuild build2 : version.getBuilds()) {
                if (!BuildNumber.equals-impl0(build2.getId-Y_E1uuk(), buildNumber)) continue;
                return new ToolBuild(app.getTool(), version.getVersion(), build2);
            }
        }
        return null;
    }

    private final boolean isValidOrigin(String origin) {
        String string = origin;
        if (!(string != null ? StringsKt.startsWith$default((String)string, (String)"https://", (boolean)false, (int)2, null) : false)) {
            return false;
        }
        return StringsKt.endsWith$default((String)origin, (String)".toolbox.app", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)origin, (String)".jetbrains.com", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)origin, (String)".intellij.net", (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)origin, (Object)"https://toolbox.app") || Intrinsics.areEqual((Object)origin, (Object)"https://jetbrains.com") || StringsKt.endsWith$default((String)origin, (String)".academy.labs.jb.gg", (boolean)false, (int)2, null);
    }

    private final NanoHTTPD.Response addCORS(NanoHTTPD.Response $this$addCORS, String origin) {
        if (this.isValidOrigin(origin)) {
            $this$addCORS.addHeader("Access-Control-Allow-Origin", origin);
            $this$addCORS.addHeader("Access-Control-Allow-Methods", "GET, OPTIONS");
            $this$addCORS.addHeader("Access-Control-Allow-Headers", "Content-Type");
        }
        return $this$addCORS;
    }

    @Override
    public void close() {
        this.stop();
    }

    private static final String _init_$lambda$0(int $port) {
        return "Webserver initialized on port " + $port;
    }

    private static final UIModalState serve$lambda$2(ToolBuild $toolBuild, UIModalState it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof UIModalState.Normal ? (UIModalState)new UIModalState.FeedjetItem($toolBuild) : it;
    }
}

